/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticfilesystem.model.DescribeMountTargetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeMountTargetsRequestMarshaller
implements Marshaller<Request<DescribeMountTargetsRequest>, DescribeMountTargetsRequest> {
    public Request<DescribeMountTargetsRequest> marshall(DescribeMountTargetsRequest describeMountTargetsRequest) {
        String fileSystemId;
        String marker;
        String maxItems;
        if (describeMountTargetsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeMountTargetsRequest, "AmazonElasticFileSystem");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2015-02-01/mount-targets";
        request.setResourcePath(uriResourcePath);
        String string = maxItems = describeMountTargetsRequest.getMaxItems() == null ? null : StringUtils.fromInteger((Integer)describeMountTargetsRequest.getMaxItems());
        if (maxItems != null) {
            request.addParameter("MaxItems", maxItems);
        }
        String string2 = marker = describeMountTargetsRequest.getMarker() == null ? null : StringUtils.fromString((String)describeMountTargetsRequest.getMarker());
        if (marker != null) {
            request.addParameter("Marker", marker);
        }
        String string3 = fileSystemId = describeMountTargetsRequest.getFileSystemId() == null ? null : StringUtils.fromString((String)describeMountTargetsRequest.getFileSystemId());
        if (fileSystemId != null) {
            request.addParameter("FileSystemId", fileSystemId);
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", "binary/octet-stream");
        }
        return request;
    }
}

