/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticfilesystem.model.FileSystemDescription;
import com.amazonaws.services.elasticfilesystem.model.transform.FileSystemSizeJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class FileSystemDescriptionJsonMarshaller {
    private static FileSystemDescriptionJsonMarshaller instance;

    public void marshall(FileSystemDescription fileSystemDescription, JSONWriter jsonWriter) {
        if (fileSystemDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (fileSystemDescription.getOwnerId() != null) {
                jsonWriter.key("OwnerId").value((Object)fileSystemDescription.getOwnerId());
            }
            if (fileSystemDescription.getCreationToken() != null) {
                jsonWriter.key("CreationToken").value((Object)fileSystemDescription.getCreationToken());
            }
            if (fileSystemDescription.getFileSystemId() != null) {
                jsonWriter.key("FileSystemId").value((Object)fileSystemDescription.getFileSystemId());
            }
            if (fileSystemDescription.getCreationTime() != null) {
                jsonWriter.key("CreationTime").value(fileSystemDescription.getCreationTime());
            }
            if (fileSystemDescription.getLifeCycleState() != null) {
                jsonWriter.key("LifeCycleState").value((Object)fileSystemDescription.getLifeCycleState());
            }
            if (fileSystemDescription.getName() != null) {
                jsonWriter.key("Name").value((Object)fileSystemDescription.getName());
            }
            if (fileSystemDescription.getNumberOfMountTargets() != null) {
                jsonWriter.key("NumberOfMountTargets").value((Object)fileSystemDescription.getNumberOfMountTargets());
            }
            if (fileSystemDescription.getSizeInBytes() != null) {
                jsonWriter.key("SizeInBytes");
                FileSystemSizeJsonMarshaller.getInstance().marshall(fileSystemDescription.getSizeInBytes(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static FileSystemDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new FileSystemDescriptionJsonMarshaller();
        }
        return instance;
    }
}

