/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableRequest
extends AmazonWebServiceRequest
implements Serializable {
    private ListWithAutoConstructFlag<AttributeDefinition> attributeDefinitions;
    private String tableName;
    private ListWithAutoConstructFlag<KeySchemaElement> keySchema;
    private ListWithAutoConstructFlag<LocalSecondaryIndex> localSecondaryIndexes;
    private ListWithAutoConstructFlag<GlobalSecondaryIndex> globalSecondaryIndexes;
    private ProvisionedThroughput provisionedThroughput;

    public CreateTableRequest() {
    }

    public CreateTableRequest(String tableName, List<KeySchemaElement> keySchema) {
        this.setTableName(tableName);
        this.setKeySchema(keySchema);
    }

    public CreateTableRequest(List<AttributeDefinition> attributeDefinitions, String tableName, List<KeySchemaElement> keySchema, ProvisionedThroughput provisionedThroughput) {
        this.setAttributeDefinitions(attributeDefinitions);
        this.setTableName(tableName);
        this.setKeySchema(keySchema);
        this.setProvisionedThroughput(provisionedThroughput);
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public void setAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        if (attributeDefinitions == null) {
            this.attributeDefinitions = null;
            return;
        }
        ListWithAutoConstructFlag attributeDefinitionsCopy = new ListWithAutoConstructFlag(attributeDefinitions.size());
        attributeDefinitionsCopy.addAll(attributeDefinitions);
        this.attributeDefinitions = attributeDefinitionsCopy;
    }

    public CreateTableRequest withAttributeDefinitions(AttributeDefinition ... attributeDefinitions) {
        if (this.getAttributeDefinitions() == null) {
            this.setAttributeDefinitions(new ArrayList<AttributeDefinition>(attributeDefinitions.length));
        }
        for (AttributeDefinition value : attributeDefinitions) {
            this.getAttributeDefinitions().add(value);
        }
        return this;
    }

    public CreateTableRequest withAttributeDefinitions(Collection<AttributeDefinition> attributeDefinitions) {
        if (attributeDefinitions == null) {
            this.attributeDefinitions = null;
        } else {
            ListWithAutoConstructFlag attributeDefinitionsCopy = new ListWithAutoConstructFlag(attributeDefinitions.size());
            attributeDefinitionsCopy.addAll(attributeDefinitions);
            this.attributeDefinitions = attributeDefinitionsCopy;
        }
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public CreateTableRequest withTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public void setKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
            return;
        }
        ListWithAutoConstructFlag keySchemaCopy = new ListWithAutoConstructFlag(keySchema.size());
        keySchemaCopy.addAll(keySchema);
        this.keySchema = keySchemaCopy;
    }

    public CreateTableRequest withKeySchema(KeySchemaElement ... keySchema) {
        if (this.getKeySchema() == null) {
            this.setKeySchema(new ArrayList<KeySchemaElement>(keySchema.length));
        }
        for (KeySchemaElement value : keySchema) {
            this.getKeySchema().add(value);
        }
        return this;
    }

    public CreateTableRequest withKeySchema(Collection<KeySchemaElement> keySchema) {
        if (keySchema == null) {
            this.keySchema = null;
        } else {
            ListWithAutoConstructFlag keySchemaCopy = new ListWithAutoConstructFlag(keySchema.size());
            keySchemaCopy.addAll(keySchema);
            this.keySchema = keySchemaCopy;
        }
        return this;
    }

    public List<LocalSecondaryIndex> getLocalSecondaryIndexes() {
        return this.localSecondaryIndexes;
    }

    public void setLocalSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes) {
        if (localSecondaryIndexes == null) {
            this.localSecondaryIndexes = null;
            return;
        }
        ListWithAutoConstructFlag localSecondaryIndexesCopy = new ListWithAutoConstructFlag(localSecondaryIndexes.size());
        localSecondaryIndexesCopy.addAll(localSecondaryIndexes);
        this.localSecondaryIndexes = localSecondaryIndexesCopy;
    }

    public CreateTableRequest withLocalSecondaryIndexes(LocalSecondaryIndex ... localSecondaryIndexes) {
        if (this.getLocalSecondaryIndexes() == null) {
            this.setLocalSecondaryIndexes(new ArrayList<LocalSecondaryIndex>(localSecondaryIndexes.length));
        }
        for (LocalSecondaryIndex value : localSecondaryIndexes) {
            this.getLocalSecondaryIndexes().add(value);
        }
        return this;
    }

    public CreateTableRequest withLocalSecondaryIndexes(Collection<LocalSecondaryIndex> localSecondaryIndexes) {
        if (localSecondaryIndexes == null) {
            this.localSecondaryIndexes = null;
        } else {
            ListWithAutoConstructFlag localSecondaryIndexesCopy = new ListWithAutoConstructFlag(localSecondaryIndexes.size());
            localSecondaryIndexesCopy.addAll(localSecondaryIndexes);
            this.localSecondaryIndexes = localSecondaryIndexesCopy;
        }
        return this;
    }

    public List<GlobalSecondaryIndex> getGlobalSecondaryIndexes() {
        return this.globalSecondaryIndexes;
    }

    public void setGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
        if (globalSecondaryIndexes == null) {
            this.globalSecondaryIndexes = null;
            return;
        }
        ListWithAutoConstructFlag globalSecondaryIndexesCopy = new ListWithAutoConstructFlag(globalSecondaryIndexes.size());
        globalSecondaryIndexesCopy.addAll(globalSecondaryIndexes);
        this.globalSecondaryIndexes = globalSecondaryIndexesCopy;
    }

    public CreateTableRequest withGlobalSecondaryIndexes(GlobalSecondaryIndex ... globalSecondaryIndexes) {
        if (this.getGlobalSecondaryIndexes() == null) {
            this.setGlobalSecondaryIndexes(new ArrayList<GlobalSecondaryIndex>(globalSecondaryIndexes.length));
        }
        for (GlobalSecondaryIndex value : globalSecondaryIndexes) {
            this.getGlobalSecondaryIndexes().add(value);
        }
        return this;
    }

    public CreateTableRequest withGlobalSecondaryIndexes(Collection<GlobalSecondaryIndex> globalSecondaryIndexes) {
        if (globalSecondaryIndexes == null) {
            this.globalSecondaryIndexes = null;
        } else {
            ListWithAutoConstructFlag globalSecondaryIndexesCopy = new ListWithAutoConstructFlag(globalSecondaryIndexes.size());
            globalSecondaryIndexesCopy.addAll(globalSecondaryIndexes);
            this.globalSecondaryIndexes = globalSecondaryIndexesCopy;
        }
        return this;
    }

    public ProvisionedThroughput getProvisionedThroughput() {
        return this.provisionedThroughput;
    }

    public void setProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
    }

    public CreateTableRequest withProvisionedThroughput(ProvisionedThroughput provisionedThroughput) {
        this.provisionedThroughput = provisionedThroughput;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttributeDefinitions() != null) {
            sb.append("AttributeDefinitions: " + this.getAttributeDefinitions() + ",");
        }
        if (this.getTableName() != null) {
            sb.append("TableName: " + this.getTableName() + ",");
        }
        if (this.getKeySchema() != null) {
            sb.append("KeySchema: " + this.getKeySchema() + ",");
        }
        if (this.getLocalSecondaryIndexes() != null) {
            sb.append("LocalSecondaryIndexes: " + this.getLocalSecondaryIndexes() + ",");
        }
        if (this.getGlobalSecondaryIndexes() != null) {
            sb.append("GlobalSecondaryIndexes: " + this.getGlobalSecondaryIndexes() + ",");
        }
        if (this.getProvisionedThroughput() != null) {
            sb.append("ProvisionedThroughput: " + this.getProvisionedThroughput());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttributeDefinitions() == null ? 0 : this.getAttributeDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getKeySchema() == null ? 0 : this.getKeySchema().hashCode());
        hashCode = 31 * hashCode + (this.getLocalSecondaryIndexes() == null ? 0 : this.getLocalSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + (this.getGlobalSecondaryIndexes() == null ? 0 : this.getGlobalSecondaryIndexes().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedThroughput() == null ? 0 : this.getProvisionedThroughput().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest)obj;
        if (other.getAttributeDefinitions() == null ^ this.getAttributeDefinitions() == null) {
            return false;
        }
        if (other.getAttributeDefinitions() != null && !other.getAttributeDefinitions().equals(this.getAttributeDefinitions())) {
            return false;
        }
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getKeySchema() == null ^ this.getKeySchema() == null) {
            return false;
        }
        if (other.getKeySchema() != null && !other.getKeySchema().equals(this.getKeySchema())) {
            return false;
        }
        if (other.getLocalSecondaryIndexes() == null ^ this.getLocalSecondaryIndexes() == null) {
            return false;
        }
        if (other.getLocalSecondaryIndexes() != null && !other.getLocalSecondaryIndexes().equals(this.getLocalSecondaryIndexes())) {
            return false;
        }
        if (other.getGlobalSecondaryIndexes() == null ^ this.getGlobalSecondaryIndexes() == null) {
            return false;
        }
        if (other.getGlobalSecondaryIndexes() != null && !other.getGlobalSecondaryIndexes().equals(this.getGlobalSecondaryIndexes())) {
            return false;
        }
        if (other.getProvisionedThroughput() == null ^ this.getProvisionedThroughput() == null) {
            return false;
        }
        return other.getProvisionedThroughput() == null || other.getProvisionedThroughput().equals(this.getProvisionedThroughput());
    }
}

