/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bec;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.bec.BecClientConfiguration;
import com.baidubce.services.bec.model.blb.CreateBecBlbBindingRequest;
import com.baidubce.services.bec.model.blb.CreateBecBlbBindingResponse;
import com.baidubce.services.bec.model.blb.CreateBecBlbMonitorPortRequest;
import com.baidubce.services.bec.model.blb.CreateBecBlbMonitorPortResponse;
import com.baidubce.services.bec.model.blb.CreateBecBlbRequest;
import com.baidubce.services.bec.model.blb.CreateBecBlbResponse;
import com.baidubce.services.bec.model.blb.DeleteBecBlbRequest;
import com.baidubce.services.bec.model.blb.DeleteBecBlbResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbBackendBindingStsListRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbBackendBindingStsListResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbBackendPodListRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbBackendPodListResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbBindingPodListWithStsRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbBindingPodListWithStsResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbInstanceRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbInstanceResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbMonitorPortDetailsRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbMonitorPortDetailsResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbMonitorPortListRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbMonitorPortListResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbResourceMetricsRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbResourceMetricsResponse;
import com.baidubce.services.bec.model.blb.GetBecBlbsRequest;
import com.baidubce.services.bec.model.blb.GetBecBlbsResponse;
import com.baidubce.services.bec.model.blb.UpdateBecBlbBindPodWeightRequest;
import com.baidubce.services.bec.model.blb.UpdateBecBlbBindPodWeightResponse;
import com.baidubce.services.bec.model.blb.UpdateBecBlbMonitorPortRequest;
import com.baidubce.services.bec.model.blb.UpdateBecBlbMonitorPortResponse;
import com.baidubce.services.bec.model.blb.UpdateBecBlbRequest;
import com.baidubce.services.bec.model.blb.UpdateBecBlbResponse;
import com.baidubce.services.bec.model.handler.BecHttpResponseHandler;
import com.baidubce.services.bec.model.overview.GetBecContainerMetricsRequest;
import com.baidubce.services.bec.model.overview.GetBecContainerMetricsResponse;
import com.baidubce.services.bec.model.overview.GetBecContainerSummaryRequest;
import com.baidubce.services.bec.model.overview.GetBecContainerSummaryResponse;
import com.baidubce.services.bec.model.overview.GetBecResourceSummaryRequest;
import com.baidubce.services.bec.model.overview.GetBecResourceSummaryResponse;
import com.baidubce.services.bec.model.overview.GetBecVMSummaryRequest;
import com.baidubce.services.bec.model.overview.GetBecVMSummaryResponse;
import com.baidubce.services.bec.model.overview.GetBecVmMetricsRequest;
import com.baidubce.services.bec.model.overview.GetBecVmMetricsResponse;
import com.baidubce.services.bec.model.resource.ListBecPassThroughDiskPackagesRequest;
import com.baidubce.services.bec.model.resource.ListBecPassThroughDiskPackagesResponse;
import com.baidubce.services.bec.model.resource.ListBecServicePackagesRequest;
import com.baidubce.services.bec.model.resource.ListBecServicePackagesResponse;
import com.baidubce.services.bec.model.vm.instance.DeleteBecVmInstanceRequest;
import com.baidubce.services.bec.model.vm.instance.DeleteBecVmInstanceResponse;
import com.baidubce.services.bec.model.vm.instance.GetBecNodeVmInstanceListRequest;
import com.baidubce.services.bec.model.vm.instance.GetBecNodeVmInstanceListResponse;
import com.baidubce.services.bec.model.vm.instance.GetBecVirtualMachineRequest;
import com.baidubce.services.bec.model.vm.instance.GetBecVirtualMachineResponse;
import com.baidubce.services.bec.model.vm.instance.GetBecVmConfigRequest;
import com.baidubce.services.bec.model.vm.instance.GetBecVmConfigResponse;
import com.baidubce.services.bec.model.vm.instance.GetBecVmInstanceListRequest;
import com.baidubce.services.bec.model.vm.instance.GetBecVmInstanceListResponse;
import com.baidubce.services.bec.model.vm.instance.GetBecVmInstanceMetricsRequest;
import com.baidubce.services.bec.model.vm.instance.GetBecVmInstanceMetricsResponse;
import com.baidubce.services.bec.model.vm.instance.OperateBecVmDeploymentRequest;
import com.baidubce.services.bec.model.vm.instance.OperateBecVmDeploymentResponse;
import com.baidubce.services.bec.model.vm.instance.ReinstallBecVmInstanceRequest;
import com.baidubce.services.bec.model.vm.instance.ReinstallBecVmInstanceResponse;
import com.baidubce.services.bec.model.vm.instance.UpdateBecVmDeploymentRequest;
import com.baidubce.services.bec.model.vm.instance.UpdateBecVmDeploymentResponse;
import com.baidubce.services.bec.model.vm.service.BecVmServiceActionRequest;
import com.baidubce.services.bec.model.vm.service.BecVmServiceActionResponse;
import com.baidubce.services.bec.model.vm.service.CreateBecVmServiceRequest;
import com.baidubce.services.bec.model.vm.service.CreateBecVmServiceResponse;
import com.baidubce.services.bec.model.vm.service.DelBecVmServiceRequest;
import com.baidubce.services.bec.model.vm.service.DelBecVmServiceResponse;
import com.baidubce.services.bec.model.vm.service.GetBecVmServiceMetricsRequest;
import com.baidubce.services.bec.model.vm.service.GetBecVmServiceMetricsResponse;
import com.baidubce.services.bec.model.vm.service.GetBecVmServiceRequest;
import com.baidubce.services.bec.model.vm.service.GetBecVmServiceResponse;
import com.baidubce.services.bec.model.vm.service.GetBecVmServicesRequest;
import com.baidubce.services.bec.model.vm.service.GetBecVmServicesResponse;
import com.baidubce.services.bec.model.vm.service.UpdateBecVmServiceRequest;
import com.baidubce.services.bec.model.vm.service.UpdateBecVmServiceResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class BecClient
extends AbstractBceClient {
    private static final String VERSION = "v1";
    private static final String OVERVIEW = "overview";
    private static final String SUMMARY = "summary";
    private static final String CONTAINER = "container";
    private static final String BLB_PREFIX = "blb";
    private static final String LB_PREFIX = "lb";
    private static final String VM_PREFIX = "vm";
    private static final String SERVICE = "service";
    private static final String INSTANCE = "instance";
    private static final String METRICS = "metrics";
    private static final String REGIONS = "regions";
    private static final String SERVICE_PROVIDER = "sps";
    private static final String CITIES = "cities";
    private static final String SYSTEM = "system";
    private static final String CONFIG = "config";
    private static final String REINSTALL = "reinstall";
    private static final String MONITOR = "monitor";
    private static final String RESOURCE = "resource";
    private static final String PACKAGE = "package";
    private static final String DISK = "disk";
    private static final String PASS_THROUGH = "passthrough";
    private static final String BINDED = "binded";
    private static final String BINDING = "binding";
    private static final String BINDINGPOD = "bindingpod";
    private static final String PORT = "port";
    private static final String CLIENT_TOKEN = "clientToken";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String OFFSET_IN_SECONDS_NULL_ERROR_MESSAGE = "offsetInSeconds should not be null.";
    private static final String BLB_ID_MESSAGE_KEY = "blbId";
    private static final String BLB_TYPE_MESSAGE_KEY = "type";
    private static final String VM_SERVICE_ID_MESSAGE_KEY = "serviceId";
    private static final String VM_ID_MESSAGE_KEY = "vmId";
    private static final String VM_INSTANCE_REGION_MESSAGE_KEY = "region";
    private static final String VM_INSTANCE_SPS_MESSAGE_KEY = "serviceProvider";
    private static final String VM_INSTANCE_CITY_MESSAGE_KEY = "city";
    private static final String VM_ACTION_MESSAGE_KEY = "action";
    private static final String METRICS_TYPE_MESSAGE_KEY = "metricsType";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host", "x-bce-date"};
    private static final HttpResponseHandler[] bec_handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BecHttpResponseHandler(), new BceJsonResponseHandler()};

    public BecClient() {
        this(new BecClientConfiguration());
    }

    public BecClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, bec_handlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    private String generateClientToken() {
        return UUID.randomUUID().toString();
    }

    public CreateBecVmServiceResponse createBecVmService(CreateBecVmServiceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, VM_PREFIX, SERVICE);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecVmServiceResponse.class);
    }

    public GetBecVmServicesResponse getBecVmServices(GetBecVmServicesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, SERVICE);
        if (StringUtils.isNotEmpty((CharSequence)request.getKeywordType())) {
            internalRequest.addParameter("keywordType", request.getKeywordType());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getKeyword())) {
            internalRequest.addParameter("keyword", request.getKeyword());
        }
        if (request.getPageNo() > 0) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getPageSize() > 0) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        return this.invokeHttpClient(internalRequest, GetBecVmServicesResponse.class);
    }

    public UpdateBecVmServiceResponse updateBecVmService(UpdateBecVmServiceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getServiceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_SERVICE_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VM_PREFIX, SERVICE, request.getServiceId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecVmServiceResponse.class);
    }

    public GetBecVmServiceResponse getBecVmService(GetBecVmServiceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getServiceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_SERVICE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, SERVICE, request.getServiceId());
        return this.invokeHttpClient(internalRequest, GetBecVmServiceResponse.class);
    }

    public BecVmServiceActionResponse becVmServiceAction(BecVmServiceActionRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getServiceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_SERVICE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAction(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ACTION_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VM_PREFIX, SERVICE, request.getServiceId(), request.getAction());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        return this.invokeHttpClient(internalRequest, BecVmServiceActionResponse.class);
    }

    public DelBecVmServiceResponse delBecVmService(DelBecVmServiceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getServiceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_SERVICE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, VM_PREFIX, SERVICE, request.getServiceId());
        return this.invokeHttpClient(internalRequest, DelBecVmServiceResponse.class);
    }

    public GetBecVmServiceMetricsResponse getBecVmServiceMetrics(GetBecVmServiceMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getServiceId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_SERVICE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(METRICS_TYPE_MESSAGE_KEY));
        Preconditions.checkNotNull((Object)request.getOffsetInSeconds(), (Object)OFFSET_IN_SECONDS_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, SERVICE, VM_PREFIX, request.getServiceId());
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceId())) {
            internalRequest.addParameter(VM_SERVICE_ID_MESSAGE_KEY, request.getServiceId());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter(METRICS_TYPE_MESSAGE_KEY, request.getType());
        }
        if (request.getOffsetInSeconds() > 0) {
            long end = Calendar.getInstance().getTimeInMillis() / 1000L;
            long start = end - (long)request.getOffsetInSeconds().intValue();
            internalRequest.addParameter("start", String.valueOf(start));
            internalRequest.addParameter("end", String.valueOf(end));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_SPS_MESSAGE_KEY, request.getServiceProvider());
        }
        return this.invokeHttpClient(internalRequest, GetBecVmServiceMetricsResponse.class);
    }

    public GetBecVmInstanceListResponse getBecVmInstanceList(GetBecVmInstanceListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, INSTANCE);
        if (request.getListRequest() != null) {
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeywordType())) {
                internalRequest.addParameter("keywordType", request.getListRequest().getKeywordType());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getKeyword())) {
                internalRequest.addParameter("keyword", request.getListRequest().getKeyword());
            }
            if (request.getListRequest().getPageNo() > 0) {
                internalRequest.addParameter("pageNo", String.valueOf(request.getListRequest().getPageNo()));
            }
            if (request.getListRequest().getPageSize() > 0) {
                internalRequest.addParameter("pageSize", String.valueOf(request.getListRequest().getPageSize()));
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getOrder())) {
                internalRequest.addParameter("order", request.getListRequest().getOrder());
            }
            if (StringUtils.isNotEmpty((CharSequence)request.getListRequest().getOrderBy())) {
                internalRequest.addParameter("orderBy", request.getListRequest().getOrderBy());
            }
        }
        return this.invokeHttpClient(internalRequest, GetBecVmInstanceListResponse.class);
    }

    public GetBecNodeVmInstanceListResponse getBecNodeVmInstanceList(GetBecNodeVmInstanceListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getRegion(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_INSTANCE_REGION_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getServiceProvider(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_INSTANCE_SPS_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getCity(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_INSTANCE_CITY_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, INSTANCE, REGIONS, request.getRegion(), SERVICE_PROVIDER, request.getServiceProvider(), CITIES, request.getCity());
        return this.invokeHttpClient(internalRequest, GetBecNodeVmInstanceListResponse.class);
    }

    public GetBecVirtualMachineResponse getBecVirtualMachine(GetBecVirtualMachineRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, INSTANCE, request.getVmID());
        return this.invokeHttpClient(internalRequest, GetBecVirtualMachineResponse.class);
    }

    public DeleteBecVmInstanceResponse deleteBecVmInstance(DeleteBecVmInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, VM_PREFIX, INSTANCE, request.getVmID());
        return this.invokeHttpClient(internalRequest, DeleteBecVmInstanceResponse.class);
    }

    public UpdateBecVmDeploymentResponse updateBecVmDeployment(UpdateBecVmDeploymentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VM_PREFIX, INSTANCE, request.getVmID());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecVmDeploymentResponse.class);
    }

    public ReinstallBecVmInstanceResponse reinstallBecVmInstance(ReinstallBecVmInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VM_PREFIX, INSTANCE, request.getVmID(), SYSTEM, REINSTALL);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ReinstallBecVmInstanceResponse.class);
    }

    public OperateBecVmDeploymentResponse operateBecVmDeployment(OperateBecVmDeploymentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getAction(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ACTION_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, VM_PREFIX, INSTANCE, request.getVmID(), request.getAction());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, OperateBecVmDeploymentResponse.class);
    }

    public GetBecVmInstanceMetricsResponse getBecVmInstanceMetrics(GetBecVmInstanceMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmId(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(METRICS_TYPE_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, VM_PREFIX, request.getVmId());
        if (StringUtils.isNotEmpty((CharSequence)request.getVmId())) {
            internalRequest.addParameter(VM_ID_MESSAGE_KEY, request.getVmId());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter(METRICS_TYPE_MESSAGE_KEY, request.getType());
        }
        if (request.getOffsetInSeconds() > 0) {
            long end = Calendar.getInstance().getTimeInMillis() / 1000L;
            long start = end - (long)request.getOffsetInSeconds().intValue();
            internalRequest.addParameter("start", String.valueOf(start));
            internalRequest.addParameter("end", String.valueOf(end));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_SPS_MESSAGE_KEY, request.getServiceProvider());
        }
        return this.invokeHttpClient(internalRequest, GetBecVmInstanceMetricsResponse.class);
    }

    public GetBecVmConfigResponse getBecVmConfig(GetBecVmConfigRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getVmID(), StringFormatUtils.checkEmptyExceptionMessageFormat(VM_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, VM_PREFIX, INSTANCE, request.getVmID(), CONFIG);
        return this.invokeHttpClient(internalRequest, GetBecVmConfigResponse.class);
    }

    public CreateBecBlbResponse createBecBlb(CreateBecBlbRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BLB_PREFIX);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecBlbResponse.class);
    }

    public GetBecBlbsResponse getBecBlbs(GetBecBlbsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX);
        if (StringUtils.isNotEmpty((CharSequence)request.getLbType())) {
            internalRequest.addParameter("lbType", request.getLbType());
        }
        if (request.getLbType() != null) {
            internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        }
        if (request.getLbType() != null) {
            internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        }
        return this.invokeHttpClient(internalRequest, GetBecBlbsResponse.class);
    }

    public GetBecBlbInstanceResponse getBecBlb(GetBecBlbInstanceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId());
        return this.invokeHttpClient(internalRequest, GetBecBlbInstanceResponse.class);
    }

    public DeleteBecBlbResponse deleteBecBlb(DeleteBecBlbRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, BLB_PREFIX, request.getBlbId());
        return this.invokeHttpClient(internalRequest, DeleteBecBlbResponse.class);
    }

    public UpdateBecBlbResponse updateBecBlb(UpdateBecBlbRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, BLB_PREFIX, request.getBlbId());
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecBlbResponse.class);
    }

    public CreateBecBlbMonitorPortResponse createBecBlbMonitorPort(CreateBecBlbMonitorPortRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BLB_PREFIX, request.getBlbId(), MONITOR);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecBlbMonitorPortResponse.class);
    }

    public GetBecBlbMonitorPortListResponse getBlbMonitorPortList(GetBecBlbMonitorPortListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId(), MONITOR);
        return this.invokeHttpClient(internalRequest, GetBecBlbMonitorPortListResponse.class);
    }

    public GetBecBlbMonitorPortDetailsResponse getBecBlbMonitorPortDetails(GetBecBlbMonitorPortDetailsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId(), MONITOR, PORT);
        if (request.getProtocol() != null) {
            internalRequest.addParameter("protocol", String.valueOf(request.getProtocol()));
        }
        if (request.getPort() != 0) {
            internalRequest.addParameter(PORT, String.valueOf(request.getPort()));
        }
        return this.invokeHttpClient(internalRequest, GetBecBlbMonitorPortDetailsResponse.class);
    }

    public UpdateBecBlbMonitorPortResponse updateBecBlbMonitorPort(UpdateBecBlbMonitorPortRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, BLB_PREFIX, request.getBlbId(), MONITOR);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecBlbMonitorPortResponse.class);
    }

    public GetBecBlbBackendPodListResponse getBecBlbBackendPodList(GetBecBlbBackendPodListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId(), BINDED);
        return this.invokeHttpClient(internalRequest, GetBecBlbBackendPodListResponse.class);
    }

    public GetBecBlbBackendBindingStsListResponse getBecBlbBackendBindingStsList(GetBecBlbBackendBindingStsListRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId(), BINDING);
        return this.invokeHttpClient(internalRequest, GetBecBlbBackendBindingStsListResponse.class);
    }

    public GetBecBlbBindingPodListWithStsResponse getBecBlbBindingPodListWithSts(GetBecBlbBindingPodListWithStsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, BLB_PREFIX, request.getBlbId(), BINDINGPOD);
        if (StringUtils.isNotEmpty((CharSequence)request.getStsName())) {
            internalRequest.addParameter("stsName", request.getStsName());
        }
        return this.invokeHttpClient(internalRequest, GetBecBlbBindingPodListWithStsResponse.class);
    }

    public CreateBecBlbBindingResponse createBecBlbBinding(CreateBecBlbBindingRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, BLB_PREFIX, request.getBlbId(), BINDING);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateBecBlbBindingResponse.class);
    }

    public UpdateBecBlbBindPodWeightResponse updateBecBlbBindPodWeight(UpdateBecBlbBindPodWeightRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        if (Strings.isNullOrEmpty((String)request.getClientToken())) {
            request.setClientToken(this.generateClientToken());
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, BLB_PREFIX, request.getBlbId(), BINDED);
        internalRequest.addParameter(CLIENT_TOKEN, request.getClientToken());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateBecBlbBindPodWeightResponse.class);
    }

    public GetBecBlbResourceMetricsResponse getBecBlbResourceMetrics(GetBecBlbResourceMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getBlbId(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(BLB_TYPE_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, LB_PREFIX, request.getBlbId());
        if (StringUtils.isNotEmpty((CharSequence)request.getIpType())) {
            internalRequest.addParameter(METRICS_TYPE_MESSAGE_KEY, request.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getIpType())) {
            internalRequest.addParameter("ipType", request.getIpType());
        }
        if (request.getOffsetInSeconds() != 0) {
            long end = Calendar.getInstance().getTimeInMillis() / 1000L;
            long start = end - (long)request.getOffsetInSeconds().intValue();
            internalRequest.addParameter("start", String.valueOf(start));
            internalRequest.addParameter("end", String.valueOf(end));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getPort())) {
            internalRequest.addParameter(PORT, request.getPort());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_SPS_MESSAGE_KEY, request.getServiceProvider());
        }
        return this.invokeHttpClient(internalRequest, GetBecBlbResourceMetricsResponse.class);
    }

    public GetBecResourceSummaryResponse getBecResourceSummary(GetBecResourceSummaryRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, OVERVIEW, SUMMARY);
        if (StringUtils.isNotEmpty((CharSequence)request.getRegion())) {
            internalRequest.addParameter(VM_INSTANCE_REGION_MESSAGE_KEY, request.getRegion());
        }
        return this.invokeHttpClient(internalRequest, GetBecResourceSummaryResponse.class);
    }

    public GetBecContainerSummaryResponse getBecContainerSummary(GetBecContainerSummaryRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, OVERVIEW, SUMMARY, CONTAINER);
        return this.invokeHttpClient(internalRequest, GetBecContainerSummaryResponse.class);
    }

    public GetBecVMSummaryResponse getBecVmSummary(GetBecVMSummaryRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, OVERVIEW, SUMMARY, VM_PREFIX);
        return this.invokeHttpClient(internalRequest, GetBecVMSummaryResponse.class);
    }

    public GetBecContainerMetricsResponse getBecContainerMetrics(GetBecContainerMetricsRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull((Object)request.getOffsetInSeconds(), (Object)OFFSET_IN_SECONDS_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(METRICS_TYPE_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, OVERVIEW, CONTAINER, request.getType());
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter(METRICS_TYPE_MESSAGE_KEY, request.getType());
        }
        if (request.getOffsetInSeconds() != null && request.getOffsetInSeconds() > 0) {
            long end = Calendar.getInstance().getTimeInMillis() / 1000L;
            long start = end - (long)request.getOffsetInSeconds().intValue();
            internalRequest.addParameter("start", String.valueOf(start));
            internalRequest.addParameter("end", String.valueOf(end));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_SPS_MESSAGE_KEY, request.getServiceProvider());
        }
        return this.invokeHttpClient(internalRequest, GetBecContainerMetricsResponse.class);
    }

    public GetBecVmMetricsResponse getBecVmMetrics(GetBecVmMetricsRequest request) {
        Preconditions.checkNotNull((Object)request.getOffsetInSeconds(), (Object)OFFSET_IN_SECONDS_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(METRICS_TYPE_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, MONITOR, OVERVIEW, VM_PREFIX, request.getType());
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter(METRICS_TYPE_MESSAGE_KEY, request.getType());
        }
        if (request.getOffsetInSeconds() != null && request.getOffsetInSeconds() > 0) {
            long end = Calendar.getInstance().getTimeInMillis() / 1000L;
            long start = end - (long)request.getOffsetInSeconds().intValue();
            internalRequest.addParameter("start", String.valueOf(start));
            internalRequest.addParameter("end", String.valueOf(end));
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getServiceProvider())) {
            internalRequest.addParameter(VM_INSTANCE_SPS_MESSAGE_KEY, request.getServiceProvider());
        }
        return this.invokeHttpClient(internalRequest, GetBecVmMetricsResponse.class);
    }

    public ListBecServicePackagesResponse listBecServicePackages(ListBecServicePackagesRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, RESOURCE, PACKAGE, request.getType());
        return this.invokeHttpClient(internalRequest, ListBecServicePackagesResponse.class);
    }

    public ListBecPassThroughDiskPackagesResponse listBecPassThroughDiskPackages(ListBecPassThroughDiskPackagesRequest request) {
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, RESOURCE, DISK, PASS_THROUGH);
        return this.invokeHttpClient(internalRequest, ListBecPassThroughDiskPackagesResponse.class);
    }
}

