/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.bos.demo;

import com.baidubce.BceServiceException;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.AbortMultipartUploadRequest;
import com.baidubce.services.bos.model.CompleteMultipartUploadRequest;
import com.baidubce.services.bos.model.CompleteMultipartUploadResponse;
import com.baidubce.services.bos.model.InitiateMultipartUploadRequest;
import com.baidubce.services.bos.model.InitiateMultipartUploadResponse;
import com.baidubce.services.bos.model.ListMultipartUploadsRequest;
import com.baidubce.services.bos.model.ListMultipartUploadsResponse;
import com.baidubce.services.bos.model.ListPartsRequest;
import com.baidubce.services.bos.model.ListPartsResponse;
import com.baidubce.services.bos.model.MultipartUploadSummary;
import com.baidubce.services.bos.model.PartETag;
import com.baidubce.services.bos.model.PartSummary;
import com.baidubce.services.bos.model.PutSuperObjectRequest;
import com.baidubce.services.bos.model.UploadPartRequest;
import com.baidubce.services.bos.model.UploadPartResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultipartUploadDemo {
    public static void main(String[] args) {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        String uploadId = MultipartUploadDemo.initMultipartUpload(client);
        List<PartETag> partETags = MultipartUploadDemo.uploadPart(client, uploadId);
        MultipartUploadDemo.completePart(client, uploadId, partETags);
        client.shutdown();
    }

    public static String initMultipartUpload(BosClient client) {
        InitiateMultipartUploadRequest initiateMultipartUploadRequest = new InitiateMultipartUploadRequest("bucketName", "objectKey");
        InitiateMultipartUploadResponse initiateMultipartUploadResponse = client.initiateMultipartUpload(initiateMultipartUploadRequest);
        String uploadId = initiateMultipartUploadResponse.getUploadId();
        System.out.println("UploadId: " + uploadId);
        return uploadId;
    }

    public static List<PartETag> uploadPart(BosClient client, String uploadId) {
        long partSize = 0x500000L;
        File partFile = new File("/path/to/file.zip");
        int partCount = (int)(partFile.length() / 0x500000L);
        if (partFile.length() % 0x500000L != 0L) {
            ++partCount;
        }
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        try {
            for (int i = 0; i < partCount; ++i) {
                FileInputStream fis = new FileInputStream(partFile);
                long skipBytes = 0x500000L * (long)i;
                fis.skip(skipBytes);
                long size = Math.min(0x500000L, partFile.length() - skipBytes);
                UploadPartRequest uploadPartRequest = new UploadPartRequest();
                uploadPartRequest.setBucketName("bucketName");
                uploadPartRequest.setKey("objectKey");
                uploadPartRequest.setUploadId(uploadId);
                uploadPartRequest.setInputStream(fis);
                uploadPartRequest.setPartSize(size);
                uploadPartRequest.setPartNumber(i + 1);
                UploadPartResponse uploadPartResponse = client.uploadPart(uploadPartRequest);
                partETags.add(uploadPartResponse.getPartETag());
                fis.close();
            }
        }
        catch (IOException e) {
            throw new BceServiceException("", e);
        }
        return partETags;
    }

    public static void completePart(BosClient client, String uploadId, List<PartETag> partETags) {
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest("bucketName", "objectKey", uploadId, partETags);
        CompleteMultipartUploadResponse completeMultipartUploadResponse = client.completeMultipartUpload(completeMultipartUploadRequest);
        System.out.println(completeMultipartUploadResponse.getETag());
    }

    public static void abortPartUploadDemo(BosClient client, String uploadId) {
        AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest("bucketName", "objectKey", uploadId);
        client.abortMultipartUpload(abortMultipartUploadRequest);
    }

    public static void listMultipartUploads(BosClient client) {
        ListMultipartUploadsRequest listMultipartUploadsRequest = new ListMultipartUploadsRequest("bucketName");
        ListMultipartUploadsResponse listing = client.listMultipartUploads(listMultipartUploadsRequest);
        for (MultipartUploadSummary multipartUpload : listing.getMultipartUploads()) {
            System.out.println("Key: " + multipartUpload.getKey() + " UploadId: " + multipartUpload.getUploadId());
        }
    }

    public static void listParts(BosClient client, String uploadId) {
        ListPartsRequest listPartsRequest = new ListPartsRequest("bucketName", "objectKey", uploadId);
        ListPartsResponse partListing = client.listParts(listPartsRequest);
        for (PartSummary part : partListing.getParts()) {
            System.out.println("PartNumber: " + part.getPartNumber() + " ETag: " + part.getETag());
        }
        String storageClass = partListing.getStorageClass();
        System.out.println("storage class: " + storageClass);
    }

    public static void putSuperObject() {
        String ACCESS_KEY_ID = "akxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String SECRET_ACCESS_KEY = "skxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx";
        String ENDPOINT = "bj.bcebos.com";
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials(new DefaultBceCredentials(ACCESS_KEY_ID, SECRET_ACCESS_KEY));
        config.setEndpoint(ENDPOINT);
        BosClient client = new BosClient(config);
        File file = new File("/path/to/file.zip");
        PutSuperObjectRequest request = new PutSuperObjectRequest("bucketName", "objectKey", file);
        client.putSuperObjectFromFile(request);
        client.shutdown();
    }
}

