/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cnap;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.cnap.CnapClientConfiguration;
import com.baidubce.services.cnap.handler.CnapHttpResponseHandler;
import com.baidubce.services.cnap.model.access.CreateAccessModel;
import com.baidubce.services.cnap.model.access.CreateAccessRequest;
import com.baidubce.services.cnap.model.access.CreateAccessResponse;
import com.baidubce.services.cnap.model.access.DeleteAccessRequest;
import com.baidubce.services.cnap.model.access.DeleteAccessResponse;
import com.baidubce.services.cnap.model.access.ListAccessRequest;
import com.baidubce.services.cnap.model.access.ListAccessResponse;
import com.baidubce.services.cnap.model.access.NewAccessModel;
import com.baidubce.services.cnap.model.application.CreateApplicationRequest;
import com.baidubce.services.cnap.model.application.CreateApplicationResponse;
import com.baidubce.services.cnap.model.application.DeleteApplicationRequest;
import com.baidubce.services.cnap.model.application.DeleteApplicationResponse;
import com.baidubce.services.cnap.model.application.ListApplicationRequest;
import com.baidubce.services.cnap.model.application.ListApplicationResponse;
import com.baidubce.services.cnap.model.cluster.BindClusterToWorkspaceRequest;
import com.baidubce.services.cnap.model.cluster.BindClusterToWorkspaceResponse;
import com.baidubce.services.cnap.model.cluster.ImportClusterRequest;
import com.baidubce.services.cnap.model.cluster.ImportClusterResponse;
import com.baidubce.services.cnap.model.cluster.ReleaseClusterRequest;
import com.baidubce.services.cnap.model.cluster.ReleaseClusterResponse;
import com.baidubce.services.cnap.model.cluster.UnbindClusterToWorkspaceRequest;
import com.baidubce.services.cnap.model.cluster.UnbindClusterToWorkspaceResponse;
import com.baidubce.services.cnap.model.deploygroup.ContainerModel;
import com.baidubce.services.cnap.model.deploygroup.CreateDeployGroupRequest;
import com.baidubce.services.cnap.model.deploygroup.CreateDeployGroupResponse;
import com.baidubce.services.cnap.model.deploygroup.DeleteDeployGroupRequest;
import com.baidubce.services.cnap.model.deploygroup.DeleteDeployGroupResponse;
import com.baidubce.services.cnap.model.deploygroup.GetDeployGroupRequest;
import com.baidubce.services.cnap.model.deploygroup.GetDeployGroupResponse;
import com.baidubce.services.cnap.model.deploygroup.ListDeployGroupByImageRequest;
import com.baidubce.services.cnap.model.deploygroup.ListDeployGroupByImageResponse;
import com.baidubce.services.cnap.model.deploygroup.ListDeployGroupByPageRequest;
import com.baidubce.services.cnap.model.deploygroup.ListDeployGroupByPageResponse;
import com.baidubce.services.cnap.model.deploygroup.NewDeployGroupModel;
import com.baidubce.services.cnap.model.deploygroup.ScaleDeployGroupRequest;
import com.baidubce.services.cnap.model.deploygroup.ScaleDeployGroupResponse;
import com.baidubce.services.cnap.model.deploygroup.UpdateDeployGroupRequest;
import com.baidubce.services.cnap.model.deploygroup.UpdateDeployGroupResponse;
import com.baidubce.services.cnap.model.environment.BindClusterToEnvironmentRequest;
import com.baidubce.services.cnap.model.environment.BindClusterToEnvironmentResponse;
import com.baidubce.services.cnap.model.environment.CreateEnvironmentRequest;
import com.baidubce.services.cnap.model.environment.CreateEnvironmentResponse;
import com.baidubce.services.cnap.model.environment.DeleteEnvironmentReponse;
import com.baidubce.services.cnap.model.environment.DeleteEnvironmentRequest;
import com.baidubce.services.cnap.model.environment.ListEnvironmentRequest;
import com.baidubce.services.cnap.model.environment.ListEnvironmentResponse;
import com.baidubce.services.cnap.model.environment.UnbindClusterToEnvironmentRequest;
import com.baidubce.services.cnap.model.environment.UnbindClusterToEnvironmentResponse;
import com.baidubce.services.cnap.model.environment.UpdateEnvironmentRequest;
import com.baidubce.services.cnap.model.environment.UpdateEnvironmentResponse;
import com.baidubce.services.cnap.model.monitoring.CreateAlertRulesRequest;
import com.baidubce.services.cnap.model.monitoring.CreateAlertRulesResponse;
import com.baidubce.services.cnap.model.monitoring.DeleteAlertRulesRequest;
import com.baidubce.services.cnap.model.monitoring.DeleteAlertRulesResponse;
import com.baidubce.services.cnap.model.monitoring.GetMonitorDataRequest;
import com.baidubce.services.cnap.model.monitoring.GetMonitorDataResponse;
import com.baidubce.services.cnap.model.monitoring.ListAlertRecordRequest;
import com.baidubce.services.cnap.model.monitoring.ListAlertRecordResponse;
import com.baidubce.services.cnap.model.monitoring.ListAlertRulesRequest;
import com.baidubce.services.cnap.model.monitoring.ListAlertRulesResponse;
import com.baidubce.services.cnap.model.monitoring.UpdateAlertRulesRequest;
import com.baidubce.services.cnap.model.monitoring.UpdateAlertRulesResponse;
import com.baidubce.services.cnap.model.releaserecord.CreateReleaseRecordRequest;
import com.baidubce.services.cnap.model.releaserecord.CreateReleaseRecordResponse;
import com.baidubce.services.cnap.model.releaserecord.GetReleaseRecordProgressRequest;
import com.baidubce.services.cnap.model.releaserecord.GetReleaseRecordProgressResponse;
import com.baidubce.services.cnap.model.releaserecord.ListReleaseRecordRequest;
import com.baidubce.services.cnap.model.releaserecord.ListReleaseRecordResponse;
import com.baidubce.services.cnap.model.releaserecord.RollbackReleaseRecordRequest;
import com.baidubce.services.cnap.model.releaserecord.RollbackReleaseRecordResponse;
import com.baidubce.services.cnap.model.releaserecord.TaskReqModel;
import com.baidubce.services.cnap.model.repository.CreateRepositoryRequest;
import com.baidubce.services.cnap.model.repository.CreateRepositoryResponse;
import com.baidubce.services.cnap.model.repository.ListImageRequest;
import com.baidubce.services.cnap.model.repository.ListImageResponse;
import com.baidubce.services.cnap.model.workspace.CreateWorkspaceRequest;
import com.baidubce.services.cnap.model.workspace.CreateWorkspaceResponse;
import com.baidubce.services.cnap.model.workspace.DeleteWorkspaceRequest;
import com.baidubce.services.cnap.model.workspace.DeleteWorkspaceResponse;
import com.baidubce.services.cnap.model.workspace.GetWorkspaceNameRequest;
import com.baidubce.services.cnap.model.workspace.GetWorkspaceNameResponse;
import com.baidubce.services.cnap.model.workspace.GetWorkspaceRequest;
import com.baidubce.services.cnap.model.workspace.GetWorkspaceResponse;
import com.baidubce.services.cnap.model.workspace.ListWorkspaceRequest;
import com.baidubce.services.cnap.model.workspace.ListWorkspaceResponse;
import com.baidubce.services.cnap.model.workspace.UpdateWorkspaceRequest;
import com.baidubce.services.cnap.model.workspace.UpdateWorkspaceResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.StringFormatUtils;
import com.baidubce.util.Validate;
import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class CnapClient
extends AbstractBceClient {
    private static final String VERSION = "v2";
    private static final String CONSOLE_PREFIX = "console";
    private static final String WORKSPACE_PREFIX = "workspaces";
    private static final String APPLICATION_PREFIX = "applications";
    private static final String DEPLOY_GROUP_PREFIX = "deployGroups";
    private static final String ENVIRONMENT_PREFIX = "environments";
    private static final String CLUSTER_PREFIX = "clusters";
    private static final String REPOSITORY_PREFIX = "repositories";
    private static final String IMAGE_PREFIX = "images";
    private static final String ACCESS_PREFIX = "accesses";
    private static final String RELEASE_RECORD_PREFIX = "releaseRecords";
    private static final String MONITORING_PREFIX = "monitoring";
    private static final String BILLING_PREFIX = "billing";
    private static final String BILLING_WORKSPACE_PREFIX = "billingWorkspaces";
    private static final String USER_ID_MESSAGE_KEY = "user id";
    private static final String REQUEST_NULL_ERROR_MESSAGE = "request should not be null.";
    private static final String REQUEST_WORKSPACE_INFO_NULL_ERROR_MESSAGE = "request workspace info should not be null.";
    private static final String REQUEST_CLUSTER_INFO_NULL_ERROR_MESSAGE = "request cluster info should not be null.";
    private static final String WORKSPACE_ID_MESSAGE_KEY = "workspace id";
    private static final String WORKSPACE_NAME_MESSAGE_KEY = "workspace name";
    private static final String WORKSPACE_DESCRIPTION_MESSAGE_KEY = "workspace description";
    private static final String ENVIRONMENT_ID_MESSAGE_KEY = "environment id";
    private static final String ENVIRONMENT_NAME_MESSAGE_KEY = "environment name";
    private static final String CLUSTER_ID_MESSAGE_KEY = "cluster id";
    private static final String CLUSTER_IDS_MESSAGE_KEY = "cluster ids";
    private static final String CLUSTER_REGION_MESSAGE_KEY = "cluster region";
    private static final String CLUSTER_TYPE_MESSAGE_KEY = "cluster type";
    private static final String CLUSTER_UNDERLAY_CLUSTER_ID_MESSAGE_KEY = "underlay cluster id";
    private static final String REPOSITORY_ID_MESSAGE_KEY = "repository id";
    private static final String REPOSITORY_NAME_MESSAGE_KEY = "repository name";
    private static final String REPOSITORY_TYPE_MESSAGE_KEY = "repository type";
    private static final String DEPLOY_GROUP_ID_MESSAGE_KEY = "deploy group id";
    private static final String DEPLOY_GROUP_NAME_MESSAGE_KEY = "deploy group name";
    private static final String APPLICATION_NAME_MESSAGE_KEY = "application name";
    private static final String APPLICATION_ID_MESSAGE_KEY = "application id";
    private static final String IMAGE_NAME_MESSAGE_KEY = "image name";
    private static final String IMAGE_PATH_MESSAGE_KEY = "image path";
    private static final String RELEASE_RECORD_ID_MESSAGE_KEY = "release record id";
    private static final String ACCESS_ID_MESSAGE_KEY = "deploy group id";
    private static final String ACCESS_NAME_MESSAGE_KEY = "access name";
    private static final int MIN_PORT = 1;
    private static final int MAX_PORT = 65535;
    private static final int MAX_DESCRIPTION_LENGTH = 140;
    private static final int ILLEGAL_INITIAL = -1;
    private static final HttpResponseHandler[] cnap_handlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new CnapHttpResponseHandler(), new BceJsonResponseHandler()};

    public CnapClient() {
        this(new CnapClientConfiguration());
    }

    public CnapClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, cnap_handlers);
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private InternalRequest createRequestWithCustomPath(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void fillPayload(InternalRequest internalRequest, AbstractBceRequest bceRequest) {
        if (internalRequest.getHttpMethod() == HttpMethodName.POST || internalRequest.getHttpMethod() == HttpMethodName.PUT) {
            String strJson = JsonUtils.toJsonString(bceRequest);
            byte[] requestJson = null;
            try {
                requestJson = strJson.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new BceClientException("Unsupported encode.", e);
            }
            internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
            internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
            internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        }
    }

    public CreateWorkspaceResponse createWorkspace(CreateWorkspaceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull((Object)request.getWorkspace(), (Object)REQUEST_WORKSPACE_INFO_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspace().getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, WORKSPACE_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateWorkspaceResponse.class);
    }

    public GetWorkspaceResponse getWorkspace(GetWorkspaceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, WORKSPACE_PREFIX, request.getWorkspaceID());
        return this.invokeHttpClient(internalRequest, GetWorkspaceResponse.class);
    }

    public GetWorkspaceNameResponse getWorkspaceName(GetWorkspaceNameRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getUserID(), StringFormatUtils.checkEmptyExceptionMessageFormat(USER_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequestWithCustomPath(request, HttpMethodName.GET, BILLING_PREFIX, "v1", BILLING_WORKSPACE_PREFIX, request.getWorkspaceID(), "users", request.getUserID(), "workspaceName");
        return this.invokeHttpClient(internalRequest, GetWorkspaceNameResponse.class);
    }

    public UpdateWorkspaceResponse updateWorkspace(UpdateWorkspaceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getDescription(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_DESCRIPTION_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, WORKSPACE_PREFIX, request.getWorkspaceID());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateWorkspaceResponse.class);
    }

    public DeleteWorkspaceResponse deleteWorkspace(DeleteWorkspaceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, WORKSPACE_PREFIX, request.getWorkspaceID());
        internalRequest.addParameter("skipDeleteUnderlay", String.valueOf(request.getSkipDeleteUnderlay()));
        internalRequest.addParameter("ignoreUnderlayError", String.valueOf(request.getIgnoreUnderlayError()));
        return this.invokeHttpClient(internalRequest, DeleteWorkspaceResponse.class);
    }

    public ListWorkspaceResponse listWorkspace(ListWorkspaceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, WORKSPACE_PREFIX);
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getPageSize())) {
            internalRequest.addParameter("pageSize", request.getPageSize());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getPageNo())) {
            internalRequest.addParameter("pageNo", request.getPageNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getResourceID())) {
            internalRequest.addParameter("resourceID", request.getResourceID());
        }
        return this.invokeHttpClient(internalRequest, ListWorkspaceResponse.class);
    }

    public CreateEnvironmentResponse createEnvironment(CreateEnvironmentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENVIRONMENT_NAME_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, WORKSPACE_PREFIX, request.getWorkspaceID(), ENVIRONMENT_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateEnvironmentResponse.class);
    }

    public UpdateEnvironmentResponse updateEnvironment(UpdateEnvironmentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getEnvironmentID(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENVIRONMENT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, WORKSPACE_PREFIX, request.getWorkspaceID(), ENVIRONMENT_PREFIX, request.getEnvironmentID());
        internalRequest.addParameter("skipDeleteUnderlay", String.valueOf(request.getSkipDeleteUnderlay()));
        internalRequest.addParameter("ignoreUnderlayError", String.valueOf(request.getIgnoreUnderlayError()));
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateEnvironmentResponse.class);
    }

    public ListEnvironmentResponse listEnvironment(ListEnvironmentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CONSOLE_PREFIX, WORKSPACE_PREFIX, request.getWorkspaceID(), ENVIRONMENT_PREFIX);
        internalRequest.addParameter("orderBy", request.getOrderBy());
        internalRequest.addParameter("order", request.getOrder());
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        if (!StringUtils.isEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        return this.invokeHttpClient(internalRequest, ListEnvironmentResponse.class);
    }

    public DeleteEnvironmentReponse deleteEnvironment(DeleteEnvironmentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getEnvironmentID(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENVIRONMENT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, WORKSPACE_PREFIX, request.getWorkspaceID(), ENVIRONMENT_PREFIX, request.getEnvironmentID());
        internalRequest.addParameter("skipDeleteUnderlay", String.valueOf(request.getSkipDeleteUnderlay()));
        internalRequest.addParameter("ignoreUnderlayError", String.valueOf(request.getIgnoreUnderlayError()));
        return this.invokeHttpClient(internalRequest, DeleteEnvironmentReponse.class);
    }

    public BindClusterToEnvironmentResponse bindClusterToEnvironment(BindClusterToEnvironmentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getEnvironmentID(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENVIRONMENT_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getClusterID(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTER_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, WORKSPACE_PREFIX, request.getWorkspaceID(), ENVIRONMENT_PREFIX, request.getEnvironmentID());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BindClusterToEnvironmentResponse.class);
    }

    public UnbindClusterToEnvironmentResponse unBindClusterToEnvironment(UnbindClusterToEnvironmentRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getEnvironmentID(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENVIRONMENT_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, WORKSPACE_PREFIX, request.getWorkspaceID(), ENVIRONMENT_PREFIX, request.getEnvironmentID());
        internalRequest.addParameter("skipDeleteUnderlay", String.valueOf(request.getSkipDeleteUnderlay()));
        internalRequest.addParameter("ignoreUnderlayError", String.valueOf(request.getIgnoreUnderlayError()));
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UnbindClusterToEnvironmentResponse.class);
    }

    public ImportClusterResponse importCluster(ImportClusterRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_CLUSTER_INFO_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getCluster().getRegion(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTER_REGION_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getCluster().getUnderlayClusterID(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTER_UNDERLAY_CLUSTER_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getCluster().getType(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTER_TYPE_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, CLUSTER_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ImportClusterResponse.class);
    }

    public ReleaseClusterResponse releaseCluster(ReleaseClusterRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getClusterID(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTER_UNDERLAY_CLUSTER_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, CLUSTER_PREFIX, request.getClusterID());
        internalRequest.addParameter("skipDeleteUnderlay", String.valueOf(request.getSkipDeleteUnderlay()));
        internalRequest.addParameter("ignoreUnderlayError", String.valueOf(request.getIgnoreUnderlayError()));
        return this.invokeHttpClient(internalRequest, ReleaseClusterResponse.class);
    }

    public BindClusterToWorkspaceResponse bindClusterToWorkspace(BindClusterToWorkspaceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkArgument((request.getClusterIDs().size() > 0 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTER_IDS_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, WORKSPACE_PREFIX, request.getWorkspaceID(), CLUSTER_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, BindClusterToWorkspaceResponse.class);
    }

    public UnbindClusterToWorkspaceResponse unbindClusterToWorkspace(UnbindClusterToWorkspaceRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getClusterID(), StringFormatUtils.checkEmptyExceptionMessageFormat(CLUSTER_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, WORKSPACE_PREFIX, request.getWorkspaceID(), CLUSTER_PREFIX, request.getClusterID());
        internalRequest.addParameter("skipDeleteUnderlay", String.valueOf(request.getSkipDeleteUnderlay()));
        internalRequest.addParameter("ignoreUnderlayError", String.valueOf(request.getIgnoreUnderlayError()));
        return this.invokeHttpClient(internalRequest, UnbindClusterToWorkspaceResponse.class);
    }

    public CreateRepositoryResponse createRepository(CreateRepositoryRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(REPOSITORY_NAME_MESSAGE_KEY));
        Preconditions.checkArgument((request.getType() > 0 && request.getType() < 4 ? 1 : 0) != 0, (Object)StringFormatUtils.checkEmptyExceptionMessageFormat(REPOSITORY_TYPE_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, WORKSPACE_PREFIX, request.getWorkspaceID(), REPOSITORY_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateRepositoryResponse.class);
    }

    public ListImageResponse listImage(ListImageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getRepositoryID(), StringFormatUtils.checkEmptyExceptionMessageFormat(REPOSITORY_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, WORKSPACE_PREFIX, request.getWorkspaceID(), REPOSITORY_PREFIX, request.getRepositoryID(), IMAGE_PREFIX);
        internalRequest.addParameter("orderBy", request.getOrderBy());
        internalRequest.addParameter("order", request.getOrder());
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        if (!StringUtils.isEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        return this.invokeHttpClient(internalRequest, ListImageResponse.class);
    }

    public CreateAccessResponse createAccess(CreateAccessRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull(request.getAccessList(), (Object)"create access model list should not be null.");
        String workspaceID = "";
        String applicationID = "";
        String deployGroupID = "";
        for (CreateAccessModel accessModel : request.getAccessList()) {
            Validate.checkStringNotEmpty(accessModel.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
            Validate.checkStringNotEmpty(accessModel.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
            Validate.checkStringNotEmpty(accessModel.getDeployGroupID(), StringFormatUtils.checkEmptyExceptionMessageFormat("deploy group id"));
            Validate.checkStringNotEmpty(accessModel.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(ACCESS_NAME_MESSAGE_KEY));
            Preconditions.checkArgument((accessModel.getType() >= 1 && accessModel.getType() <= 3 ? 1 : 0) != 0, (Object)"type should between 1 and 3.");
            Preconditions.checkArgument(("TCP".equals(accessModel.getProtocol()) || "UDP".equals(accessModel.getProtocol()) ? 1 : 0) != 0, (Object)"protocol should be TCP or UDP.");
            Preconditions.checkArgument((accessModel.getPort() >= 1 && accessModel.getPort() <= 65535 ? 1 : 0) != 0, (Object)"port should between 1 and 65535.");
            Preconditions.checkArgument((accessModel.getTargetPort() >= 1 && accessModel.getPort() <= 65535 ? 1 : 0) != 0, (Object)"target port should between 1 and 65535.");
            Preconditions.checkArgument((StringUtils.isEmpty((CharSequence)workspaceID) || StringUtils.isNotEmpty((CharSequence)workspaceID) && !workspaceID.equals(accessModel.getWorkspaceID()) ? 1 : 0) != 0, (Object)"workspace id should be equal.");
            Preconditions.checkArgument((StringUtils.isEmpty((CharSequence)applicationID) || StringUtils.isNotEmpty((CharSequence)applicationID) && !applicationID.equals(accessModel.getApplicationID()) ? 1 : 0) != 0, (Object)"application id should be equal.");
            Preconditions.checkArgument((StringUtils.isEmpty((CharSequence)deployGroupID) || StringUtils.isNotEmpty((CharSequence)deployGroupID) && !deployGroupID.equals(accessModel.getDeployGroupID()) ? 1 : 0) != 0, (Object)"id should be equal.");
            workspaceID = accessModel.getWorkspaceID();
            applicationID = accessModel.getApplicationID();
            deployGroupID = accessModel.getDeployGroupID();
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, WORKSPACE_PREFIX, workspaceID, APPLICATION_PREFIX, applicationID, DEPLOY_GROUP_PREFIX, deployGroupID, ACCESS_PREFIX);
        String strJson = JsonUtils.toJsonString(request.getAccessList());
        byte[] requestJson = null;
        try {
            requestJson = strJson.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Unsupported encode.", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(requestJson.length));
        internalRequest.addHeader("Content-Type", "application/json; charset=utf-8");
        internalRequest.setContent(RestartableInputStream.wrap(requestJson));
        return this.invokeHttpClient(internalRequest, CreateAccessResponse.class);
    }

    public DeleteAccessResponse deleteAccess(DeleteAccessRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getDeployGroupID(), StringFormatUtils.checkEmptyExceptionMessageFormat("deploy group id"));
        Validate.checkStringNotEmpty(request.getAccessID(), StringFormatUtils.checkEmptyExceptionMessageFormat("deploy group id"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), DEPLOY_GROUP_PREFIX, request.getDeployGroupID(), ACCESS_PREFIX, request.getAccessID());
        return this.invokeHttpClient(internalRequest, DeleteAccessResponse.class);
    }

    public ListAccessResponse listAccess(ListAccessRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getDeployGroupID(), StringFormatUtils.checkEmptyExceptionMessageFormat("deploy group id"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CONSOLE_PREFIX, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), DEPLOY_GROUP_PREFIX, request.getDeployGroupID(), ACCESS_PREFIX);
        internalRequest.addParameter("orderBy", request.getOrderBy());
        internalRequest.addParameter("order", request.getOrder());
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        return this.invokeHttpClient(internalRequest, ListAccessResponse.class);
    }

    public ListApplicationResponse listApplication(ListApplicationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX);
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getPageSize())) {
            internalRequest.addParameter("pageSize", request.getPageSize());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getPageNo())) {
            internalRequest.addParameter("pageNo", request.getPageNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getResourceID())) {
            internalRequest.addParameter("resourceID", request.getResourceID());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getDeployType())) {
            internalRequest.addParameter("deployType", request.getDeployType());
        }
        if (request.getWorkloadType() != 0) {
            internalRequest.addParameter("workloadType", String.valueOf(request.getWorkloadType()));
        }
        return this.invokeHttpClient(internalRequest, ListApplicationResponse.class);
    }

    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID());
        internalRequest.addParameter("ignoreUnderlayError", String.valueOf(request.getIgnoreUnderlayError()));
        internalRequest.addParameter("skipDeleteUnderlay", String.valueOf(request.getSkipDeleteUnderlay()));
        return this.invokeHttpClient(internalRequest, DeleteApplicationResponse.class);
    }

    public CreateDeployGroupResponse createDeployGroup(CreateDeployGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        if (CollectionUtils.isNotEmpty(request.getAccess())) {
            List<NewAccessModel> accessModelList = request.getAccess();
            for (NewAccessModel accessModel : accessModelList) {
                Validate.checkStringNotEmpty(accessModel.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(ACCESS_NAME_MESSAGE_KEY));
                Preconditions.checkArgument((accessModel.getType() >= 1 && accessModel.getType() <= 3 ? 1 : 0) != 0, (Object)"type should between 1 and 3.");
                Preconditions.checkArgument(("TCP".equals(accessModel.getProtocol()) || "UDP".equals(accessModel.getProtocol()) ? 1 : 0) != 0, (Object)"protocol should be TCP or UDP.");
                Preconditions.checkArgument((accessModel.getPort() >= 1 && accessModel.getPort() <= 65535 ? 1 : 0) != 0, (Object)"port should between 1 and 65535.");
                Preconditions.checkArgument((accessModel.getTargetPort() >= 1 && accessModel.getPort() <= 65535 ? 1 : 0) != 0, (Object)"target port should between 1 and 65535.");
            }
        }
        Preconditions.checkNotNull((Object)request.getDeployGroup(), (Object)"request deploy group should not be null.");
        NewDeployGroupModel deployGroupModel = request.getDeployGroup();
        Validate.checkStringNotEmpty(deployGroupModel.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(DEPLOY_GROUP_NAME_MESSAGE_KEY));
        Validate.checkStringNotEmpty(deployGroupModel.getEnvironmentID(), StringFormatUtils.checkEmptyExceptionMessageFormat(ENVIRONMENT_ID_MESSAGE_KEY));
        if (deployGroupModel.getType() == 1) {
            Preconditions.checkArgument((deployGroupModel.getReplicas() > 0 ? 1 : 0) != 0, (Object)"replicas should greater than 0.");
            Preconditions.checkArgument(("Recreate".equals(deployGroupModel.getDeployStrategyType()) || "RollingUpdate".equals(deployGroupModel.getDeployStrategyType()) ? 1 : 0) != 0, (Object)"type should be Recreate or RollingUpdate.");
            Preconditions.checkNotNull((Object)(request.getDeployGroup().getConf() == null || request.getDeployGroup().getConf().getContainers() == null || request.getDeployGroup().getConf().getContainers().size() == 0 ? 1 : 0), (Object)"deploy group conf should not be null.");
            List<ContainerModel> containerModelList = request.getDeployGroup().getConf().getContainers();
            for (ContainerModel containerModel : containerModelList) {
                Validate.checkStringNotEmpty(containerModel.getBapRepositoryID(), StringFormatUtils.checkEmptyExceptionMessageFormat(REPOSITORY_ID_MESSAGE_KEY));
                Validate.checkStringNotEmpty(containerModel.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGE_NAME_MESSAGE_KEY));
                Validate.checkStringNotEmpty(containerModel.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(IMAGE_PATH_MESSAGE_KEY));
                Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)containerModel.getResources().requestsInfo().get("cpu")) && StringUtils.isNotEmpty((CharSequence)containerModel.getResources().requestsInfo().get("memory")) ? 1 : 0) != 0, (Object)"resource requirement should not be empty.");
            }
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), DEPLOY_GROUP_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateDeployGroupResponse.class);
    }

    public GetDeployGroupResponse getDeployGroup(GetDeployGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getDeployGroupID(), StringFormatUtils.checkEmptyExceptionMessageFormat("deploy group id"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), DEPLOY_GROUP_PREFIX, request.getDeployGroupID());
        return this.invokeHttpClient(internalRequest, GetDeployGroupResponse.class);
    }

    public ListDeployGroupByPageResponse listDeployGroupByPage(ListDeployGroupByPageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CONSOLE_PREFIX, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), DEPLOY_GROUP_PREFIX);
        internalRequest.addParameter("pageSize", request.getPageSize());
        internalRequest.addParameter("pageNo", request.getPageNo());
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getEnvironmentID())) {
            internalRequest.addParameter("environmentID", request.getEnvironmentID());
        }
        return this.invokeHttpClient(internalRequest, ListDeployGroupByPageResponse.class);
    }

    public ListDeployGroupByImageResponse listDeployGroupByImage(ListDeployGroupByImageRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CONSOLE_PREFIX, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), DEPLOY_GROUP_PREFIX);
        if (StringUtils.isNotEmpty((CharSequence)request.getImages())) {
            internalRequest.addParameter(IMAGE_PREFIX, request.getImages());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getConfigIDs())) {
            internalRequest.addParameter("configIDs", request.getConfigIDs());
        }
        return this.invokeHttpClient(internalRequest, ListDeployGroupByImageResponse.class);
    }

    public DeleteDeployGroupResponse deleteDeployGroup(DeleteDeployGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getDeployGroupID(), StringFormatUtils.checkEmptyExceptionMessageFormat("deploy group id"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), DEPLOY_GROUP_PREFIX, request.getDeployGroupID());
        internalRequest.addParameter("skipDeleteUnderlay", String.valueOf(request.getSkipDeleteUnderlay()));
        internalRequest.addParameter("ignoreUnderlayError", String.valueOf(request.getIgnoreUnderlayError()));
        return this.invokeHttpClient(internalRequest, DeleteDeployGroupResponse.class);
    }

    public UpdateDeployGroupResponse updateDeployGroup(UpdateDeployGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getDeployGroupID(), StringFormatUtils.checkEmptyExceptionMessageFormat("deploy group id"));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), DEPLOY_GROUP_PREFIX, request.getDeployGroupID());
        return this.invokeHttpClient(internalRequest, UpdateDeployGroupResponse.class);
    }

    public ScaleDeployGroupResponse scaleDeployGroup(ScaleDeployGroupRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getDeployGroupID(), StringFormatUtils.checkEmptyExceptionMessageFormat("deploy group id"));
        Preconditions.checkArgument((request.getReplicas() >= 0 ? 1 : 0) != 0, (Object)"replicas is illegal");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), DEPLOY_GROUP_PREFIX, request.getDeployGroupID(), "scale");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, ScaleDeployGroupResponse.class);
    }

    public CreateReleaseRecordResponse createReleaseRecord(CreateReleaseRecordRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        Preconditions.checkArgument((boolean)"RdType".equals(request.getType()), (Object)"type should be RdType.");
        Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)request.getDescription()) && request.getDescription().length() < 140 ? 1 : 0) != 0, (Object)"description should not be empty or greater than 140 character");
        Preconditions.checkArgument((CollectionUtils.isNotEmpty(request.getImages()) || CollectionUtils.isNotEmpty(request.getConfigs()) ? 1 : 0) != 0, (Object)"images info or config info shoud not be empty.");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(request.getTasks()), (Object)"task info should not be empty.");
        List<TaskReqModel> taskReqModelList = request.getTasks();
        for (TaskReqModel taskReqModel : taskReqModelList) {
            Validate.checkStringNotEmpty(taskReqModel.getDeployGroupID(), StringFormatUtils.checkEmptyExceptionMessageFormat("deploy group id"));
        }
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), RELEASE_RECORD_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateReleaseRecordResponse.class);
    }

    public RollbackReleaseRecordResponse rollbackReleaseRecord(RollbackReleaseRecordRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getReleaseRecordID(), StringFormatUtils.checkEmptyExceptionMessageFormat(RELEASE_RECORD_ID_MESSAGE_KEY));
        Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)request.getDescription()) && request.getDescription().length() < 140 ? 1 : 0) != 0, (Object)"description should not be empty or greater than 140 character");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), RELEASE_RECORD_PREFIX, request.getReleaseRecordID(), "rollbackToVersion");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(request.getTasks()), (Object)"task info should not be empty.");
        List<TaskReqModel> taskReqModelList = request.getTasks();
        for (TaskReqModel taskReqModel : taskReqModelList) {
            Validate.checkStringNotEmpty(taskReqModel.getDeployGroupID(), StringFormatUtils.checkEmptyExceptionMessageFormat("deploy group id"));
        }
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, RollbackReleaseRecordResponse.class);
    }

    public ListReleaseRecordResponse listReleaseRecord(ListReleaseRecordRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, CONSOLE_PREFIX, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), RELEASE_RECORD_PREFIX);
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getPageSize())) {
            internalRequest.addParameter("pageSize", request.getPageSize());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getPageNo())) {
            internalRequest.addParameter("pageNo", request.getPageNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getExecutor())) {
            internalRequest.addParameter("executor", request.getExecutor());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getStatus())) {
            internalRequest.addParameter("status", request.getStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getType())) {
            internalRequest.addParameter("type", request.getType());
        }
        if (request.getStartTime() != null) {
            internalRequest.addParameter("startTime", String.valueOf(request.getStartTime().getTime()));
        }
        if (request.getEndTime() != null) {
            internalRequest.addParameter("endTime", String.valueOf(request.getEndTime().getTime()));
        }
        return this.invokeHttpClient(internalRequest, ListReleaseRecordResponse.class);
    }

    public GetReleaseRecordProgressResponse getReleaseRecordProgress(GetReleaseRecordProgressRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplicationID(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getReleaseRecordID(), StringFormatUtils.checkEmptyExceptionMessageFormat(RELEASE_RECORD_ID_MESSAGE_KEY));
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX, request.getApplicationID(), RELEASE_RECORD_PREFIX, request.getReleaseRecordID(), "progress");
        return this.invokeHttpClient(internalRequest, GetReleaseRecordProgressResponse.class);
    }

    public CreateApplicationResponse createApplication(CreateApplicationRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Preconditions.checkNotNull((Object)request.getApplication(), (Object)"application info should not be empty.");
        Validate.checkStringNotEmpty(request.getWorkspaceID(), StringFormatUtils.checkEmptyExceptionMessageFormat(WORKSPACE_ID_MESSAGE_KEY));
        Validate.checkStringNotEmpty(request.getApplication().getName(), StringFormatUtils.checkEmptyExceptionMessageFormat(APPLICATION_NAME_MESSAGE_KEY));
        Preconditions.checkArgument((1 == request.getApplication().getDeployType() ? 1 : 0) != 0, (Object)"deploy type is illegal.");
        Preconditions.checkArgument((1 == request.getApplication().getWorkloadType() || 4 == request.getApplication().getWorkloadType() ? 1 : 0) != 0, (Object)"work load type is illegal.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, WORKSPACE_PREFIX, request.getWorkspaceID(), APPLICATION_PREFIX);
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateApplicationResponse.class);
    }

    public CreateAlertRulesResponse createAlertRules(CreateAlertRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getName(), StringFormatUtils.checkEmptyExceptionMessageFormat("name"));
        Validate.checkStringNotEmpty(request.getDuration(), StringFormatUtils.checkEmptyExceptionMessageFormat("duration time"));
        Validate.checkStringNotEmpty(request.getPromql(), StringFormatUtils.checkEmptyExceptionMessageFormat("promql"));
        Validate.checkStringNotEmpty(request.getOp(), StringFormatUtils.checkEmptyExceptionMessageFormat("op"));
        Validate.checkStringNotEmpty(request.getRepeatInterval(), StringFormatUtils.checkEmptyExceptionMessageFormat("repeatInterval"));
        Preconditions.checkArgument((-1 != request.getThreshold() ? 1 : 0) != 0, (Object)"threshold is illegal.");
        InternalRequest internalRequest = this.createRequestWithCustomPath(request, HttpMethodName.POST, MONITORING_PREFIX, "v1", "alertRules");
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, CreateAlertRulesResponse.class);
    }

    public UpdateAlertRulesResponse updateAlertRules(UpdateAlertRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getAlertRuleID(), StringFormatUtils.checkEmptyExceptionMessageFormat("alert rule id"));
        Validate.checkStringNotEmpty(request.getDuration(), StringFormatUtils.checkEmptyExceptionMessageFormat("duration time"));
        Validate.checkStringNotEmpty(request.getPromql(), StringFormatUtils.checkEmptyExceptionMessageFormat("promql"));
        Validate.checkStringNotEmpty(request.getOp(), StringFormatUtils.checkEmptyExceptionMessageFormat("op"));
        Validate.checkStringNotEmpty(request.getRepeatInterval(), StringFormatUtils.checkEmptyExceptionMessageFormat("repeatInterval"));
        InternalRequest internalRequest = this.createRequestWithCustomPath(request, HttpMethodName.PUT, MONITORING_PREFIX, "v1", "alertRules", request.getAlertRuleID());
        this.fillPayload(internalRequest, request);
        return this.invokeHttpClient(internalRequest, UpdateAlertRulesResponse.class);
    }

    public DeleteAlertRulesResponse deleteAlertRules(DeleteAlertRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getAlertRuleID(), StringFormatUtils.checkEmptyExceptionMessageFormat("alert rule id"));
        InternalRequest internalRequest = this.createRequestWithCustomPath(request, HttpMethodName.DELETE, MONITORING_PREFIX, "v1", "alertRules", request.getAlertRuleID());
        return this.invokeHttpClient(internalRequest, DeleteAlertRulesResponse.class);
    }

    public ListAlertRulesResponse listAlertRules(ListAlertRulesRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequestWithCustomPath(request, HttpMethodName.GET, MONITORING_PREFIX, "v1", "alertRules");
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        return this.invokeHttpClient(internalRequest, ListAlertRulesResponse.class);
    }

    public ListAlertRecordResponse listAlertRecord(ListAlertRecordRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        InternalRequest internalRequest = this.createRequestWithCustomPath(request, HttpMethodName.GET, MONITORING_PREFIX, "v1", "alerts");
        if (StringUtils.isNotEmpty((CharSequence)request.getOrderBy())) {
            internalRequest.addParameter("orderBy", request.getOrderBy());
        }
        if (StringUtils.isNotEmpty((CharSequence)request.getOrder())) {
            internalRequest.addParameter("order", request.getOrder());
        }
        internalRequest.addParameter("pageSize", String.valueOf(request.getPageSize()));
        internalRequest.addParameter("pageNo", String.valueOf(request.getPageNo()));
        if (StringUtils.isNotEmpty((CharSequence)request.getName())) {
            internalRequest.addParameter("name", request.getName());
        }
        if (-1L != request.getStartsAt()) {
            internalRequest.addParameter("startsAt", String.valueOf(request.getStartsAt()));
        }
        if (-1L != request.getEndsAt()) {
            internalRequest.addParameter("endsAt", String.valueOf(request.getEndsAt()));
        }
        return this.invokeHttpClient(internalRequest, ListAlertRecordResponse.class);
    }

    public GetMonitorDataResponse getMonitorData(GetMonitorDataRequest request) {
        Preconditions.checkNotNull((Object)request, (Object)REQUEST_NULL_ERROR_MESSAGE);
        Validate.checkStringNotEmpty(request.getQuery(), StringFormatUtils.checkEmptyExceptionMessageFormat("query"));
        Preconditions.checkArgument((-1L != request.getStart() ? 1 : 0) != 0, (Object)"start is illegal.");
        Preconditions.checkArgument((-1L != request.getEnd() ? 1 : 0) != 0, (Object)"end is illegal.");
        Preconditions.checkArgument((-1 != request.getStep() ? 1 : 0) != 0, (Object)"step is illegal.");
        InternalRequest internalRequest = this.createRequestWithCustomPath(request, HttpMethodName.GET, MONITORING_PREFIX, "v1", "query_range");
        internalRequest.addParameter("query", request.getQuery());
        internalRequest.addParameter("start", String.valueOf(request.getStart()));
        internalRequest.addParameter("end", String.valueOf(request.getEnd()));
        internalRequest.addParameter("step", String.valueOf(request.getStep()));
        if (request.getTimeout() != -1) {
            internalRequest.addParameter("timeout", String.valueOf(request.getTimeout()));
        }
        return this.invokeHttpClient(internalRequest, GetMonitorDataResponse.class);
    }
}

