/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.iothub.model.iotcore;

import com.baidubce.services.iothub.model.BaseRequest;
import com.baidubce.services.iothub.model.iotcore.AuthType;
import java.util.Map;
import lombok.NonNull;

public class CreateDeviceRequest
extends BaseRequest {
    @NonNull
    private final String name;
    private final String desc;
    @NonNull
    private final String templateId;
    private final AuthType authType;
    private final String secretKey;
    private final String groupKey;
    private final Map<String, String> tags;

    CreateDeviceRequest(@NonNull String name, String desc, @NonNull String templateId, AuthType authType, String secretKey, String groupKey, Map<String, String> tags) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (templateId == null) {
            throw new NullPointerException("templateId is marked @NonNull but is null");
        }
        this.name = name;
        this.desc = desc;
        this.templateId = templateId;
        this.authType = authType;
        this.secretKey = secretKey;
        this.groupKey = groupKey;
        this.tags = tags;
    }

    public static CreateDeviceRequestBuilder builder() {
        return new CreateDeviceRequestBuilder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    @NonNull
    public String getTemplateId() {
        return this.templateId;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public static class CreateDeviceRequestBuilder {
        private String name;
        private String desc;
        private String templateId;
        private AuthType authType;
        private String secretKey;
        private String groupKey;
        private Map<String, String> tags;

        CreateDeviceRequestBuilder() {
        }

        public CreateDeviceRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CreateDeviceRequestBuilder desc(String desc) {
            this.desc = desc;
            return this;
        }

        public CreateDeviceRequestBuilder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public CreateDeviceRequestBuilder authType(AuthType authType) {
            this.authType = authType;
            return this;
        }

        public CreateDeviceRequestBuilder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public CreateDeviceRequestBuilder groupKey(String groupKey) {
            this.groupKey = groupKey;
            return this;
        }

        public CreateDeviceRequestBuilder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public CreateDeviceRequest build() {
            return new CreateDeviceRequest(this.name, this.desc, this.templateId, this.authType, this.secretKey, this.groupKey, this.tags);
        }

        public String toString() {
            return "CreateDeviceRequest.CreateDeviceRequestBuilder(name=" + this.name + ", desc=" + this.desc + ", templateId=" + this.templateId + ", authType=" + (Object)((Object)this.authType) + ", secretKey=" + this.secretKey + ", groupKey=" + this.groupKey + ", tags=" + this.tags + ")";
        }
    }
}

