/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.kms;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientException;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.kms.KmsClientConfiguration;
import com.baidubce.services.kms.model.CancelKeyDeletionRequest;
import com.baidubce.services.kms.model.CreateKeyRequest;
import com.baidubce.services.kms.model.CreateKeyResponse;
import com.baidubce.services.kms.model.DecryptRequest;
import com.baidubce.services.kms.model.DecryptResponse;
import com.baidubce.services.kms.model.DescribeKeyRequest;
import com.baidubce.services.kms.model.DescribeKeyResponse;
import com.baidubce.services.kms.model.DisableKeyRequest;
import com.baidubce.services.kms.model.EnableKeyRequest;
import com.baidubce.services.kms.model.EncryptRequest;
import com.baidubce.services.kms.model.EncryptResponse;
import com.baidubce.services.kms.model.EncryptedRsaKey;
import com.baidubce.services.kms.model.EncryptedSm2Key;
import com.baidubce.services.kms.model.GenerateDataKeyRequest;
import com.baidubce.services.kms.model.GenerateDataKeyResponse;
import com.baidubce.services.kms.model.GetParametersForImportRequest;
import com.baidubce.services.kms.model.GetParametersForImportResponse;
import com.baidubce.services.kms.model.ImportAsymmetricKeyRequest;
import com.baidubce.services.kms.model.ImportKeyRequest;
import com.baidubce.services.kms.model.KmsResponse;
import com.baidubce.services.kms.model.ListKeysRequest;
import com.baidubce.services.kms.model.ListKeysResponse;
import com.baidubce.services.kms.model.ScheduleKeyDeletionRequest;
import com.baidubce.services.kms.model.ScheduleKeyDeletionResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;

public class KmsClient
extends AbstractBceClient {
    private static final HttpResponseHandler[] kmsHandlers = new HttpResponseHandler[]{new BceMetadataResponseHandler(), new BceErrorResponseHandler(), new BceJsonResponseHandler()};

    public KmsClient() {
        this(new KmsClientConfiguration());
    }

    public KmsClient(KmsClientConfiguration clientConfiguration) {
        super(clientConfiguration, kmsHandlers, true);
    }

    public CreateKeyResponse createKey(CreateKeyRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "CreateKey");
        byte[] json = null;
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("description", request.getDescription());
            jsonGenerator.writeStringField("keyUsage", request.getKeyUsage());
            jsonGenerator.writeStringField("keySpec", request.getKeySpec());
            jsonGenerator.writeStringField("protectedBy", request.getProtectedBy());
            jsonGenerator.writeStringField("origin", request.getOrigin());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.setContent(RestartableInputStream.wrap(json));
        CreateKeyResponse response = this.invokeHttpClient(internalRequest, CreateKeyResponse.class);
        return response;
    }

    public ListKeysResponse listKeys(ListKeysRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "ListKeys");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField("limit", request.getLimit());
            jsonGenerator.writeStringField("marker", request.getMarker());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        ListKeysResponse response = this.invokeHttpClient(internalRequest, ListKeysResponse.class);
        return response;
    }

    public EncryptResponse encrypt(EncryptRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "Encrypt");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("keyId", request.getKeyId());
            jsonGenerator.writeStringField("plaintext", request.getPlaintext());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        EncryptResponse response = this.invokeHttpClient(internalRequest, EncryptResponse.class);
        return response;
    }

    public DecryptResponse decrypt(DecryptRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "Decrypt");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("keyId", request.getKeyId());
            jsonGenerator.writeStringField("ciphertext", request.getCiphertext());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        DecryptResponse response = this.invokeHttpClient(internalRequest, DecryptResponse.class);
        return response;
    }

    public GenerateDataKeyResponse generateDataKey(GenerateDataKeyRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "GenerateDataKey");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("keyId", request.getKeyId());
            jsonGenerator.writeStringField("keySpec", request.getKeySpec());
            jsonGenerator.writeNumberField("numberOfBytes", request.getNumberOfBytes());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        GenerateDataKeyResponse response = this.invokeHttpClient(internalRequest, GenerateDataKeyResponse.class);
        return response;
    }

    public void enableKey(EnableKeyRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "EnableKey");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("keyId", request.getKeyId());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        this.invokeHttpClient(internalRequest, KmsResponse.class);
    }

    public void disableKey(DisableKeyRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "DisableKey");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("keyId", request.getKeyId());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        this.invokeHttpClient(internalRequest, KmsResponse.class);
    }

    public ScheduleKeyDeletionResponse scheduleKeyDeletion(ScheduleKeyDeletionRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "ScheduleKeyDeletion");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("keyId", request.getKeyId());
            jsonGenerator.writeNumberField("pendingWindowInDays", request.getPendingWindowsInDays());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        ScheduleKeyDeletionResponse response = this.invokeHttpClient(internalRequest, ScheduleKeyDeletionResponse.class);
        return response;
    }

    public void cancelKeyDeletion(CancelKeyDeletionRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "CancelKeyDeletion");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("keyId", request.getKeyId());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        this.invokeHttpClient(internalRequest, KmsResponse.class);
    }

    public DescribeKeyResponse describeKey(DescribeKeyRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "DescribeKey");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("keyId", request.getKeyId());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        DescribeKeyResponse response = this.invokeHttpClient(internalRequest, DescribeKeyResponse.class);
        return response;
    }

    public GetParametersForImportResponse getParametersForImport(GetParametersForImportRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "GetParametersForImport");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("keyId", request.getKeyId());
            jsonGenerator.writeStringField("wrappingAlgorithm", request.getWrappingAlgorithm());
            jsonGenerator.writeStringField("wrappingKeySpec", request.getWrappingKeySpec());
            jsonGenerator.writeStringField("publicKeyEncoding", request.getPublicKeyEncoding());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        GetParametersForImportResponse response = this.invokeHttpClient(internalRequest, GetParametersForImportResponse.class);
        return response;
    }

    public KmsResponse importKey(ImportKeyRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "ImportKey");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("keyId", request.getKeyId());
            jsonGenerator.writeStringField("importToken", request.getImportToken());
            jsonGenerator.writeStringField("encryptedKey", request.getEncryptedKey());
            jsonGenerator.writeStringField("keySpec", request.getKeySpec());
            jsonGenerator.writeStringField("keyUsage", request.getKeyUsage());
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        KmsResponse response = this.invokeHttpClient(internalRequest, KmsResponse.class);
        return response;
    }

    public KmsResponse importAsymmetricKey(ImportAsymmetricKeyRequest request) throws Exception {
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST);
        internalRequest.addParameter("action", "ImportAsymmetricKey");
        StringWriter writer = new StringWriter();
        JsonGenerator jsonGenerator = null;
        try {
            jsonGenerator = JsonUtils.jsonGeneratorOf(writer);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("keyId", request.getKeyId());
            jsonGenerator.writeStringField("importToken", request.getImportToken());
            jsonGenerator.writeStringField("asymmetricKeySpec", request.getAsymmetricKeySpec());
            jsonGenerator.writeStringField("asymmetricKeyUsage", request.getAsymmetricKeyUsage());
            jsonGenerator.writeStringField("encryptedKeyEncryptionKey", request.getEncryptedKeyEncryptionKey());
            if (request.getEncryptedRsaKey() != null) {
                EncryptedRsaKey rsaKey = request.getEncryptedRsaKey();
                jsonGenerator.writeObjectFieldStart("encryptedRsaKey");
                jsonGenerator.writeStringField("publicKeyDer", rsaKey.getPublicKeyDer());
                jsonGenerator.writeStringField("encryptedD", rsaKey.getEncryptedD());
                jsonGenerator.writeStringField("encryptedP", rsaKey.getEncryptedP());
                jsonGenerator.writeStringField("encryptedQ", rsaKey.getEncryptedQ());
                jsonGenerator.writeStringField("encryptedDp", rsaKey.getEncryptedDp());
                jsonGenerator.writeStringField("encryptedDq", rsaKey.getEncryptedDq());
                jsonGenerator.writeStringField("encryptedQinv", rsaKey.getEncryptedQinv());
                jsonGenerator.writeEndObject();
            } else if (request.getEncryptedSm2Key() != null) {
                EncryptedSm2Key sm2Key = request.getEncryptedSm2Key();
                jsonGenerator.writeObjectFieldStart("encryptedSm2Key");
                jsonGenerator.writeStringField("publicKeyDer", sm2Key.getPublicKeyDer());
                jsonGenerator.writeStringField("encryptedPrivateKey", sm2Key.getEncryptedPrivateKey());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (IOException e) {
            throw new BceClientException("Fail to generate json", e);
        }
        finally {
            if (jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        this.setInternalRequest(internalRequest, writer);
        KmsResponse response = this.invokeHttpClient(internalRequest, KmsResponse.class);
        return response;
    }

    public void setInternalRequest(InternalRequest internalRequest, StringWriter writer) {
        byte[] json = null;
        try {
            json = writer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Fail to get UTF-8 bytes", e);
        }
        internalRequest.addHeader("Content-Length", String.valueOf(json.length));
        internalRequest.addHeader("Content-Type", "application/json");
        internalRequest.setContent(RestartableInputStream.wrap(json));
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod) {
        InternalRequest request = new InternalRequest(httpMethod, HttpUtils.appendUri(this.getEndpoint(), new String[0]));
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }
}

