/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestorage.model;

import com.baidubce.BceClientException;
import com.baidubce.services.tablestorage.TableStorageConstants;
import com.baidubce.services.tablestorage.model.CellType;
import com.baidubce.services.tablestorage.model.TableStorageCell;
import com.baidubce.services.tablestorage.model.TableStorageRow;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class GetRow
extends TableStorageRow {
    private int maxVersions = 1;

    public GetRow(String rowkey) {
        super(rowkey);
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public void setMaxVersions(int maxVersions) {
        this.maxVersions = maxVersions;
    }

    public GetRow addCell(String name) {
        TableStorageCell cell = new TableStorageCell(CellType.GetCell, name);
        this.cells.add(cell);
        this.rowSize += cell.getSize();
        return this;
    }

    @Override
    public String toJsonString() {
        StringBuffer buffer = new StringBuffer("{\"rowkey\":\"");
        try {
            buffer.append(URLEncoder.encode(this.rowkey, TableStorageConstants.DEFAULT_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException("Rowkey don't support " + TableStorageConstants.DEFAULT_ENCODING + " encode, rowkey=" + this.rowkey + ".");
        }
        buffer.append("\",\"maxVersions\":" + this.maxVersions);
        buffer.append(",\"cells\":[");
        for (int i = 0; i < this.cells.size(); ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            TableStorageCell cell = (TableStorageCell)this.cells.get(i);
            buffer.append(cell.toJsonString());
        }
        buffer.append("]}");
        return buffer.toString();
    }
}

