/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.parsing.dflt;

import com.github.curiousoddman.rgxgen.util.Util;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class CharIterator
implements Iterator<Character> {
    private final String aValue;
    private int aLastIndex;
    private int aCurrentIndex;

    public CharIterator(String value) {
        this.aValue = value;
        this.aLastIndex = this.aValue.length();
    }

    @Override
    public boolean hasNext() {
        return this.aCurrentIndex < this.aLastIndex;
    }

    public void skip(int n) {
        this.aCurrentIndex += n;
    }

    public void skip() {
        this.skip(1);
    }

    public char peek() {
        return this.aValue.charAt(this.aCurrentIndex);
    }

    public char peek(int offset) {
        return this.aValue.charAt(this.aCurrentIndex + offset);
    }

    @Override
    public Character next() {
        try {
            return Character.valueOf(this.aValue.charAt(this.aCurrentIndex++));
        }
        catch (StringIndexOutOfBoundsException e) {
            NoSuchElementException noSuchElementException = new NoSuchElementException(e.getMessage());
            noSuchElementException.initCause(e);
            throw noSuchElementException;
        }
    }

    public String next(int length) {
        String substring = this.aValue.substring(this.aCurrentIndex, this.aCurrentIndex + length);
        this.aCurrentIndex += length;
        return substring;
    }

    public String context() {
        return this.context(this.aCurrentIndex - 1);
    }

    public String context(int index) {
        int start = Math.max(0, index - 5);
        int end = Math.min(this.aLastIndex, index + 5);
        int offsetOfPointer = start == 0 ? index : Math.max(5, Math.min(start, 5));
        return "\n'" + this.aValue.substring(start, end) + "'\n" + Util.multiplicate(' ', 1 + offsetOfPointer) + '^';
    }

    public int remaining() {
        return this.aLastIndex - this.aCurrentIndex;
    }

    public String nextUntil(char c) {
        int startIndex = this.aCurrentIndex;
        while (true) {
            this.aCurrentIndex = this.aValue.indexOf(c, this.aCurrentIndex);
            if (this.aCurrentIndex == -1) {
                throw new NoSuchElementException("Could not find character '" + c + "' in string: '" + this.aValue.substring(startIndex));
            }
            int cnt = 1;
            while (this.aValue.charAt(this.aCurrentIndex - cnt) == '\\') {
                ++cnt;
            }
            if (cnt % 2 != 0) break;
            ++this.aCurrentIndex;
        }
        return this.aValue.substring(startIndex, this.aCurrentIndex);
    }

    public String takeWhile(Predicate<Character> condition) {
        int startIndex = this.aCurrentIndex;
        while (this.hasNext()) {
            if (condition.test(this.next())) continue;
            --this.aCurrentIndex;
            break;
        }
        return this.aValue.substring(startIndex, this.aCurrentIndex);
    }

    public char last() {
        return this.aValue.charAt(this.aLastIndex - 1);
    }

    public void setBound(int offset) {
        this.aLastIndex += offset;
    }

    public int pos() {
        return this.aCurrentIndex - 1;
    }
}

