/*
 * Decompiled with CFR 0.152.
 */
package com.github.curiousoddman.rgxgen.parsing.dflt;

import com.github.curiousoddman.rgxgen.generator.nodes.Choice;
import com.github.curiousoddman.rgxgen.generator.nodes.FinalSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Group;
import com.github.curiousoddman.rgxgen.generator.nodes.GroupRef;
import com.github.curiousoddman.rgxgen.generator.nodes.Node;
import com.github.curiousoddman.rgxgen.generator.nodes.NotSymbol;
import com.github.curiousoddman.rgxgen.generator.nodes.Repeat;
import com.github.curiousoddman.rgxgen.generator.nodes.Sequence;
import com.github.curiousoddman.rgxgen.generator.nodes.SymbolSet;
import com.github.curiousoddman.rgxgen.parsing.NodeTreeBuilder;
import com.github.curiousoddman.rgxgen.parsing.dflt.CharIterator;
import com.github.curiousoddman.rgxgen.parsing.dflt.RgxGenParseException;
import com.github.curiousoddman.rgxgen.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;

public class DefaultTreeBuilder
implements NodeTreeBuilder {
    private static final String[] SINGLETON_UNDERSCORE_ARRAY = new String[]{"_"};
    private final CharIterator aCharIterator;
    private static final ConstantsProvider CONST_PROVIDER = new ConstantsProvider();
    private Node aNode;
    private int aNextGroupIndex = 1;

    public DefaultTreeBuilder(String expr) {
        this.aCharIterator = new CharIterator(expr);
    }

    private static void sbToFinal(StringBuilder sb, List<Node> nodes) {
        if (sb.length() != 0) {
            nodes.add(new FinalSymbol(sb.toString()));
            sb.delete(0, sb.length());
        }
    }

    private GroupType processGroupType() {
        switch (this.aCharIterator.next(2)) {
            case "?=": {
                return GroupType.POSITIVE_LOOKAHEAD;
            }
            case "?:": {
                return GroupType.NON_CAPTURE_GROUP;
            }
            case "?!": {
                return GroupType.NEGATIVE_LOOKAHEAD;
            }
            case "?<": {
                GroupType res = GroupType.POSITIVE_LOOKBEHIND;
                char next = this.aCharIterator.next().charValue();
                if (next == '!') {
                    res = GroupType.NEGATIVE_LOOKBEHIND;
                } else if (next != '=') {
                    throw new RgxGenParseException("Unexpected symbol in pattern: " + this.aCharIterator.context());
                }
                return res;
            }
        }
        this.aCharIterator.skip(-2);
        return GroupType.CAPTURE_GROUP;
    }

    public Node parseGroup(GroupType currentGroupType) {
        Integer captureGroupIndex = null;
        if (currentGroupType == GroupType.CAPTURE_GROUP) {
            captureGroupIndex = this.aNextGroupIndex++;
        }
        ArrayList<Node> choices = new ArrayList<Node>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        StringBuilder sb = new StringBuilder(this.aCharIterator.remaining());
        boolean isChoice = false;
        block9: while (this.aCharIterator.hasNext()) {
            char c = this.aCharIterator.next().charValue();
            switch (c) {
                case '[': {
                    DefaultTreeBuilder.sbToFinal(sb, nodes);
                    nodes.add(this.handleCharacterVariations());
                    continue block9;
                }
                case '(': {
                    DefaultTreeBuilder.sbToFinal(sb, nodes);
                    GroupType groupType = this.processGroupType();
                    if (groupType.isNegative()) {
                        String subPattern = this.aCharIterator.nextUntil(')');
                        nodes.add(new NotSymbol(subPattern));
                        this.aCharIterator.next();
                        continue block9;
                    }
                    nodes.add(this.parseGroup(groupType));
                    continue block9;
                }
                case '|': {
                    if (sb.length() == 0 && nodes.isEmpty()) {
                        choices.add(new FinalSymbol(""));
                    } else {
                        DefaultTreeBuilder.sbToFinal(sb, nodes);
                        choices.add(DefaultTreeBuilder.sequenceOrNot(nodes, choices, false, null));
                        nodes.clear();
                    }
                    isChoice = true;
                    continue block9;
                }
                case ')': {
                    DefaultTreeBuilder.sbToFinal(sb, nodes);
                    if (isChoice) {
                        choices.add(DefaultTreeBuilder.sequenceOrNot(nodes, choices, false, null));
                        nodes.clear();
                    }
                    return DefaultTreeBuilder.sequenceOrNot(nodes, choices, isChoice, captureGroupIndex);
                }
                case '*': 
                case '+': 
                case '?': 
                case '{': {
                    Node repeatNode;
                    if (sb.length() == 0) {
                        repeatNode = (Node)nodes.remove(nodes.size() - 1);
                    } else {
                        char charToRepeat = sb.charAt(sb.length() - 1);
                        sb.deleteCharAt(sb.length() - 1);
                        DefaultTreeBuilder.sbToFinal(sb, nodes);
                        repeatNode = new FinalSymbol(String.valueOf(charToRepeat));
                    }
                    nodes.add(this.handleRepeat(c, repeatNode));
                    continue block9;
                }
                case '.': {
                    DefaultTreeBuilder.sbToFinal(sb, nodes);
                    nodes.add(new SymbolSet());
                    continue block9;
                }
                case '\\': {
                    this.handleEscapedCharacter(sb, nodes, true);
                    continue block9;
                }
            }
            sb.append(c);
        }
        DefaultTreeBuilder.sbToFinal(sb, nodes);
        return DefaultTreeBuilder.sequenceOrNot(nodes, choices, isChoice, captureGroupIndex);
    }

    private int parseHexadecimal() {
        String hexValue;
        char c = this.aCharIterator.peek();
        if (c == '{') {
            this.aCharIterator.skip();
            hexValue = this.aCharIterator.nextUntil('}');
            this.aCharIterator.skip();
        } else {
            hexValue = this.aCharIterator.next(2);
        }
        return Integer.parseInt(hexValue, 16);
    }

    private void handleGroupReference(boolean groupRefAllowed, Collection<Node> nodes, char firstCharacter) {
        if (!groupRefAllowed) {
            throw new RgxGenParseException("Group ref is not expected here. " + this.aCharIterator.context());
        }
        String digitsSubstring = this.aCharIterator.takeWhile(Character::isDigit);
        nodes.add(new GroupRef(Integer.parseInt(firstCharacter + digitsSubstring)));
    }

    private void handleEscapedCharacter(StringBuilder sb, List<Node> nodes, boolean groupRefAllowed) {
        char c = this.aCharIterator.next().charValue();
        switch (c) {
            case 'D': 
            case 'd': {
                DefaultTreeBuilder.sbToFinal(sb, nodes);
                nodes.add(new SymbolSet(CONST_PROVIDER.getDigits(), c == 'd' ? SymbolSet.TYPE.POSITIVE : SymbolSet.TYPE.NEGATIVE));
                break;
            }
            case 'S': 
            case 's': {
                DefaultTreeBuilder.sbToFinal(sb, nodes);
                nodes.add(new SymbolSet(CONST_PROVIDER.getWhitespaces(), c == 's' ? SymbolSet.TYPE.POSITIVE : SymbolSet.TYPE.NEGATIVE));
                break;
            }
            case 'W': 
            case 'w': {
                DefaultTreeBuilder.sbToFinal(sb, nodes);
                nodes.add(new SymbolSet(CONST_PROVIDER.getWordCharRanges(), SINGLETON_UNDERSCORE_ARRAY, c == 'w' ? SymbolSet.TYPE.POSITIVE : SymbolSet.TYPE.NEGATIVE));
                break;
            }
            case 'x': {
                sb.append((char)this.parseHexadecimal());
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                DefaultTreeBuilder.sbToFinal(sb, nodes);
                this.handleGroupReference(groupRefAllowed, nodes, c);
                break;
            }
            default: {
                sb.append(c);
            }
        }
    }

    private Repeat handleRepeatInCurvyBraces(Node repeatNode) {
        StringBuilder sb = new StringBuilder(10);
        int min = -1;
        int contextIndex = this.aCharIterator.pos();
        block9: while (this.aCharIterator.hasNext()) {
            char c = this.aCharIterator.next().charValue();
            switch (c) {
                case ',': {
                    int tmpContextIndex = this.aCharIterator.pos() - 1;
                    try {
                        min = Integer.parseInt(sb.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new RgxGenParseException("Malformed lower bound number." + this.aCharIterator.context(tmpContextIndex), e);
                    }
                    sb.delete(0, sb.length());
                    continue block9;
                }
                case '}': {
                    if (min == -1) {
                        return new Repeat(repeatNode, Integer.parseInt(sb.toString()));
                    }
                    if (sb.length() == 0) {
                        return Repeat.minimum(repeatNode, min);
                    }
                    try {
                        return new Repeat(repeatNode, min, Integer.parseInt(sb.toString()));
                    }
                    catch (NumberFormatException e) {
                        throw new RgxGenParseException("Malformed upper bound number." + this.aCharIterator.context(), e);
                    }
                }
                case '\\': {
                    throw new RgxGenParseException("Escape character inside curvy repetition is not supported. " + this.aCharIterator.context());
                }
            }
            sb.append(c);
        }
        throw new RgxGenParseException("Unbalanced '{' - missing '}' at " + this.aCharIterator.context(contextIndex));
    }

    private Repeat handleRepeat(char c, Node repeatNode) {
        if (c == '*') {
            return Repeat.minimum(repeatNode, 0);
        }
        if (c == '?') {
            return new Repeat(repeatNode, 0, 1);
        }
        if (c == '+') {
            return Repeat.minimum(repeatNode, 1);
        }
        if (c == '{') {
            return this.handleRepeatInCurvyBraces(repeatNode);
        }
        throw new RgxGenParseException("Unknown repetition character '" + c + '\'' + this.aCharIterator.context());
    }

    private static Node sequenceOrNot(List<Node> nodes, List<Node> choices, boolean isChoice, Integer captureGroupIndex) {
        Node resultNode;
        if (nodes.size() == 1) {
            resultNode = nodes.get(0);
        } else if (isChoice) {
            if (choices.isEmpty()) {
                throw new RuntimeException("Empty nodes");
            }
            resultNode = new Choice(choices.toArray(new Node[0]));
        } else {
            if (nodes.isEmpty()) {
                throw new RuntimeException("Empty nodes");
            }
            resultNode = new Sequence(nodes.toArray(new Node[0]));
        }
        if (captureGroupIndex == null) {
            return resultNode;
        }
        return new Group(captureGroupIndex, resultNode);
    }

    private static boolean handleRange(boolean rangeStarted, StringBuilder sb, List<SymbolSet.SymbolRange> symbolRanges) {
        if (rangeStarted) {
            char lastChar = sb.charAt(sb.length() - 1);
            char firstChar = sb.charAt(sb.length() - 2);
            sb.delete(sb.length() - 2, sb.length());
            symbolRanges.add(new SymbolSet.SymbolRange(firstChar, lastChar));
        }
        return false;
    }

    private boolean handleBackslashCharacter(boolean rangeStarted, StringBuilder sb, List<SymbolSet.SymbolRange> symbolRanges) {
        LinkedList<Node> nodes = new LinkedList<Node>();
        if (rangeStarted) {
            this.handleEscapedCharacter(sb, nodes, false);
            if (!nodes.isEmpty()) {
                throw new RgxGenParseException("Cannot make range with a shorthand escape sequences before '" + this.aCharIterator.context() + '\'');
            }
            rangeStarted = DefaultTreeBuilder.handleRange(true, sb, symbolRanges);
        } else {
            StringBuilder tmpSb = new StringBuilder(0);
            this.handleEscapedCharacter(tmpSb, nodes, false);
            sb.append((CharSequence)tmpSb);
        }
        if (!nodes.isEmpty()) {
            if (nodes.size() > 1) {
                throw new RgxGenParseException("Multiple nodes found inside square brackets escape sequence before '" + this.aCharIterator.context() + '\'');
            }
            if (nodes.get(0) instanceof SymbolSet) {
                for (String symbol : ((SymbolSet)nodes.get(0)).getSymbols()) {
                    sb.append(symbol);
                }
            } else {
                throw new RgxGenParseException("Unexpected node found inside square brackets escape sequence before '" + this.aCharIterator.context() + '\'');
            }
        }
        return rangeStarted;
    }

    private Node handleCharacterVariations() {
        int openSquareBraceIndex = this.aCharIterator.pos();
        SymbolSet.TYPE symbolSetType = SymbolSet.TYPE.POSITIVE;
        if (this.aCharIterator.peek() == '^') {
            symbolSetType = SymbolSet.TYPE.NEGATIVE;
            this.aCharIterator.next();
        }
        StringBuilder sb = new StringBuilder(this.aCharIterator.remaining());
        LinkedList<SymbolSet.SymbolRange> symbolRanges = new LinkedList<SymbolSet.SymbolRange>();
        boolean rangeStarted = false;
        block5: while (this.aCharIterator.hasNext()) {
            char c = this.aCharIterator.next().charValue();
            switch (c) {
                case ']': {
                    DefaultTreeBuilder.handleRange(rangeStarted, sb, symbolRanges);
                    String[] strings = sb.length() == 0 ? new String[]{} : Util.stringToCharsSubstrings(sb.toString());
                    return new SymbolSet(symbolRanges, strings, symbolSetType);
                }
                case '-': {
                    if (this.aCharIterator.peek() == ']' || this.aCharIterator.peek(-2) == '[') {
                        sb.append(c);
                        continue block5;
                    }
                    rangeStarted = true;
                    continue block5;
                }
                case '\\': {
                    rangeStarted = this.handleBackslashCharacter(rangeStarted, sb, symbolRanges);
                    continue block5;
                }
            }
            sb.append(c);
            rangeStarted = DefaultTreeBuilder.handleRange(rangeStarted, sb, symbolRanges);
        }
        throw new RgxGenParseException("Unexpected End Of Expression. Didn't find closing ']'" + this.aCharIterator.context(openSquareBraceIndex));
    }

    public void build() {
        if (this.aCharIterator.peek() == '^') {
            this.aCharIterator.next();
        }
        if (this.aCharIterator.last() == '$') {
            this.aCharIterator.setBound(-1);
        }
        this.aNode = this.parseGroup(GroupType.NON_CAPTURE_GROUP);
        if (this.aCharIterator.hasNext()) {
            throw new RgxGenParseException("Expression was not fully parsed: " + this.aCharIterator.context());
        }
    }

    @Override
    public Node get() {
        if (this.aNode == null) {
            this.build();
        }
        return this.aNode;
    }

    private static class ConstantsProvider {
        private String[] aDigits;
        private String[] aWhiteSpaces;
        private List<SymbolSet.SymbolRange> aWordCharRanges;

        private ConstantsProvider() {
        }

        String[] getDigits() {
            if (this.aDigits == null) {
                this.aDigits = (String[])IntStream.rangeClosed(0, 9).mapToObj(Integer::toString).toArray(String[]::new);
            }
            return this.aDigits;
        }

        String[] getWhitespaces() {
            if (this.aWhiteSpaces == null) {
                this.aWhiteSpaces = new String[]{"\r", "\f", "\u000b", " ", "\t", "\n"};
            }
            return this.aWhiteSpaces;
        }

        List<SymbolSet.SymbolRange> getWordCharRanges() {
            if (this.aWordCharRanges == null) {
                this.aWordCharRanges = Collections.unmodifiableList(Arrays.asList(SymbolSet.SymbolRange.SMALL_LETTERS, SymbolSet.SymbolRange.CAPITAL_LETTERS, SymbolSet.SymbolRange.DIGITS));
            }
            return this.aWordCharRanges;
        }
    }

    private static enum GroupType {
        POSITIVE_LOOKAHEAD,
        NEGATIVE_LOOKAHEAD,
        POSITIVE_LOOKBEHIND,
        NEGATIVE_LOOKBEHIND,
        CAPTURE_GROUP,
        NON_CAPTURE_GROUP;


        public boolean isNegative() {
            return this == NEGATIVE_LOOKAHEAD || this == NEGATIVE_LOOKBEHIND;
        }
    }
}

