/*
 * Decompiled with CFR 0.152.
 */
package wiremock.net.javacrumbs.jsonunit.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class ResourceUtils {
    public static Reader resource(String resourceName) {
        if (resourceName == null) {
            throw new NullPointerException("'null' passed instead of resource name");
        }
        InputStream resourceStream = ClassLoader.getSystemResourceAsStream(resourceName);
        if (resourceStream == null) {
            throw new IllegalArgumentException(String.format("resource '%s' not found", resourceName));
        }
        return new BufferedReader(new InputStreamReader(resourceStream, StandardCharsets.UTF_8));
    }

    static void closeQuietly(Reader resourceReader) {
        if (resourceReader != null) {
            try {
                resourceReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

