/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.iterator;

import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.iterator.MutableIntIterator;

/**
 * UnmodifiableIntIterator is a wrapper around IntIterator which is unmodifiable and doesn't support remove.
 * This file was automatically generated from template file unmodifiablePrimitiveIterator.stg.
 */
public class UnmodifiableIntIterator implements MutableIntIterator
{
    private final IntIterator intIterator;

    public UnmodifiableIntIterator(IntIterator intIterator)
    {
        this.intIterator = intIterator;
    }

    public boolean hasNext()
    {
        return this.intIterator.hasNext();
    }

    public int next()
    {
        return this.intIterator.next();
    }

    public void remove()
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }
}
