/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.factory.map.primitive.MutableFloatObjectMapFactory;
import com.gs.collections.api.map.primitive.MutableFloatObjectMap;
import com.gs.collections.api.map.primitive.FloatObjectMap;

/**
 * MutableFloatObjectMapFactoryImpl is a factory implementation which creates instances of type {@link MutableFloatObjectMap}.
 * This file was automatically generated from template file mutablePrimitiveObjectMapFactoryImpl.stg.
 *
 * @since 6.0.
 */
public class MutableFloatObjectMapFactoryImpl implements MutableFloatObjectMapFactory
{
    public <V> MutableFloatObjectMap<V> empty()
    {
        return new FloatObjectHashMap(0);
    }

    public <V> MutableFloatObjectMap<V> of()
    {
        return this.empty();
    }

    public <V> MutableFloatObjectMap<V> with()
    {
        return this.empty();
    }

    public <V> MutableFloatObjectMap<V> ofAll(FloatObjectMap<? extends V> map)
    {
        return this.withAll(map);
    }

    public <V> MutableFloatObjectMap<V> withAll(FloatObjectMap<? extends V> map)
    {
        if (map.isEmpty())
        {
            return this.empty();
        }
        return new FloatObjectHashMap<V>(map);
    }
}
