/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanFunction0;
import com.gs.collections.api.block.function.primitive.BooleanToBooleanFunction;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.FloatToBooleanFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatBooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatBooleanProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableBooleanCollection;
import com.gs.collections.api.iterator.MutableBooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.map.primitive.ImmutableFloatBooleanMap;
import com.gs.collections.api.map.primitive.FloatBooleanMap;
import com.gs.collections.api.map.primitive.MutableFloatBooleanMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.api.tuple.primitive.FloatBooleanPair;
import com.gs.collections.impl.factory.primitive.FloatBooleanMaps;
import com.gs.collections.impl.iterator.UnmodifiableBooleanIterator;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableFloatBooleanMap
        implements MutableFloatBooleanMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableFloatBooleanMap map;

    UnmodifiableFloatBooleanMap(MutableFloatBooleanMap map)
    {
        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(float key, boolean value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(FloatBooleanMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(float key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(float key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public boolean removeKeyIfAbsent(float key, boolean value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public boolean getIfAbsentPut(float key, boolean value)
    {
        return this.map.getIfAbsentPut(key, new BooleanFunction0()
        {
            public boolean value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public boolean getIfAbsentPut(float key, BooleanFunction0 function)
    {
        return this.map.getIfAbsentPut(key, new BooleanFunction0()
        {
            public boolean value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public boolean getIfAbsentPutWithKey(float key, FloatToBooleanFunction function)
    {
        return this.map.getIfAbsentPut(key, new BooleanFunction0()
        {
            public boolean value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public <P> boolean getIfAbsentPutWith(float key, BooleanFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, new BooleanFunction0()
        {
            public boolean value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public boolean updateValue(float key, boolean initialValueIfAbsent, BooleanToBooleanFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public boolean get(float key)
    {
        return this.map.get(key);
    }

    public boolean getIfAbsent(float key, boolean ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public boolean getOrThrow(float key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(float key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(boolean value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(BooleanProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatBooleanProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<FloatBooleanPair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableFloatBooleanMap select(FloatBooleanPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableFloatBooleanMap reject(FloatBooleanPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableBooleanIterator booleanIterator()
    {
        return new UnmodifiableBooleanIterator(this.map.booleanIterator());
    }

    public void forEach(BooleanProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(BooleanPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableBooleanCollection select(BooleanPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableBooleanCollection reject(BooleanPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(BooleanToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public boolean[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(boolean value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(boolean... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(BooleanIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableBooleanList toList()
    {
        return this.map.toList();
    }

    public MutableBooleanSet toSet()
    {
        return this.map.toSet();
    }

    public MutableBooleanBag toBag()
    {
        return this.map.toBag();
    }

    public LazyBooleanIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableFloatBooleanMap withKeyValue(float key, boolean value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableFloatBooleanMap withoutKey(float key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableFloatBooleanMap withoutAllKeys(FloatIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableFloatBooleanMap asUnmodifiable()
    {
        return this;
    }

    public MutableFloatBooleanMap asSynchronized()
    {
        return new SynchronizedFloatBooleanMap(this);
    }

    public ImmutableFloatBooleanMap toImmutable()
    {
        return FloatBooleanMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableFloatSet keySet()
    {
        return UnmodifiableFloatSet.of(this.map.keySet());
    }

    public MutableBooleanCollection values()
    {
        return UnmodifiableBooleanCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
