/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.map.mutable.primitive;

import java.io.Serializable;

import com.gs.collections.api.ShortIterable;
import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyShortIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableShortBag;
import com.gs.collections.api.block.function.primitive.ShortFunction;
import com.gs.collections.api.block.function.primitive.ShortFunction0;
import com.gs.collections.api.block.function.primitive.ShortToShortFunction;
import com.gs.collections.api.block.function.primitive.ShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import com.gs.collections.api.block.function.primitive.FloatToShortFunction;
import com.gs.collections.api.block.predicate.primitive.ShortPredicate;
import com.gs.collections.api.block.predicate.primitive.FloatShortPredicate;
import com.gs.collections.api.block.procedure.primitive.ShortProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatShortProcedure;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.MutableShortCollection;
import com.gs.collections.api.iterator.MutableShortIterator;
import com.gs.collections.api.list.primitive.MutableShortList;
import com.gs.collections.api.map.primitive.ImmutableFloatShortMap;
import com.gs.collections.api.map.primitive.FloatShortMap;
import com.gs.collections.api.map.primitive.MutableFloatShortMap;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableShortSet;
import com.gs.collections.api.tuple.primitive.FloatShortPair;
import com.gs.collections.impl.factory.primitive.FloatShortMaps;
import com.gs.collections.impl.iterator.UnmodifiableShortIterator;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableFloatSet;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableShortCollection;

/**
 * This file was automatically generated from template file unmodifiablePrimitivePrimitiveMap.stg.
 *
 * @since 3.1.
 */
public final class UnmodifiableFloatShortMap
        implements MutableFloatShortMap, Serializable
{
    private static final long serialVersionUID = 1L;
    private final MutableFloatShortMap map;

    UnmodifiableFloatShortMap(MutableFloatShortMap map)
    {
        this.map = map;
    }

    public void clear()
    {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(float key, short value)
    {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putAll(FloatShortMap map)
    {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void removeKey(float key)
    {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(float key)
    {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public short removeKeyIfAbsent(float key, short value)
    {
        if (this.map.containsKey(key))
        {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public short getIfAbsentPut(float key, short value)
    {
        return this.map.getIfAbsentPut(key, new ShortFunction0()
        {
            public short value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public short getIfAbsentPut(float key, ShortFunction0 function)
    {
        return this.map.getIfAbsentPut(key, new ShortFunction0()
        {
            public short value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public short getIfAbsentPutWithKey(float key, FloatToShortFunction function)
    {
        return this.map.getIfAbsentPut(key, new ShortFunction0()
        {
            public short value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public <P> short getIfAbsentPutWith(float key, ShortFunction<? super P> function, P parameter)
    {
        return this.map.getIfAbsentPut(key, new ShortFunction0()
        {
            public short value()
            {
                throw new UnsupportedOperationException();
            }
        });
    }

    public short updateValue(float key, short initialValueIfAbsent, ShortToShortFunction function)
    {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public short get(float key)
    {
        return this.map.get(key);
    }

    public short getIfAbsent(float key, short ifAbsent)
    {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public short getOrThrow(float key)
    {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(float key)
    {
        return this.map.containsKey(key);
    }

    public boolean containsValue(short value)
    {
        return this.map.containsValue(value);
    }

    public void forEachValue(ShortProcedure procedure)
    {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(FloatProcedure procedure)
    {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(FloatShortProcedure procedure)
    {
        this.map.forEachKeyValue(procedure);
    }

    public LazyFloatIterable keysView()
    {
        return this.map.keysView();
    }

    public RichIterable<FloatShortPair> keyValuesView()
    {
        return this.map.keyValuesView();
    }

    public MutableFloatShortMap select(FloatShortPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableFloatShortMap reject(FloatShortPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public MutableShortIterator shortIterator()
    {
        return new UnmodifiableShortIterator(this.map.shortIterator());
    }

    public void forEach(ShortProcedure procedure)
    {
        this.map.forEach(procedure);
    }

    public int count(ShortPredicate predicate)
    {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(ShortPredicate predicate)
    {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(ShortPredicate predicate)
    {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(ShortPredicate predicate)
    {
        return this.map.noneSatisfy(predicate);
    }

    public MutableShortCollection select(ShortPredicate predicate)
    {
        return this.map.select(predicate);
    }

    public MutableShortCollection reject(ShortPredicate predicate)
    {
        return this.map.reject(predicate);
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone)
    {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public <V> MutableCollection<V> collect(ShortToObjectFunction<? extends V> function)
    {
        return this.map.collect(function);
    }

    public long sum()
    {
        return this.map.sum();
    }

    public short max()
    {
        return this.map.max();
    }

    public short maxIfEmpty(short defaultValue)
    {
        return this.map.maxIfEmpty(defaultValue);
    }

    public short min()
    {
        return this.map.min();
    }

    public short minIfEmpty(short defaultValue)
    {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average()
    {
        return this.map.average();
    }

    public double median()
    {
        return this.map.median();
    }

    public short addToValue(float key, short toBeAdded)
    {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public short[] toSortedArray()
    {
        return this.map.toSortedArray();
    }

    public MutableShortList toSortedList()
    {
        return this.map.toSortedList();
    }

    public short[] toArray()
    {
        return this.map.toArray();
    }

    public boolean contains(short value)
    {
        return this.map.contains(value);
    }

    public boolean containsAll(short... source)
    {
        return this.map.containsAll(source);
    }

    public boolean containsAll(ShortIterable source)
    {
        return this.map.containsAll(source);
    }

    public MutableShortList toList()
    {
        return this.map.toList();
    }

    public MutableShortSet toSet()
    {
        return this.map.toSet();
    }

    public MutableShortBag toBag()
    {
        return this.map.toBag();
    }

    public LazyShortIterable asLazy()
    {
        return this.map.asLazy();
    }

    public MutableFloatShortMap withKeyValue(float key, short value)
    {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableFloatShortMap withoutKey(float key)
    {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableFloatShortMap withoutAllKeys(FloatIterable keys)
    {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableFloatShortMap asUnmodifiable()
    {
        return this;
    }

    public MutableFloatShortMap asSynchronized()
    {
        return new SynchronizedFloatShortMap(this);
    }

    public ImmutableFloatShortMap toImmutable()
    {
        return FloatShortMaps.immutable.withAll(this);
    }

    public int size()
    {
        return this.map.size();
    }

    public boolean isEmpty()
    {
        return this.map.isEmpty();
    }

    public boolean notEmpty()
    {
        return this.map.notEmpty();
    }

    public MutableFloatSet keySet()
    {
        return UnmodifiableFloatSet.of(this.map.keySet());
    }

    public MutableShortCollection values()
    {
        return UnmodifiableShortCollection.of(this.map.values());
    }

    @Override
    public boolean equals(Object otherMap)
    {
        return this.map.equals(otherMap);
    }

    @Override
    public int hashCode()
    {
        return this.map.hashCode();
    }

    @Override
    public String toString()
    {
        return this.map.toString();
    }

    public String makeString()
    {
        return this.map.makeString();
    }

    public String makeString(String separator)
    {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end)
    {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable)
    {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator)
    {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end)
    {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function)
    {
        return this.map.injectInto(injectedValue, function);
    }
}
