/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableFloatSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableFloatCollection;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveSet.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableFloatSet
        extends AbstractUnmodifiableFloatCollection
        implements MutableFloatSet
{
    private static final long serialVersionUID = 1L;

    UnmodifiableFloatSet(MutableFloatSet set)
    {
        super(set);
    }

    /**
     * This method will take a MutableFloatSet and wrap it directly in a UnmodifiableFloatSet.
     */
    public static UnmodifiableFloatSet of(MutableFloatSet set)
    {
        if (set == null)
        {
            throw new IllegalArgumentException("cannot create an UnmodifiableFloatSet for null");
        }
        return new UnmodifiableFloatSet(set);
    }

    private MutableFloatSet getMutableFloatSet()
    {
        return (MutableFloatSet) this.getFloatCollection();
    }

    @Override
    public UnmodifiableFloatSet with(float element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatSet without(float element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatSet withAll(FloatIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableFloatSet withoutAll(FloatIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableFloatSet select(FloatPredicate predicate)
    {
        return this.getMutableFloatSet().select(predicate);
    }

    @Override
    public MutableFloatSet reject(FloatPredicate predicate)
    {
        return this.getMutableFloatSet().reject(predicate);
    }

    @Override
    public <V> MutableSet<V> collect(FloatToObjectFunction<? extends V> function)
    {
        return this.getMutableFloatSet().collect(function);
    }

    @Override
    public boolean equals(Object otherSet)
    {
        return this.getMutableFloatSet().equals(otherSet);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableFloatSet().hashCode();
    }

    @Override
    public MutableFloatSet asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableFloatSet asSynchronized()
    {
        return new SynchronizedFloatSet(this);
    }

    public FloatSet freeze()
    {
        return this.getMutableFloatSet().freeze();
    }

    @Override
    public ImmutableFloatSet toImmutable()
    {
        return this.getMutableFloatSet().toImmutable();
    }
}
