/*
 * Copyright 2014 Goldman Sachs.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.gs.collections.impl.set.mutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.impl.collection.mutable.primitive.AbstractUnmodifiableIntCollection;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import net.jcip.annotations.NotThreadSafe;

/**
 * This file was automatically generated from template file unmodifiablePrimitiveSet.stg.
 *
 * @since 3.1.
 */
@NotThreadSafe
public final class UnmodifiableIntSet
        extends AbstractUnmodifiableIntCollection
        implements MutableIntSet
{
    private static final long serialVersionUID = 1L;

    UnmodifiableIntSet(MutableIntSet set)
    {
        super(set);
    }

    /**
     * This method will take a MutableIntSet and wrap it directly in a UnmodifiableIntSet.
     */
    public static UnmodifiableIntSet of(MutableIntSet set)
    {
        if (set == null)
        {
            throw new IllegalArgumentException("cannot create an UnmodifiableIntSet for null");
        }
        return new UnmodifiableIntSet(set);
    }

    private MutableIntSet getMutableIntSet()
    {
        return (MutableIntSet) this.getIntCollection();
    }

    @Override
    public UnmodifiableIntSet with(int element)
    {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableIntSet without(int element)
    {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableIntSet withAll(IntIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableIntSet withoutAll(IntIterable elements)
    {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public MutableIntSet select(IntPredicate predicate)
    {
        return this.getMutableIntSet().select(predicate);
    }

    @Override
    public MutableIntSet reject(IntPredicate predicate)
    {
        return this.getMutableIntSet().reject(predicate);
    }

    @Override
    public <V> MutableSet<V> collect(IntToObjectFunction<? extends V> function)
    {
        return this.getMutableIntSet().collect(function);
    }

    @Override
    public boolean equals(Object otherSet)
    {
        return this.getMutableIntSet().equals(otherSet);
    }

    @Override
    public int hashCode()
    {
        return this.getMutableIntSet().hashCode();
    }

    @Override
    public MutableIntSet asUnmodifiable()
    {
        return this;
    }

    @Override
    public MutableIntSet asSynchronized()
    {
        return new SynchronizedIntSet(this);
    }

    public IntSet freeze()
    {
        return this.getMutableIntSet().freeze();
    }

    @Override
    public ImmutableIntSet toImmutable()
    {
        return this.getMutableIntSet().toImmutable();
    }
}
