/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.block.function.primitive.LongToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.LongPredicate;
import com.gs.collections.api.block.procedure.primitive.LongProcedure;
import com.gs.collections.api.iterator.LongIterator;
import com.gs.collections.api.set.ImmutableSet;
import com.gs.collections.api.set.primitive.ImmutableLongSet;
import com.gs.collections.impl.SpreadFunctions;
import com.gs.collections.impl.set.immutable.primitive.AbstractImmutableLongSet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableLongSetSerializationProxy;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import com.gs.collections.impl.set.mutable.primitive.LongHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImmutableLongLongMapKeySet
extends AbstractImmutableLongSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long EMPTY_KEY = 0L;
    private static final long REMOVED_KEY = 1L;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 8;
    private static final int INITIAL_LINEAR_PROBE = 4;
    private final long[] keysValues;
    private final int occupiedWithData;
    private final boolean containsZeroKey;
    private final boolean containsOneKey;

    ImmutableLongLongMapKeySet(long[] keysValues, int occupiedWithData, boolean containsZeroKey, boolean containsOneKey) {
        this.keysValues = keysValues;
        this.occupiedWithData = occupiedWithData;
        this.containsZeroKey = containsZeroKey;
        this.containsOneKey = containsOneKey;
    }

    private static boolean isEmptyKey(long key) {
        return key == 0L;
    }

    private static boolean isRemovedKey(long key) {
        return key == 1L;
    }

    private static boolean isNonSentinel(long key) {
        return !ImmutableLongLongMapKeySet.isEmptyKey(key) && !ImmutableLongLongMapKeySet.isRemovedKey(key);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsZeroKey) {
            result += 0;
        }
        if (this.containsOneKey) {
            ++result;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                result += (int)(this.keysValues[i] ^ this.keysValues[i] >>> 32);
            }
        }
        return result;
    }

    public int size() {
        return this.occupiedWithData + (this.containsOneKey ? 1 : 0) + (this.containsZeroKey ? 1 : 0);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count = 0;
            if (this.containsZeroKey) {
                appendable.append(String.valueOf(0L));
                ++count;
            }
            if (this.containsOneKey) {
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(1L));
            }
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                if (count > 0) {
                    appendable.append(separator);
                }
                ++count;
                appendable.append(String.valueOf(this.keysValues[i]));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public LongIterator longIterator() {
        return new InternalLongIterator();
    }

    public long[] toArray() {
        long[] array = new long[this.size()];
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0L;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1L;
            ++index;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                array[index] = this.keysValues[i];
                ++index;
            }
        }
        return array;
    }

    public boolean contains(long value) {
        if (value == 0L) {
            return this.containsZeroKey;
        }
        if (value == 1L) {
            return this.containsOneKey;
        }
        return this.keysValues[this.probe(value)] == value;
    }

    public void forEach(LongProcedure procedure) {
        if (this.containsZeroKey) {
            procedure.value(0L);
        }
        if (this.containsOneKey) {
            procedure.value(1L);
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                procedure.value(this.keysValues[i]);
            }
        }
    }

    public ImmutableLongSet select(LongPredicate predicate) {
        LongHashSet result = new LongHashSet();
        if (this.containsZeroKey && predicate.accept(0L)) {
            result.add(0L);
        }
        if (this.containsOneKey && predicate.accept(1L)) {
            result.add(1L);
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            result.add(this.keysValues[i]);
        }
        return result.toImmutable();
    }

    public ImmutableLongSet reject(LongPredicate predicate) {
        LongHashSet result = new LongHashSet();
        if (this.containsZeroKey && !predicate.accept(0L)) {
            result.add(0L);
        }
        if (this.containsOneKey && !predicate.accept(1L)) {
            result.add(1L);
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i])) continue;
            result.add(this.keysValues[i]);
        }
        return result.toImmutable();
    }

    public <V> ImmutableSet<V> collect(LongToObjectFunction<? extends V> function) {
        UnifiedSet target = UnifiedSet.newSet(this.size());
        if (this.containsZeroKey) {
            target.add(function.valueOf(0L));
        }
        if (this.containsOneKey) {
            target.add(function.valueOf(1L));
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                target.add(function.valueOf(this.keysValues[i]));
            }
        }
        return target.toImmutable();
    }

    public long detectIfNone(LongPredicate predicate, long ifNone) {
        if (this.containsZeroKey && predicate.accept(0L)) {
            return 0L;
        }
        if (this.containsOneKey && predicate.accept(1L)) {
            return 1L;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return this.keysValues[i];
        }
        return ifNone;
    }

    public int count(LongPredicate predicate) {
        int count = 0;
        if (this.containsZeroKey && predicate.accept(0L)) {
            ++count;
        }
        if (this.containsOneKey && predicate.accept(1L)) {
            ++count;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(LongPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0L)) {
            return true;
        }
        if (this.containsOneKey && predicate.accept(1L)) {
            return true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(LongPredicate predicate) {
        if (this.containsZeroKey && !predicate.accept(0L)) {
            return false;
        }
        if (this.containsOneKey && !predicate.accept(1L)) {
            return false;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i]) || predicate.accept(this.keysValues[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(LongPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0L)) {
            return false;
        }
        if (this.containsOneKey && predicate.accept(1L)) {
            return false;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i]) || !predicate.accept(this.keysValues[i])) continue;
            return false;
        }
        return true;
    }

    public long sum() {
        long result = 0L;
        if (this.containsZeroKey) {
            result += 0L;
        }
        if (this.containsOneKey) {
            ++result;
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                result += this.keysValues[i];
            }
        }
        return result;
    }

    public long max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long max = 0L;
        boolean isMaxSet = false;
        if (this.containsZeroKey) {
            max = 0L;
            isMaxSet = true;
        }
        if (this.containsOneKey && (!isMaxSet || max < 1L)) {
            max = 1L;
            isMaxSet = true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i]) || isMaxSet && max >= this.keysValues[i]) continue;
            max = this.keysValues[i];
            isMaxSet = true;
        }
        return max;
    }

    public long min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long min = 0L;
        boolean isMinSet = false;
        if (this.containsZeroKey) {
            min = 0L;
            isMinSet = true;
        }
        if (this.containsOneKey && (!isMinSet || 1L < min)) {
            min = 1L;
            isMinSet = true;
        }
        for (int i = 0; i < this.keysValues.length; i += 2) {
            if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i]) || isMinSet && this.keysValues[i] >= min) continue;
            min = this.keysValues[i];
            isMinSet = true;
        }
        return min;
    }

    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        if (this.containsZeroKey) {
            result = function.valueOf(result, 0L);
        }
        if (this.containsOneKey) {
            result = function.valueOf(result, 1L);
        }
        if (this.keysValues != null) {
            for (int i = 0; i < this.keysValues.length; i += 2) {
                if (!ImmutableLongLongMapKeySet.isNonSentinel(this.keysValues[i])) continue;
                result = function.valueOf(result, this.keysValues[i]);
            }
        }
        return result;
    }

    private Object writeReplace() {
        return new ImmutableLongSetSerializationProxy(this);
    }

    int probe(long element) {
        int index = this.spreadAndMask(element) << 1;
        long keyAtIndex = this.keysValues[index];
        if (keyAtIndex == element || keyAtIndex == 0L) {
            return index;
        }
        int removedIndex = keyAtIndex == 1L ? index : -1;
        for (int i = 2; i < 4; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(long element, int removedIndex) {
        int index = this.spreadTwoAndMask(element) << 1;
        for (int i = 0; i < 4; i += 2) {
            int nextIndex = index + i & this.keysValues.length - 1;
            long keyAtIndex = this.keysValues[nextIndex];
            if (keyAtIndex == element) {
                return nextIndex;
            }
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(long element, int removedIndex) {
        int nextIndex = (int)Long.reverse(SpreadFunctions.longSpreadOne(element)) << 1;
        int spreadTwo = (int)Long.reverse(SpreadFunctions.longSpreadTwo(element)) | 1;
        long keyAtIndex;
        while ((keyAtIndex = this.keysValues[nextIndex = this.mask((nextIndex >> 1) + spreadTwo) << 1]) != element) {
            if (keyAtIndex == 0L) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (keyAtIndex != 1L || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(long element) {
        long code = SpreadFunctions.longSpreadOne(element);
        return this.mask((int)code);
    }

    int spreadTwoAndMask(long element) {
        long code = SpreadFunctions.longSpreadTwo(element);
        return this.mask((int)code);
    }

    private int mask(int spread) {
        return spread & (this.keysValues.length >> 1) - 1;
    }

    private class InternalLongIterator
    implements LongIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalLongIterator() {
        }

        public boolean hasNext() {
            return this.count < ImmutableLongLongMapKeySet.this.size();
        }

        public long next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ImmutableLongLongMapKeySet.this.containsZeroKey) {
                    return 0L;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ImmutableLongLongMapKeySet.this.containsOneKey) {
                    return 1L;
                }
            }
            long[] keysValues = ImmutableLongLongMapKeySet.this.keysValues;
            while (!ImmutableLongLongMapKeySet.isNonSentinel(keysValues[this.position])) {
                this.position += 2;
            }
            long result = ImmutableLongLongMapKeySet.this.keysValues[this.position];
            this.position += 2;
            return result;
        }
    }
}

