/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.set.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.factory.set.primitive.ImmutableIntSetFactory;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableIntEmptySet;
import com.gs.collections.impl.set.immutable.primitive.ImmutableIntSingletonSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;

public class ImmutableIntSetFactoryImpl
implements ImmutableIntSetFactory {
    public ImmutableIntSet empty() {
        return ImmutableIntEmptySet.INSTANCE;
    }

    public ImmutableIntSet of() {
        return this.empty();
    }

    public ImmutableIntSet with() {
        return this.empty();
    }

    public ImmutableIntSet of(int one) {
        return this.with(one);
    }

    public ImmutableIntSet with(int one) {
        return new ImmutableIntSingletonSet(one);
    }

    public ImmutableIntSet of(int ... items) {
        return this.with(items);
    }

    public ImmutableIntSet with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return IntHashSet.newSetWith(items).toImmutable();
    }

    public ImmutableIntSet ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public ImmutableIntSet withAll(IntIterable items) {
        if (items instanceof ImmutableIntSet) {
            return (ImmutableIntSet)items;
        }
        return this.with(items.toArray());
    }
}

