/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.utility.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.LazyDoubleIterable;
import com.gs.collections.api.LazyIterable;
import com.gs.collections.api.block.function.primitive.DoubleToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.DoublePredicate;
import com.gs.collections.impl.factory.primitive.DoubleLists;
import com.gs.collections.impl.lazy.primitive.CollectDoubleToObjectIterable;
import com.gs.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import com.gs.collections.impl.lazy.primitive.SelectDoubleIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LazyDoubleIterate {
    private static final LazyDoubleIterable EMPTY_ITERABLE = DoubleLists.immutable.of().asLazy();

    private LazyDoubleIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static LazyDoubleIterable adapt(DoubleIterable iterable) {
        return new LazyDoubleIterableAdapter(iterable);
    }

    public static LazyDoubleIterable select(DoubleIterable iterable, DoublePredicate predicate) {
        return new SelectDoubleIterable(iterable, predicate);
    }

    public static <V> LazyIterable<V> collect(DoubleIterable iterable, DoubleToObjectFunction<? extends V> function) {
        return new CollectDoubleToObjectIterable<V>(iterable, function);
    }

    public static <V> LazyIterable<V> collectIf(DoubleIterable iterable, DoublePredicate predicate, DoubleToObjectFunction<? extends V> function) {
        return LazyDoubleIterate.select(iterable, predicate).collect(function);
    }

    public static LazyDoubleIterable empty() {
        return EMPTY_ITERABLE;
    }
}

