/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.type.StringDataType;
import org.h2.store.fs.FilePath;

public class MVStoreTool {
    public static void main(String ... stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!"-dump".equals(stringArray[i])) continue;
            String string = stringArray[++i];
            MVStoreTool.dump(string, new PrintWriter(System.out));
        }
    }

    public static void dump(String string) {
        MVStoreTool.dump(string, new PrintWriter(System.out));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(String string, Writer writer) {
        PrintWriter printWriter = new PrintWriter(writer, true);
        if (!FilePath.get(string).exists()) {
            printWriter.println("File not found: " + string);
            return;
        }
        FileChannel fileChannel = null;
        int n = 4096;
        try {
            fileChannel = FilePath.get(string).open("r");
            long l = fileChannel.size();
            printWriter.println("file " + string);
            printWriter.println("    length " + l);
            ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
            long l2 = 0L;
            while (l2 < l) {
                byteBuffer.rewind();
                DataUtils.readFully(fileChannel, l2, byteBuffer);
                byteBuffer.rewind();
                byte by = byteBuffer.get();
                if (by == 72) {
                    printWriter.println("    header at " + l2);
                    printWriter.println("    " + new String(byteBuffer.array(), "UTF-8").trim());
                    l2 += (long)n;
                    continue;
                }
                if (by != 99) {
                    l2 += (long)n;
                    continue;
                }
                int n2 = byteBuffer.getInt();
                int n3 = byteBuffer.getInt();
                int n4 = byteBuffer.getInt();
                long l3 = byteBuffer.getLong();
                long l4 = byteBuffer.getLong();
                long l5 = byteBuffer.getLong();
                printWriter.println("    chunk " + n3 + " at " + l2 + " length " + n2 + " pageCount " + n4 + " root " + MVStoreTool.getPosString(l3) + " maxLength " + l4 + " maxLengthLive " + l5);
                ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
                DataUtils.readFully(fileChannel, l2, byteBuffer2);
                int n5 = byteBuffer.position();
                l2 = (l2 + (long)n2 + (long)n) / (long)n * (long)n;
                n2 -= n5;
                while (n2 > 0) {
                    int n6;
                    Object[] objectArray;
                    byteBuffer2.position(n5);
                    int n7 = byteBuffer2.getInt();
                    byteBuffer2.getShort();
                    long l6 = DataUtils.readVarInt(byteBuffer2);
                    int n8 = DataUtils.readVarInt(byteBuffer2);
                    byte by2 = byteBuffer2.get();
                    boolean bl = (by2 & 2) != 0;
                    boolean bl2 = (by2 & 1) != 0;
                    printWriter.println("        map " + l6 + " at " + n5 + " " + (bl2 ? "node" : "leaf") + " " + (bl ? "compressed " : "") + "len: " + n7 + " entries: " + n8);
                    n5 += n7;
                    n2 -= n7;
                    if (l6 != 0L || bl) continue;
                    String[] stringArray = new String[n8];
                    for (int i = 0; i < n8; ++i) {
                        String string2;
                        stringArray[i] = string2 = StringDataType.INSTANCE.read(byteBuffer2);
                    }
                    if (bl2) {
                        int n9;
                        objectArray = new long[n8 + 1];
                        for (int i = 0; i <= n8; ++i) {
                            objectArray[i] = (String)byteBuffer2.getLong();
                        }
                        long[] lArray = new long[n8 + 1];
                        for (n9 = 0; n9 <= n8; ++n9) {
                            long l7;
                            lArray[n9] = l7 = DataUtils.readVarLong(byteBuffer2);
                        }
                        for (n9 = 0; n9 < n8; ++n9) {
                            printWriter.println("          < " + stringArray[n9] + ": " + lArray[n9] + " -> " + MVStoreTool.getPosString((long)objectArray[n9]));
                        }
                        printWriter.println("          >= : " + lArray[n8] + " -> " + MVStoreTool.getPosString((long)objectArray[n8]));
                        continue;
                    }
                    objectArray = new String[n8];
                    for (n6 = 0; n6 < n8; ++n6) {
                        String string3;
                        objectArray[n6] = string3 = StringDataType.INSTANCE.read(byteBuffer2);
                    }
                    for (n6 = 0; n6 < n8; ++n6) {
                        printWriter.println("          " + stringArray[n6] + "=" + objectArray[n6]);
                    }
                }
            }
        }
        catch (IOException iOException) {
            printWriter.println("ERROR: " + iOException);
            iOException.printStackTrace(printWriter);
        }
        finally {
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
        printWriter.println();
        printWriter.flush();
    }

    private static String getPosString(long l) {
        return "pos " + l + ", chunk " + DataUtils.getPageChunkId(l) + ", offset " + DataUtils.getPageOffset(l);
    }
}

