/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.jjtree.output;

import com.helger.commons.annotation.Nonempty;
import com.helger.pgcc.EJDKVersion;
import com.helger.pgcc.jjtree.JJTreeGlobals;
import com.helger.pgcc.jjtree.JJTreeIO;
import com.helger.pgcc.jjtree.JJTreeOptions;
import com.helger.pgcc.jjtree.output.NodeFilesJava;
import com.helger.pgcc.output.OutputFile;
import com.helger.pgcc.parser.Options;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class JJTreeStateJava {
    private JJTreeStateJava() {
    }

    public static void insertParserMembers(JJTreeIO jJTreeIO) {
        jJTreeIO.println();
        jJTreeIO.println("  protected " + JJTreeStateJava._nameState() + " jjtree = new " + JJTreeStateJava._nameState() + "();");
        jJTreeIO.println();
    }

    @Nonnull
    @Nonempty
    private static String _nameState() {
        return "JJT" + JJTreeGlobals.s_parserName + "State";
    }

    public static void generateTreeState_java() {
        File file = new File(JJTreeOptions.getJJTreeOutputDirectory(), JJTreeStateJava._nameState() + ".java");
        try (OutputFile outputFile = new OutputFile(file);
             PrintWriter printWriter = outputFile.getPrintWriter();){
            NodeFilesJava.generatePrologue(printWriter);
            JJTreeStateJava._insertState(printWriter);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private static void _insertState(@Nonnull PrintWriter printWriter) {
        EJDKVersion eJDKVersion = Options.getJdkVersion();
        boolean bl = eJDKVersion.isNewerOrEqualsThan(EJDKVersion.JDK_1_7);
        printWriter.println("public class " + JJTreeStateJava._nameState() + " implements java.io.Serializable {");
        printWriter.println("  private java.util.List<Node> nodes;");
        printWriter.println("  private java.util.List<Integer> marks;");
        printWriter.println();
        printWriter.println("  /* number of nodes on stack */");
        printWriter.println("  private int sp;");
        printWriter.println("  /* current mark */");
        printWriter.println("  private int mk;");
        printWriter.println("  private boolean node_created;");
        printWriter.println();
        printWriter.println("  public " + JJTreeStateJava._nameState() + "() {");
        printWriter.println("    nodes = new java.util.ArrayList<" + (bl ? "" : "Node") + ">();");
        printWriter.println("    marks = new java.util.ArrayList<" + (bl ? "" : "Integer") + ">();");
        printWriter.println("    sp = 0;");
        printWriter.println("    mk = 0;");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  /* Determines whether the current node was actually closed and");
        printWriter.println("     pushed.  This should only be called in the final user action of a");
        printWriter.println("     node scope. */");
        printWriter.println("  public boolean nodeCreated() {");
        printWriter.println("    return node_created;");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  /* Call this to reinitialize the node stack.  It is called");
        printWriter.println("     automatically by the parser's ReInit() method. */");
        printWriter.println("  public void reset() {");
        printWriter.println("    nodes.clear();");
        printWriter.println("    marks.clear();");
        printWriter.println("    sp = 0;");
        printWriter.println("    mk = 0;");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  /* Returns the root node of the AST.  It only makes sense to call");
        printWriter.println("     this after a successful parse. */");
        printWriter.println("  public Node rootNode() {");
        printWriter.println("    return nodes.get(0);");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  /* Pushes a node on to the stack. */");
        printWriter.println("  public void pushNode(Node n) {");
        printWriter.println("    nodes.add(n);");
        printWriter.println("    ++sp;");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  /* Returns the node on the top of the stack, and remove it from the");
        printWriter.println("     stack.  */");
        printWriter.println("  public Node popNode() {");
        printWriter.println("   --sp;");
        printWriter.println("    if (sp < mk) {");
        printWriter.println("      mk = marks.remove(marks.size()-1).intValue();");
        printWriter.println("    }");
        printWriter.println("    return nodes.remove(nodes.size()-1);");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  /* Returns the node currently on the top of the stack. */");
        printWriter.println("  public Node peekNode() {");
        printWriter.println("    return nodes.get(nodes.size()-1);");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  /* Returns the number of children on the stack in the current node");
        printWriter.println("     scope. */");
        printWriter.println("  public int nodeArity() {");
        printWriter.println("    return sp - mk;");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  /* Parameter is currently unused. */");
        printWriter.println("  public void clearNodeScope(@SuppressWarnings(\"unused\") final Node n) {");
        printWriter.println("    while (sp > mk) {");
        printWriter.println("      popNode();");
        printWriter.println("    }");
        printWriter.println("    mk = marks.remove(marks.size()-1).intValue();");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  public void openNodeScope(final Node n) {");
        printWriter.println("    marks.add(Integer.valueOf(mk));");
        printWriter.println("    mk = sp;");
        printWriter.println("    n.jjtOpen();");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println("  /* A definite node is constructed from a specified number of");
        printWriter.println("     children.  That number of nodes are popped from the stack and");
        printWriter.println("     made the children of the definite node.  Then the definite node");
        printWriter.println("     is pushed on to the stack. */");
        printWriter.println("  public void closeNodeScope(final Node n, final int numIn) {");
        printWriter.println("    mk = marks.remove(marks.size()-1).intValue();");
        printWriter.println("    int num = numIn;");
        printWriter.println("    while (num-- > 0) {");
        printWriter.println("      Node c = popNode();");
        printWriter.println("      c.jjtSetParent(n);");
        printWriter.println("      n.jjtAddChild(c, num);");
        printWriter.println("    }");
        printWriter.println("    n.jjtClose();");
        printWriter.println("    pushNode(n);");
        printWriter.println("    node_created = true;");
        printWriter.println("  }");
        printWriter.println();
        printWriter.println();
        printWriter.println("  /* A conditional node is constructed if its condition is true.  All");
        printWriter.println("     the nodes that have been pushed since the node was opened are");
        printWriter.println("     made children of the conditional node, which is then pushed");
        printWriter.println("     on to the stack.  If the condition is false the node is not");
        printWriter.println("     constructed and they are left on the stack. */");
        printWriter.println("  public void closeNodeScope(final Node n, final boolean condition) {");
        printWriter.println("    if (condition) {");
        printWriter.println("      int a = nodeArity();");
        printWriter.println("      mk = marks.remove(marks.size()-1).intValue();");
        printWriter.println("      while (a-- > 0) {");
        printWriter.println("        final Node c = popNode();");
        printWriter.println("        c.jjtSetParent(n);");
        printWriter.println("        n.jjtAddChild(c, a);");
        printWriter.println("      }");
        printWriter.println("      n.jjtClose();");
        printWriter.println("      pushNode(n);");
        printWriter.println("      node_created = true;");
        printWriter.println("    } else {");
        printWriter.println("      mk = marks.remove(marks.size()-1).intValue();");
        printWriter.println("      node_created = false;");
        printWriter.println("    }");
        printWriter.println("  }");
        printWriter.println("}");
    }
}

