/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.pgcc.parser.AbstractExpRegularExpression;
import com.helger.pgcc.parser.ExpRCharacterList;
import com.helger.pgcc.parser.ExpRJustName;
import com.helger.pgcc.parser.ExpRStringLiteral;
import com.helger.pgcc.parser.ICCCharacter;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.LexGenJava;
import com.helger.pgcc.parser.Nfa;
import com.helger.pgcc.parser.NfaState;
import java.util.ArrayList;
import java.util.List;

public class ExpRChoice
extends AbstractExpRegularExpression {
    private List<AbstractExpRegularExpression> m_choices = new ArrayList<AbstractExpRegularExpression>();

    public void setChoices(List<AbstractExpRegularExpression> list) {
        this.m_choices = list;
    }

    public List<AbstractExpRegularExpression> getChoices() {
        return this.m_choices;
    }

    @Override
    public Nfa generateNfa(boolean bl) {
        this.CompressCharLists();
        if (this.getChoices().size() == 1) {
            return this.getChoices().get(0).generateNfa(bl);
        }
        Nfa nfa = new Nfa();
        NfaState nfaState = nfa.start;
        NfaState nfaState2 = nfa.end;
        for (int i = 0; i < this.getChoices().size(); ++i) {
            AbstractExpRegularExpression abstractExpRegularExpression = this.getChoices().get(i);
            Nfa nfa2 = abstractExpRegularExpression.generateNfa(bl);
            nfaState.addMove(nfa2.start);
            nfa2.end.addMove(nfaState2);
        }
        return nfa;
    }

    void CompressCharLists() {
        this.compressChoices();
        ExpRCharacterList expRCharacterList = null;
        for (int i = 0; i < this.getChoices().size(); ++i) {
            AbstractExpRegularExpression abstractExpRegularExpression = this.getChoices().get(i);
            while (abstractExpRegularExpression instanceof ExpRJustName) {
                abstractExpRegularExpression = ((ExpRJustName)abstractExpRegularExpression).m_regexpr;
            }
            if (abstractExpRegularExpression instanceof ExpRStringLiteral && ((ExpRStringLiteral)abstractExpRegularExpression).m_image.length() == 1) {
                abstractExpRegularExpression = new ExpRCharacterList(((ExpRStringLiteral)abstractExpRegularExpression).m_image.charAt(0));
                this.getChoices().set(i, abstractExpRegularExpression);
            }
            if (!(abstractExpRegularExpression instanceof ExpRCharacterList)) continue;
            if (((ExpRCharacterList)abstractExpRegularExpression).m_negated_list) {
                ((ExpRCharacterList)abstractExpRegularExpression).removeNegation();
            }
            List<ICCCharacter> list = ((ExpRCharacterList)abstractExpRegularExpression).m_descriptors;
            if (expRCharacterList == null) {
                expRCharacterList = new ExpRCharacterList();
                abstractExpRegularExpression = expRCharacterList;
                this.getChoices().set(i, abstractExpRegularExpression);
            } else {
                this.getChoices().remove(i--);
            }
            int n = list.size();
            while (n-- > 0) {
                expRCharacterList.m_descriptors.add(list.get(n));
            }
        }
    }

    void compressChoices() {
        for (int i = 0; i < this.getChoices().size(); ++i) {
            AbstractExpRegularExpression abstractExpRegularExpression = this.getChoices().get(i);
            while (abstractExpRegularExpression instanceof ExpRJustName) {
                abstractExpRegularExpression = ((ExpRJustName)abstractExpRegularExpression).m_regexpr;
            }
            if (!(abstractExpRegularExpression instanceof ExpRChoice)) continue;
            this.getChoices().remove(i--);
            int n = ((ExpRChoice)abstractExpRegularExpression).getChoices().size();
            while (n-- > 0) {
                this.getChoices().add(((ExpRChoice)abstractExpRegularExpression).getChoices().get(n));
            }
        }
    }

    public int checkUnmatchability() {
        int n = 0;
        for (int i = 0; i < this.getChoices().size(); ++i) {
            AbstractExpRegularExpression abstractExpRegularExpression = this.getChoices().get(i);
            if (!abstractExpRegularExpression.m_private_rexp && abstractExpRegularExpression.m_ordinal > 0 && abstractExpRegularExpression.m_ordinal < this.m_ordinal && LexGenJava.s_lexStates[abstractExpRegularExpression.m_ordinal] == LexGenJava.s_lexStates[this.m_ordinal]) {
                if (this.m_label != null) {
                    JavaCCErrors.warning(this, "Regular Expression choice : " + abstractExpRegularExpression.m_label + " can never be matched as : " + this.m_label);
                } else {
                    JavaCCErrors.warning(this, "Regular Expression choice : " + abstractExpRegularExpression.m_label + " can never be matched as token of kind : " + this.m_ordinal);
                }
            }
            if (abstractExpRegularExpression.m_private_rexp || !(abstractExpRegularExpression instanceof ExpRStringLiteral)) continue;
            ++n;
        }
        return n;
    }
}

