/*
 * Decompiled with CFR 0.152.
 */
package com.helger.pgcc.parser;

import com.helger.commons.string.StringHelper;
import com.helger.pgcc.output.EOutputLanguage;
import com.helger.pgcc.output.UnsupportedOutputLanguageException;
import com.helger.pgcc.parser.CodeGenerator;
import com.helger.pgcc.parser.JavaCCErrors;
import com.helger.pgcc.parser.LexGenJava;
import com.helger.pgcc.parser.Options;
import com.helger.pgcc.parser.TokenizerData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;

public class NfaState {
    public static boolean s_unicodeWarningGiven = false;
    public static int s_generatedStates = 0;
    private static int s_idCnt = 0;
    private static int s_lohiByteCnt;
    private static int s_dummyStateIndex;
    private static boolean s_done;
    private static boolean[] s_mark;
    private static boolean[] s_stateDone;
    private static List<NfaState> s_allStates;
    private static final List<NfaState> s_indexedAllStates;
    private static final List<NfaState> s_nonAsciiTableForMethod;
    private static final Map<String, NfaState> s_equivStatesTable;
    private static final Map<String, int[]> s_allNextStates;
    private static final Map<String, Integer> s_lohiByteTab;
    private static final Map<String, Integer> s_stateNameForComposite;
    private static final Map<String, int[]> s_compositeStateTable;
    private static final Map<String, String> s_stateBlockTable;
    private static final Map<String, int[]> s_stateSetsToFix;
    private static boolean s_jjCheckNAddStatesUnaryNeeded;
    private static boolean s_jjCheckNAddStatesDualNeeded;
    long[] m_asciiMoves = new long[2];
    char[] m_charMoves = null;
    private char[] m_rangeMoves = null;
    NfaState m_next = null;
    private NfaState m_stateForCase;
    final List<NfaState> m_epsilonMoves = new ArrayList<NfaState>();
    private String m_epsilonMovesString;
    private final int m_id;
    int m_stateName = -1;
    int m_kind = Integer.MAX_VALUE;
    private int m_lookingFor;
    private int m_usefulEpsilonMoves = 0;
    int m_inNextOf;
    private int m_lexState;
    private int m_nonAsciiMethod = -1;
    private int m_kindToPrint = Integer.MAX_VALUE;
    boolean m_dummy = false;
    private boolean m_isComposite = false;
    private int[] m_compositeStates = null;
    boolean m_isFinal = false;
    private List<Integer> m_loByteVec;
    private int[] m_nonAsciiMoveIndices;
    private int m_round = 0;
    private int m_onlyChar = 0;
    private char m_matchSingleChar;
    private boolean m_closureDone = false;
    private static List<String> s_allBitVectors;
    private static int[] s_tmpIndices;
    static String s_allBits;
    private static final Map<String, int[]> s_tableToDump;
    private static final List<int[]> s_orderedStateSet;
    private static int s_lastIndex;
    static int[][] s_kinds;
    static int[][][] s_statesForState;
    private static final Map<Integer, NfaState> s_initialStates;
    private static final Map<Integer, List<NfaState>> s_statesForLexicalState;
    private static final Map<Integer, Integer> s_nfaStateOffset;
    private static final Map<Integer, Integer> s_matchAnyChar;

    public static void reInitStatic() {
        s_generatedStates = 0;
        s_idCnt = 0;
        s_dummyStateIndex = -1;
        s_done = false;
        s_mark = null;
        s_stateDone = null;
        s_allStates.clear();
        s_indexedAllStates.clear();
        s_equivStatesTable.clear();
        s_allNextStates.clear();
        s_compositeStateTable.clear();
        s_stateBlockTable.clear();
        s_stateNameForComposite.clear();
        s_stateSetsToFix.clear();
    }

    NfaState() {
        this.m_id = s_idCnt++;
        s_allStates.add(this);
        this.m_lexState = LexGenJava.s_lexStateIndex;
        this.m_lookingFor = LexGenJava.s_curKind;
    }

    private NfaState _createClone() {
        NfaState nfaState = new NfaState();
        nfaState.m_isFinal = this.m_isFinal;
        nfaState.m_kind = this.m_kind;
        nfaState.m_lookingFor = this.m_lookingFor;
        nfaState.m_lexState = this.m_lexState;
        nfaState.m_inNextOf = this.m_inNextOf;
        nfaState._mergeMoves(this);
        return nfaState;
    }

    private static void _insertInOrder(List<NfaState> list, NfaState nfaState) {
        int n;
        for (n = 0; n < list.size(); ++n) {
            NfaState nfaState2 = list.get(n);
            if (nfaState2.m_id > nfaState.m_id) break;
            if (nfaState2.m_id != nfaState.m_id) continue;
            return;
        }
        list.add(n, nfaState);
    }

    private static char[] _expandCharArr(char[] cArray, int n) {
        char[] cArray2 = new char[cArray.length + n];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    void addMove(NfaState nfaState) {
        if (!this.m_epsilonMoves.contains(nfaState)) {
            NfaState._insertInOrder(this.m_epsilonMoves, nfaState);
        }
    }

    private final void _addASCIIMove(char c) {
        int n = c / 64;
        this.m_asciiMoves[n] = this.m_asciiMoves[n] | 1L << c % 64;
    }

    void addChar(char c) {
        int n;
        int n2;
        ++this.m_onlyChar;
        this.m_matchSingleChar = c;
        if (c < '\u0080') {
            this._addASCIIMove(c);
            return;
        }
        if (this.m_charMoves == null) {
            this.m_charMoves = new char[10];
        }
        if (this.m_charMoves[(n2 = this.m_charMoves.length) - 1] != '\u0000') {
            this.m_charMoves = NfaState._expandCharArr(this.m_charMoves, 10);
            n2 += 10;
        }
        for (n = 0; n < n2 && this.m_charMoves[n] != '\u0000' && this.m_charMoves[n] <= c; ++n) {
        }
        if (!(s_unicodeWarningGiven || c <= '\u00ff' || Options.isJavaUnicodeEscape() || Options.isJavaUserCharStream())) {
            s_unicodeWarningGiven = true;
            JavaCCErrors.warning(LexGenJava.s_curRE, "Non-ASCII characters used in regular expression.\nPlease make sure you use the correct Reader when you create the parser, one that can handle your character set.");
        }
        char c2 = this.m_charMoves[n];
        this.m_charMoves[n] = c;
        ++n;
        while (n < n2 && c2 != '\u0000') {
            char c3 = this.m_charMoves[n];
            this.m_charMoves[n] = c2;
            c2 = c3;
            ++n;
        }
    }

    void addRange(char c, char c2) {
        int n;
        int n2;
        char c3;
        this.m_onlyChar = 2;
        if (c3 < '\u0080') {
            if (c2 < '\u0080') {
                for (c3 = c; c3 <= c2; c3 = (char)(c3 + '\u0001')) {
                    this._addASCIIMove(c3);
                }
                return;
            }
            while (c3 < '\u0080') {
                this._addASCIIMove(c3);
                c3 = (char)(c3 + '\u0001');
            }
        }
        if (!(s_unicodeWarningGiven || c3 <= '\u00ff' && c2 <= '\u00ff' || Options.isJavaUnicodeEscape() || Options.isJavaUserCharStream())) {
            s_unicodeWarningGiven = true;
            JavaCCErrors.warning(LexGenJava.s_curRE, "Non-ASCII characters used in regular expression.\nPlease make sure you use the correct Reader when you create the parser, one that can handle your character set.");
        }
        if (this.m_rangeMoves == null) {
            this.m_rangeMoves = new char[20];
        }
        if (this.m_rangeMoves[(n2 = this.m_rangeMoves.length) - 1] != '\u0000') {
            this.m_rangeMoves = NfaState._expandCharArr(this.m_rangeMoves, 20);
            n2 += 20;
        }
        for (n = 0; n < n2 && this.m_rangeMoves[n] != '\u0000' && this.m_rangeMoves[n] <= c3 && (this.m_rangeMoves[n] != c3 || this.m_rangeMoves[n + 1] <= c2); n += 2) {
        }
        char c4 = this.m_rangeMoves[n];
        char c5 = this.m_rangeMoves[n + 1];
        this.m_rangeMoves[n] = c3;
        this.m_rangeMoves[n + 1] = c2;
        n += 2;
        while (n < n2 && c4 != '\u0000') {
            char c6 = this.m_rangeMoves[n];
            char c7 = this.m_rangeMoves[n + 1];
            this.m_rangeMoves[n] = c4;
            this.m_rangeMoves[n + 1] = c5;
            c4 = c6;
            c5 = c7;
            n += 2;
        }
    }

    private static boolean _equalCharArr(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray != null && cArray2 != null && cArray.length == cArray2.length) {
            int n = cArray.length;
            while (n-- > 0) {
                if (cArray[n] == cArray2[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void _recursiveEpsilonClosure() {
        if (this.m_closureDone || s_mark[this.m_id]) {
            return;
        }
        NfaState.s_mark[this.m_id] = true;
        for (NfaState nfaState : this.m_epsilonMoves) {
            nfaState._recursiveEpsilonClosure();
        }
        for (NfaState nfaState : new ArrayList<NfaState>(this.m_epsilonMoves)) {
            for (NfaState nfaState2 : nfaState.m_epsilonMoves) {
                if (!nfaState2._isUsefulState() || this.m_epsilonMoves.contains(nfaState2)) continue;
                NfaState._insertInOrder(this.m_epsilonMoves, nfaState2);
                s_done = false;
            }
            if (this.m_kind <= nfaState.m_kind) continue;
            this.m_kind = nfaState.m_kind;
        }
        if (this.hasTransitions() && !this.m_epsilonMoves.contains(this)) {
            NfaState._insertInOrder(this.m_epsilonMoves, this);
        }
    }

    private boolean _isUsefulState() {
        return this.m_isFinal || this.hasTransitions();
    }

    public boolean hasTransitions() {
        return this.m_asciiMoves[0] != 0L || this.m_asciiMoves[1] != 0L || this.m_charMoves != null && this.m_charMoves[0] != '\u0000' || this.m_rangeMoves != null && this.m_rangeMoves[0] != '\u0000';
    }

    private void _mergeMoves(NfaState nfaState) {
        char[] cArray;
        if (this.m_asciiMoves == nfaState.m_asciiMoves) {
            JavaCCErrors.internalError();
        }
        this.m_asciiMoves[0] = this.m_asciiMoves[0] | nfaState.m_asciiMoves[0];
        this.m_asciiMoves[1] = this.m_asciiMoves[1] | nfaState.m_asciiMoves[1];
        if (nfaState.m_charMoves != null) {
            if (this.m_charMoves == null) {
                this.m_charMoves = nfaState.m_charMoves;
            } else {
                cArray = new char[this.m_charMoves.length + nfaState.m_charMoves.length];
                System.arraycopy(this.m_charMoves, 0, cArray, 0, this.m_charMoves.length);
                this.m_charMoves = cArray;
                for (char c : nfaState.m_charMoves) {
                    this.addChar(c);
                }
            }
        }
        if (nfaState.m_rangeMoves != null) {
            if (this.m_rangeMoves == null) {
                this.m_rangeMoves = nfaState.m_rangeMoves;
            } else {
                cArray = new char[this.m_rangeMoves.length + nfaState.m_rangeMoves.length];
                System.arraycopy(this.m_rangeMoves, 0, cArray, 0, this.m_rangeMoves.length);
                this.m_rangeMoves = cArray;
                for (int i = 0; i < nfaState.m_rangeMoves.length; i += 2) {
                    this.addRange(nfaState.m_rangeMoves[i], nfaState.m_rangeMoves[i + 1]);
                }
            }
        }
        if (nfaState.m_kind < this.m_kind) {
            this.m_kind = nfaState.m_kind;
        }
        if (nfaState.m_kindToPrint < this.m_kindToPrint) {
            this.m_kindToPrint = nfaState.m_kindToPrint;
        }
        this.m_isFinal |= nfaState.m_isFinal;
    }

    NfaState createEquivState(List<NfaState> list) {
        NfaState nfaState = list.get(0)._createClone();
        nfaState.m_next = new NfaState();
        NfaState._insertInOrder(nfaState.m_next.m_epsilonMoves, list.get((int)0).m_next);
        for (int i = 1; i < list.size(); ++i) {
            NfaState nfaState2 = list.get(i);
            if (nfaState2.m_kind < nfaState.m_kind) {
                nfaState.m_kind = nfaState2.m_kind;
            }
            nfaState.m_isFinal |= nfaState2.m_isFinal;
            NfaState._insertInOrder(nfaState.m_next.m_epsilonMoves, nfaState2.m_next);
        }
        return nfaState;
    }

    private NfaState _getEquivalentRunTimeState() {
        int n = s_allStates.size();
        block0: while (n-- > 0) {
            NfaState nfaState = s_allStates.get(n);
            if (this == nfaState || nfaState.m_stateName == -1 || this.m_kindToPrint != nfaState.m_kindToPrint || this.m_asciiMoves[0] != nfaState.m_asciiMoves[0] || this.m_asciiMoves[1] != nfaState.m_asciiMoves[1] || !NfaState._equalCharArr(this.m_charMoves, nfaState.m_charMoves) || !NfaState._equalCharArr(this.m_rangeMoves, nfaState.m_rangeMoves)) continue;
            if (this.m_next == nfaState.m_next) {
                return nfaState;
            }
            if (this.m_next == null || nfaState.m_next == null || this.m_next.m_epsilonMoves.size() != nfaState.m_next.m_epsilonMoves.size()) continue;
            for (int i = 0; i < this.m_next.m_epsilonMoves.size(); ++i) {
                if (this.m_next.m_epsilonMoves.get(i) != nfaState.m_next.m_epsilonMoves.get(i)) continue block0;
            }
            return nfaState;
        }
        return null;
    }

    void generateCode() {
        if (this.m_stateName != -1) {
            return;
        }
        if (this.m_next != null) {
            this.m_next.generateCode();
            if (this.m_next.m_kind != Integer.MAX_VALUE) {
                this.m_kindToPrint = this.m_next.m_kind;
            }
        }
        if (this.m_stateName == -1 && this.hasTransitions()) {
            NfaState nfaState = this._getEquivalentRunTimeState();
            if (nfaState != null) {
                this.m_stateName = nfaState.m_stateName;
                this.m_dummy = true;
                return;
            }
            this.m_stateName = s_generatedStates++;
            s_indexedAllStates.add(this);
            this._generateNextStatesCode();
        }
    }

    public static void computeClosures() {
        for (int i = s_allStates.size() - 1; i >= 0; --i) {
            NfaState nfaState = s_allStates.get(i);
            if (nfaState.m_closureDone) continue;
            nfaState._optimizeEpsilonMoves(true);
        }
        for (NfaState nfaState : new ArrayList<NfaState>(s_allStates)) {
            if (nfaState.m_closureDone) continue;
            nfaState._optimizeEpsilonMoves(false);
        }
    }

    private void _optimizeEpsilonMoves(boolean bl) {
        int n;
        NfaState nfaState;
        int n2;
        s_done = false;
        while (!s_done) {
            if (s_mark == null || s_mark.length < s_allStates.size()) {
                s_mark = new boolean[s_allStates.size()];
            }
            n2 = s_allStates.size();
            while (n2-- > 0) {
                NfaState.s_mark[n2] = false;
            }
            s_done = true;
            this._recursiveEpsilonClosure();
        }
        n2 = s_allStates.size();
        while (n2-- > 0) {
            nfaState = s_allStates.get(n2);
            nfaState.m_closureDone = s_mark[nfaState.m_id];
        }
        n2 = 1;
        nfaState = null;
        ArrayList<NfaState> arrayList = null;
        while (n2 != 0) {
            NfaState nfaState2;
            int n3;
            NfaState nfaState3;
            n2 = 0;
            for (n = 0; bl && n < this.m_epsilonMoves.size(); ++n) {
                nfaState3 = this.m_epsilonMoves.get(n);
                if (nfaState3.hasTransitions()) {
                    for (n3 = n + 1; n3 < this.m_epsilonMoves.size(); ++n3) {
                        nfaState2 = this.m_epsilonMoves.get(n3);
                        if (!nfaState2.hasTransitions() || nfaState3.m_asciiMoves[0] != nfaState2.m_asciiMoves[0] || nfaState3.m_asciiMoves[1] != nfaState2.m_asciiMoves[1] || !NfaState._equalCharArr(nfaState3.m_charMoves, nfaState2.m_charMoves) || !NfaState._equalCharArr(nfaState3.m_rangeMoves, nfaState2.m_rangeMoves)) continue;
                        if (arrayList == null) {
                            arrayList = new ArrayList<NfaState>();
                            arrayList.add(nfaState3);
                        }
                        NfaState._insertInOrder((List<NfaState>)arrayList, nfaState2);
                        this.m_epsilonMoves.remove(n3--);
                    }
                }
                if (arrayList == null) continue;
                n2 = 1;
                String string = "";
                for (int i = 0; i < arrayList.size(); ++i) {
                    string = string + String.valueOf(((NfaState)arrayList.get((int)i)).m_id) + ", ";
                }
                nfaState = s_equivStatesTable.get(string);
                if (nfaState == null) {
                    nfaState = this.createEquivState((List<NfaState>)arrayList);
                    s_equivStatesTable.put(string, nfaState);
                }
                this.m_epsilonMoves.remove(n--);
                this.m_epsilonMoves.add(nfaState);
                arrayList = null;
                nfaState = null;
            }
            for (n = 0; n < this.m_epsilonMoves.size(); ++n) {
                nfaState3 = this.m_epsilonMoves.get(n);
                for (n3 = n + 1; n3 < this.m_epsilonMoves.size(); ++n3) {
                    nfaState2 = this.m_epsilonMoves.get(n3);
                    if (nfaState3.m_next != nfaState2.m_next) continue;
                    if (nfaState == null) {
                        nfaState = nfaState3._createClone();
                        nfaState.m_next = nfaState3.m_next;
                        n2 = 1;
                    }
                    nfaState._mergeMoves(nfaState2);
                    this.m_epsilonMoves.remove(n3--);
                }
                if (nfaState == null) continue;
                this.m_epsilonMoves.remove(n--);
                this.m_epsilonMoves.add(nfaState);
                nfaState = null;
            }
        }
        if (this.m_epsilonMoves.size() > 0) {
            for (n = 0; n < this.m_epsilonMoves.size(); ++n) {
                if (this.m_epsilonMoves.get(n).hasTransitions()) {
                    ++this.m_usefulEpsilonMoves;
                    continue;
                }
                this.m_epsilonMoves.remove(n--);
            }
        }
    }

    private void _generateNextStatesCode() {
        if (this.m_next.m_usefulEpsilonMoves > 0) {
            this.m_next._getEpsilonMovesString();
        }
    }

    private String _getEpsilonMovesString() {
        Object object;
        int[] nArray = new int[this.m_usefulEpsilonMoves];
        int n = 0;
        if (this.m_epsilonMovesString != null) {
            return this.m_epsilonMovesString;
        }
        if (this.m_usefulEpsilonMoves > 0) {
            this.m_epsilonMovesString = "{ ";
            for (int i = 0; i < this.m_epsilonMoves.size(); ++i) {
                object = this.m_epsilonMoves.get(i);
                if (!((NfaState)object).hasTransitions()) continue;
                if (((NfaState)object).m_stateName == -1) {
                    ((NfaState)object).generateCode();
                }
                ++NfaState.s_indexedAllStates.get((int)((NfaState)object).m_stateName).m_inNextOf;
                nArray[n] = ((NfaState)object).m_stateName;
                this.m_epsilonMovesString = this.m_epsilonMovesString + ((NfaState)object).m_stateName + ", ";
                if (n++ <= 0 || n % 16 != 0) continue;
                this.m_epsilonMovesString = this.m_epsilonMovesString + "\n";
            }
            this.m_epsilonMovesString = this.m_epsilonMovesString + "};";
        }
        this.m_usefulEpsilonMoves = n;
        if (this.m_epsilonMovesString != null && s_allNextStates.get(this.m_epsilonMovesString) == null) {
            object = new int[this.m_usefulEpsilonMoves];
            System.arraycopy(nArray, 0, object, 0, n);
            s_allNextStates.put(this.m_epsilonMovesString, (int[])object);
        }
        return this.m_epsilonMovesString;
    }

    public static boolean canStartNfaUsingAscii(char c) {
        int[] nArray;
        String string;
        if (c >= '\u0080') {
            JavaCCErrors.internalError();
        }
        if ((string = LexGenJava.s_initialState._getEpsilonMovesString()) == null || string.equals("null;")) {
            return false;
        }
        for (int n : nArray = s_allNextStates.get(string)) {
            NfaState nfaState = s_indexedAllStates.get(n);
            if ((nfaState.m_asciiMoves[c / 64] & 1L << c % 64) == 0L) continue;
            return true;
        }
        return false;
    }

    private boolean _canMoveUsingChar(char c) {
        if (this.m_onlyChar == 1) {
            return c == this.m_matchSingleChar;
        }
        if (c < '\u0080') {
            return (this.m_asciiMoves[c / 64] & 1L << c % 64) != 0L;
        }
        if (this.m_charMoves != null && this.m_charMoves[0] != '\u0000') {
            for (char c2 : this.m_charMoves) {
                if (c == c2) {
                    return true;
                }
                if (c < c2 || c2 == '\u0000') break;
            }
        }
        if (this.m_rangeMoves != null && this.m_rangeMoves[0] != '\u0000') {
            for (int i = 0; i < this.m_rangeMoves.length; i += 2) {
                if (c >= this.m_rangeMoves[i] && c <= this.m_rangeMoves[i + 1]) {
                    return true;
                }
                if (c < this.m_rangeMoves[i] || this.m_rangeMoves[i] == '\u0000') break;
            }
        }
        return false;
    }

    public int getFirstValidPos(String string, int n, int n2) {
        int n3 = n;
        if (this.m_onlyChar == 1) {
            char c = this.m_matchSingleChar;
            while (c != string.charAt(n3) && ++n3 < n2) {
            }
            return n3;
        }
        do {
            if (!this._canMoveUsingChar(string.charAt(n3))) continue;
            return n3;
        } while (++n3 < n2);
        return n3;
    }

    public int moveFrom(char c, List<NfaState> list) {
        if (this._canMoveUsingChar(c)) {
            int n = this.m_next.m_epsilonMoves.size();
            while (n-- > 0) {
                NfaState._insertInOrder(list, this.m_next.m_epsilonMoves.get(n));
            }
            return this.m_kindToPrint;
        }
        return Integer.MAX_VALUE;
    }

    public static int moveFromSet(char c, List<NfaState> list, List<NfaState> list2) {
        int n = Integer.MAX_VALUE;
        int n2 = list.size();
        while (n2-- > 0) {
            int n3 = list.get(n2).moveFrom(c, list2);
            if (n <= n3) continue;
            n = n3;
        }
        return n;
    }

    public static int moveFromSetForRegEx(char c, NfaState[] nfaStateArray, NfaState[] nfaStateArray2, int n) {
        int n2 = 0;
        for (NfaState nfaState : nfaStateArray) {
            if (nfaState == null) break;
            if (!nfaState._canMoveUsingChar(c)) continue;
            if (nfaState.m_kindToPrint != Integer.MAX_VALUE) {
                nfaStateArray2[n2] = null;
                return 1;
            }
            List<NfaState> list = nfaState.m_next.m_epsilonMoves;
            for (int i = list.size() - 1; i >= 0; --i) {
                NfaState nfaState2 = list.get(i);
                if (nfaState2.m_round == n) continue;
                nfaState2.m_round = n;
                nfaStateArray2[n2++] = nfaState2;
            }
        }
        nfaStateArray2[n2] = null;
        return Integer.MAX_VALUE;
    }

    private void _generateNonAsciiMoves(CodeGenerator codeGenerator) {
        Integer n;
        char c;
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        long[][] lArray = new long[256][4];
        if (!(this.m_charMoves != null && this.m_charMoves[0] != '\u0000' || this.m_rangeMoves != null && this.m_rangeMoves[0] != '\u0000')) {
            return;
        }
        if (this.m_charMoves != null) {
            for (n2 = 0; n2 < this.m_charMoves.length && this.m_charMoves[n2] != '\u0000'; ++n2) {
                c = (char)(this.m_charMoves[n2] >> 8);
                long[] lArray2 = lArray[c];
                int n5 = (this.m_charMoves[n2] & 0xFF) / 64;
                lArray2[n5] = lArray2[n5] | 1L << (this.m_charMoves[n2] & 0xFF) % 64;
            }
        }
        if (this.m_rangeMoves != null) {
            for (n2 = 0; n2 < this.m_rangeMoves.length && this.m_rangeMoves[n2] != '\u0000'; n2 += 2) {
                char c2 = (char)(this.m_rangeMoves[n2 + 1] & 0xFF);
                char c3 = (char)(this.m_rangeMoves[n2] >> 8);
                if (c3 == (char)(this.m_rangeMoves[n2 + 1] >> 8)) {
                    for (c = (char)(this.m_rangeMoves[n2] & 0xFF); c <= c2; c = (char)(c + '\u0001')) {
                        long[] lArray3 = lArray[c3];
                        int n6 = c / 64;
                        lArray3[n6] = lArray3[n6] | 1L << c % 64;
                    }
                    continue;
                }
                for (c = (char)(this.m_rangeMoves[n2] & 0xFF); c <= '\u00ff'; c = (char)(c + '\u0001')) {
                    long[] lArray4 = lArray[c3];
                    int n7 = c / 64;
                    lArray4[n7] = lArray4[n7] | 1L << c % 64;
                }
                while ((c3 = (char)(c3 + '\u0001')) < (char)(this.m_rangeMoves[n2 + 1] >> 8)) {
                    long[] lArray5 = lArray[c3];
                    lArray5[0] = lArray5[0] | 0xFFFFFFFFFFFFFFFFL;
                    long[] lArray6 = lArray[c3];
                    lArray6[1] = lArray6[1] | 0xFFFFFFFFFFFFFFFFL;
                    long[] lArray7 = lArray[c3];
                    lArray7[2] = lArray7[2] | 0xFFFFFFFFFFFFFFFFL;
                    long[] lArray8 = lArray[c3];
                    lArray8[3] = lArray8[3] | 0xFFFFFFFFFFFFFFFFL;
                }
                for (c = '\u0000'; c <= c2; c = (char)(c + '\u0001')) {
                    long[] lArray9 = lArray[c3];
                    int n8 = c / 64;
                    lArray9[n8] = lArray9[n8] | 1L << c % 64;
                }
            }
        }
        long[] lArray10 = null;
        boolean[] blArray = new boolean[256];
        for (n2 = 0; n2 <= 255; ++n2) {
            if (blArray[n2] || (blArray[n2] = lArray[n2][0] == 0L && lArray[n2][1] == 0L && lArray[n2][2] == 0L && lArray[n2][3] == 0L)) continue;
            for (n3 = n2 + 1; n3 < 256; ++n3) {
                if (blArray[n3] || lArray[n2][0] != lArray[n3][0] || lArray[n2][1] != lArray[n3][1] || lArray[n2][2] != lArray[n3][2] || lArray[n2][3] != lArray[n3][3]) continue;
                blArray[n3] = true;
                if (lArray10 == null) {
                    blArray[n2] = true;
                    lArray10 = new long[4];
                    int n9 = n2 / 64;
                    lArray10[n9] = lArray10[n9] | 1L << n2 % 64;
                }
                int n10 = n3 / 64;
                lArray10[n10] = lArray10[n10] | 1L << n3 % 64;
            }
            if (lArray10 == null) continue;
            String string = "{\n   " + eOutputLanguage.getLongHex((long)lArray10[0]) + ", " + eOutputLanguage.getLongHex((long)lArray10[1]) + ", " + eOutputLanguage.getLongHex((long)lArray10[2]) + ", " + eOutputLanguage.getLongHex((long)lArray10[3]) + "\n};";
            n = s_lohiByteTab.get(string);
            if (n == null) {
                s_allBitVectors.add(string);
                if (!NfaState.allBitsSet(string)) {
                    switch (eOutputLanguage) {
                        case JAVA: {
                            codeGenerator.genCodeLine("static final " + eOutputLanguage.getTypeLong() + "[] jjbitVec" + s_lohiByteCnt + " = " + string);
                            break;
                        }
                        case CPP: {
                            codeGenerator.switchToStaticsFile();
                            codeGenerator.genCodeLine("static const " + eOutputLanguage.getTypeLong() + " jjbitVec" + s_lohiByteCnt + "[] = " + string);
                            break;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                }
                n = s_lohiByteCnt++;
                s_lohiByteTab.put(string, n);
            }
            NfaState.s_tmpIndices[n4++] = n;
            string = "{\n   " + eOutputLanguage.getLongHex(lArray[n2][0]) + ", " + eOutputLanguage.getLongHex(lArray[n2][1]) + ", " + eOutputLanguage.getLongHex(lArray[n2][2]) + ", " + eOutputLanguage.getLongHex(lArray[n2][3]) + "\n};";
            n = s_lohiByteTab.get(string);
            if (n == null) {
                s_allBitVectors.add(string);
                if (!NfaState.allBitsSet(string)) {
                    switch (eOutputLanguage) {
                        case JAVA: {
                            codeGenerator.genCodeLine("static final " + eOutputLanguage.getTypeLong() + "[] jjbitVec" + s_lohiByteCnt + " = " + string);
                            break;
                        }
                        case CPP: {
                            codeGenerator.switchToStaticsFile();
                            codeGenerator.genCodeLine("static const " + eOutputLanguage.getTypeLong() + " jjbitVec" + s_lohiByteCnt + "[] = " + string);
                            codeGenerator.switchToMainFile();
                            break;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                }
                n = s_lohiByteCnt++;
                s_lohiByteTab.put(string, n);
            }
            NfaState.s_tmpIndices[n4++] = n;
            lArray10 = null;
        }
        this.m_nonAsciiMoveIndices = new int[n4];
        System.arraycopy(s_tmpIndices, 0, this.m_nonAsciiMoveIndices, 0, n4);
        for (n2 = 0; n2 < 256; ++n2) {
            if (blArray[n2]) {
                lArray[n2] = null;
                continue;
            }
            String string = "{\n   " + eOutputLanguage.getLongHex(lArray[n2][0]) + ", " + eOutputLanguage.getLongHex(lArray[n2][1]) + ", " + eOutputLanguage.getLongHex(lArray[n2][2]) + ", " + eOutputLanguage.getLongHex(lArray[n2][3]) + "\n};";
            n = s_lohiByteTab.get(string);
            if (n == null) {
                s_allBitVectors.add(string);
                if (!NfaState.allBitsSet(string)) {
                    switch (eOutputLanguage) {
                        case JAVA: {
                            codeGenerator.genCodeLine("static final " + eOutputLanguage.getTypeLong() + "[] jjbitVec" + s_lohiByteCnt + " = " + string);
                            break;
                        }
                        case CPP: {
                            codeGenerator.switchToStaticsFile();
                            codeGenerator.genCodeLine("static const " + eOutputLanguage.getTypeLong() + " jjbitVec" + s_lohiByteCnt + "[] = " + string);
                            break;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                }
                n = s_lohiByteCnt++;
                s_lohiByteTab.put(string, n);
            }
            if (this.m_loByteVec == null) {
                this.m_loByteVec = new ArrayList<Integer>();
            }
            this.m_loByteVec.add(n2);
            this.m_loByteVec.add(n);
        }
        this._updateDuplicateNonAsciiMoves();
    }

    private void _updateDuplicateNonAsciiMoves() {
        for (int i = 0; i < s_nonAsciiTableForMethod.size(); ++i) {
            NfaState nfaState = s_nonAsciiTableForMethod.get(i);
            if (!NfaState._equalLoByteVectors(this.m_loByteVec, nfaState.m_loByteVec) || !NfaState._equalNonAsciiMoveIndices(this.m_nonAsciiMoveIndices, nfaState.m_nonAsciiMoveIndices)) continue;
            this.m_nonAsciiMethod = i;
            return;
        }
        this.m_nonAsciiMethod = s_nonAsciiTableForMethod.size();
        s_nonAsciiTableForMethod.add(this);
    }

    private static boolean _equalLoByteVectors(List<Integer> list, List<Integer> list2) {
        if (list == null || list2 == null) {
            return false;
        }
        if (list == list2) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).intValue() == list2.get(i).intValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean _equalNonAsciiMoveIndices(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    static boolean allBitsSet(String string) {
        return string.equals(s_allBits);
    }

    static int addStartStateSet(String string) {
        return NfaState._addCompositeStateSet(string, true);
    }

    private static int _addCompositeStateSet(String string, boolean bl) {
        int n;
        Integer n2 = s_stateNameForComposite.get(string);
        if (n2 != null) {
            return n2;
        }
        int n3 = 0;
        int[] nArray = s_allNextStates.get(string);
        if (!bl) {
            s_stateBlockTable.put(string, string);
        }
        if (nArray == null) {
            JavaCCErrors.internalError();
        }
        if (nArray.length == 1) {
            n2 = nArray[0];
            s_stateNameForComposite.put(string, n2);
            return nArray[0];
        }
        for (int n4 : nArray) {
            if (n4 == -1) continue;
            NfaState nfaState = s_indexedAllStates.get(n4);
            nfaState.m_isComposite = true;
            nfaState.m_compositeStates = nArray;
        }
        while (n3 < nArray.length && bl && NfaState.s_indexedAllStates.get((int)nArray[n3]).m_inNextOf > 1) {
            ++n3;
        }
        Object object = s_compositeStateTable.keySet().iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            if (string2.equals(string) || !NfaState._intersect(string, string2)) continue;
            int[] nArray2 = s_compositeStateTable.get(string2);
            while (n3 < nArray.length && (bl && NfaState.s_indexedAllStates.get((int)nArray[n3]).m_inNextOf > 1 || NfaState._elemOccurs(nArray[n3], nArray2) >= 0)) {
                ++n3;
            }
        }
        if (n3 >= nArray.length) {
            n = s_dummyStateIndex == -1 ? (s_dummyStateIndex = s_generatedStates) : ++s_dummyStateIndex;
            if (Options.getTokenManagerCodeGenerator() != null) {
                NfaState nfaState = new NfaState();
                nfaState.m_isComposite = true;
                nfaState.m_compositeStates = nArray;
                nfaState.m_stateName = n;
            }
        } else {
            n = nArray[n3];
        }
        n2 = n;
        s_stateNameForComposite.put(string, n2);
        s_compositeStateTable.put(string, nArray);
        return n;
    }

    private static int _stateNameForComposite(String string) {
        return s_stateNameForComposite.get(string);
    }

    static int initStateName() {
        String string = LexGenJava.s_initialState._getEpsilonMovesString();
        if (LexGenJava.s_initialState.m_usefulEpsilonMoves != 0) {
            return NfaState._stateNameForComposite(string);
        }
        return -1;
    }

    public int generateInitMoves() {
        this._getEpsilonMovesString();
        if (this.m_epsilonMovesString == null) {
            this.m_epsilonMovesString = "null;";
        }
        return NfaState.addStartStateSet(this.m_epsilonMovesString);
    }

    private static int[] _getStateSetIndicesForUse(String string) {
        int[] nArray = s_allNextStates.get(string);
        int[] nArray2 = s_tableToDump.get(string);
        if (nArray2 == null) {
            nArray2 = new int[]{s_lastIndex, s_lastIndex + nArray.length - 1};
            s_lastIndex += nArray.length;
            s_tableToDump.put(string, nArray2);
            s_orderedStateSet.add(nArray);
        }
        return nArray2;
    }

    public static void dumpStateSets(CodeGenerator codeGenerator) {
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCode("static final int[] jjnextStates = {");
                break;
            }
            case CPP: {
                codeGenerator.switchToStaticsFile();
                codeGenerator.genCode("static const int jjnextStates[] = {");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        if (s_orderedStateSet.size() > 0) {
            int n = 0;
            for (int i = 0; i < s_orderedStateSet.size(); ++i) {
                int[] nArray;
                for (int n2 : nArray = s_orderedStateSet.get(i)) {
                    if (n++ % 16 == 0) {
                        codeGenerator.genCode("\n   ");
                    }
                    codeGenerator.genCode(n2 + ", ");
                }
            }
        } else {
            codeGenerator.genCode("0");
        }
        codeGenerator.genCodeLine("\n};");
        codeGenerator.switchToMainFile();
    }

    private static String _getStateSetString(int[] nArray) {
        String string = "{ ";
        int n = 0;
        while (n < nArray.length) {
            string = string + nArray[n] + ", ";
            if (n++ <= 0 || n % 16 != 0) continue;
            string = string + "\n";
        }
        string = string + "};";
        s_allNextStates.put(string, nArray);
        return string;
    }

    static String getStateSetString(List<NfaState> list) {
        if (list == null || list.size() == 0) {
            return "null;";
        }
        int[] nArray = new int[list.size()];
        String string = "{ ";
        int n = 0;
        while (n < list.size()) {
            int n2 = list.get((int)n).m_stateName;
            string = string + n2 + ", ";
            nArray[n] = n2;
            if (n++ <= 0 || n % 16 != 0) continue;
            string = string + "\n";
        }
        string = string + "};";
        s_allNextStates.put(string, nArray);
        return string;
    }

    private static int _numberOfBitsSet(long l) {
        int n = 0;
        for (int i = 0; i < 63; ++i) {
            if ((l >> i & 1L) == 0L) continue;
            ++n;
        }
        return n;
    }

    private static int _isOnlyOneBitSet(long l) {
        int n = -1;
        for (int i = 0; i < 64; ++i) {
            if ((l >> i & 1L) == 0L) continue;
            if (n >= 0) {
                return -1;
            }
            n = i;
        }
        return n;
    }

    private static int _elemOccurs(int n, int[] nArray) {
        int n2 = nArray.length;
        while (n2-- > 0) {
            if (nArray[n2] != n) continue;
            return n2;
        }
        return -1;
    }

    private boolean _findCommonBlocks() {
        int n;
        String string;
        int[] nArray;
        if (this.m_next == null || this.m_next.m_usefulEpsilonMoves <= 1) {
            return false;
        }
        if (s_stateDone == null) {
            s_stateDone = new boolean[s_generatedStates];
        }
        if ((nArray = s_allNextStates.get(string = this.m_next.m_epsilonMovesString)).length <= 2 || s_compositeStateTable.get(string) != null) {
            return false;
        }
        int[] nArray2 = new int[nArray.length];
        boolean[] blArray = new boolean[nArray.length];
        int[] nArray3 = new int[s_allNextStates.size()];
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == -1) continue;
            boolean bl = blArray[n] = !s_stateDone[nArray[n]];
            if (!blArray[n]) continue;
            nArray3[0] = nArray3[0] + 1;
        }
        n = 0;
        int n2 = 0;
        for (Map.Entry<String, int[]> entry : s_allNextStates.entrySet()) {
            int n3;
            int n4;
            int[] nArray4 = entry.getValue();
            if (nArray4 == nArray) continue;
            boolean bl = false;
            for (n4 = 0; n4 < nArray.length; ++n4) {
                if (nArray[n4] == -1 || !blArray[n4] || NfaState._elemOccurs(nArray[n4], nArray4) < 0) continue;
                if (!bl) {
                    bl = true;
                }
                int n5 = nArray2[n4];
                nArray3[n5] = nArray3[n5] - 1;
                int n6 = ++n2;
                nArray3[n6] = nArray3[n6] + 1;
                nArray2[n4] = n2;
            }
            if (!bl) continue;
            n4 = -1;
            n = 0;
            for (n3 = 0; n3 <= n2; ++n3) {
                if (nArray3[n3] <= n) continue;
                n4 = n3;
                n = nArray3[n3];
            }
            if (n <= 1) {
                return false;
            }
            for (n3 = 0; n3 < nArray.length; ++n3) {
                if (nArray[n3] == -1 || nArray2[n3] == n4) continue;
                blArray[n3] = false;
                int n7 = nArray2[n3];
                nArray3[n7] = nArray3[n7] - 1;
            }
        }
        if (n <= 1) {
            return false;
        }
        Object object = new int[n];
        int n8 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (!blArray[i]) continue;
            if (NfaState.s_indexedAllStates.get((int)nArray[i]).m_isComposite) {
                return false;
            }
            NfaState.s_stateDone[nArray[i]] = true;
            object[n8++] = nArray[i];
        }
        String string2 = NfaState._getStateSetString((int[])object);
        block6: for (Map.Entry<String, int[]> entry : s_allNextStates.entrySet()) {
            boolean bl = true;
            String string3 = entry.getKey();
            int[] nArray5 = entry.getValue();
            if (nArray5 == object) continue;
            for (int i = 0; i < n8; ++i) {
                int n9 = NfaState._elemOccurs((int)object[i], nArray5);
                if (n9 < 0) continue block6;
                if (!bl) {
                    nArray5[n9] = -1;
                }
                bl = false;
            }
            if (s_stateSetsToFix.get(string3) != null) continue;
            s_stateSetsToFix.put(string3, nArray5);
        }
        this.m_next.m_usefulEpsilonMoves -= n - 1;
        NfaState._addCompositeStateSet(string2, false);
        return true;
    }

    private boolean _checkNextOccursTogether() {
        int n;
        int[] nArray;
        String string;
        if (this.m_next == null || this.m_next.m_usefulEpsilonMoves <= 1) {
            return true;
        }
        String string2 = this.m_next.m_epsilonMovesString;
        int[] nArray2 = s_allNextStates.get(string2);
        if (nArray2.length == 1 || s_compositeStateTable.get(string2) != null || s_stateSetsToFix.get(string2) != null) {
            return false;
        }
        HashMap<String, int[]> hashMap = new HashMap<String, int[]>();
        NfaState nfaState = s_allStates.get(nArray2[0]);
        for (int i = 1; i < nArray2.length; ++i) {
            NfaState entry = s_allStates.get(nArray2[i]);
            if (nfaState.m_inNextOf == entry.m_inNextOf) continue;
            return false;
        }
        for (Map.Entry<String, int[]> entry : s_allNextStates.entrySet()) {
            string = entry.getKey();
            nArray = entry.getValue();
            if (nArray == nArray2) continue;
            n = 0;
            int n2 = 0;
            for (int n3 : nArray2) {
                if (NfaState._elemOccurs(n3, nArray) >= 0) {
                    ++n;
                } else if (n > 0) {
                    return false;
                }
                ++n2;
            }
            if (n == n2) {
                if (nArray.length > nArray2.length) {
                    hashMap.put(string, nArray);
                }
                if (s_compositeStateTable.get(string) == null && s_stateSetsToFix.get(string) == null) continue;
                return false;
            }
            if (n == 0) continue;
            return false;
        }
        for (Map.Entry<String, Object> entry : hashMap.entrySet()) {
            string = entry.getKey();
            nArray = (int[])entry.getValue();
            if (!s_stateSetsToFix.containsKey(string)) {
                s_stateSetsToFix.put(string, nArray);
            }
            for (n = 0; n < nArray.length; ++n) {
                if (NfaState._elemOccurs(nArray[n], nArray2) <= 0) continue;
                nArray[n] = -1;
            }
        }
        this.m_next.m_usefulEpsilonMoves = 1;
        NfaState._addCompositeStateSet(this.m_next.m_epsilonMovesString, false);
        return true;
    }

    private static void _fixStateSets() {
        Object object;
        HashMap<Object, int[]> hashMap = new HashMap<Object, int[]>();
        int[] nArray = new int[s_generatedStates];
        for (Map.Entry<String, int[]> object2 : s_stateSetsToFix.entrySet()) {
            object = object2.getKey();
            int[] nArray2 = object2.getValue();
            int n = 0;
            for (int n2 : nArray2) {
                if (n2 == -1) continue;
                nArray[n++] = n2;
            }
            int[] nArray3 = new int[n];
            System.arraycopy(nArray, 0, nArray3, 0, n);
            hashMap.put(object, nArray3);
            s_allNextStates.put((String)object, nArray3);
        }
        for (int i = 0; i < s_allStates.size(); ++i) {
            NfaState nfaState = s_allStates.get(i);
            if (nfaState.m_next == null || nfaState.m_next.m_usefulEpsilonMoves == 0 || (object = (Object)((int[])hashMap.get(nfaState.m_next.m_epsilonMovesString))) == null) continue;
            nfaState._fixNextStates((int[])object);
        }
    }

    private final void _fixNextStates(int[] nArray) {
        this.m_next.m_usefulEpsilonMoves = nArray.length;
    }

    private static boolean _intersect(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int[] nArray = s_allNextStates.get(string);
        int[] nArray2 = s_allNextStates.get(string2);
        if (nArray == null || nArray2 == null) {
            return false;
        }
        if (nArray == nArray2) {
            return true;
        }
        int n = nArray.length;
        while (n-- > 0) {
            int n2 = nArray2.length;
            while (n2-- > 0) {
                if (nArray[n] != nArray2[n2]) continue;
                return true;
            }
        }
        return false;
    }

    private static void _dumpHeadForCase(CodeGenerator codeGenerator, int n) {
        block10: {
            EOutputLanguage eOutputLanguage;
            block11: {
                block9: {
                    eOutputLanguage = codeGenerator.getOutputLanguage();
                    if (n != 0) break block9;
                    codeGenerator.genCodeLine("         " + eOutputLanguage.getTypeLong() + " l = 1L << curChar;");
                    switch (eOutputLanguage) {
                        case JAVA: {
                            break block10;
                        }
                        case CPP: {
                            codeGenerator.genCodeLine("         (void)l;");
                            break block10;
                        }
                        default: {
                            throw new UnsupportedOutputLanguageException(eOutputLanguage);
                        }
                    }
                }
                if (n != 1) break block11;
                codeGenerator.genCodeLine("         " + eOutputLanguage.getTypeLong() + " l = 1L << (curChar & 077);");
                switch (eOutputLanguage) {
                    case JAVA: {
                        break block10;
                    }
                    case CPP: {
                        codeGenerator.genCodeLine("         (void)l;");
                        break block10;
                    }
                    default: {
                        throw new UnsupportedOutputLanguageException(eOutputLanguage);
                    }
                }
            }
            if (Options.isJavaUnicodeEscape() || s_unicodeWarningGiven) {
                codeGenerator.genCodeLine("         int hiByte = (curChar >> 8);");
                codeGenerator.genCodeLine("         int i1 = hiByte >> 6;");
                codeGenerator.genCodeLine("         " + eOutputLanguage.getTypeLong() + " l1 = 1L << (hiByte & 077);");
            }
            codeGenerator.genCodeLine("         int i2 = (curChar & 0xff) >> 6;");
            codeGenerator.genCodeLine("         " + eOutputLanguage.getTypeLong() + " l2 = 1L << (curChar & 077);");
        }
        codeGenerator.genCodeLine("         do");
        codeGenerator.genCodeLine("         {");
        codeGenerator.genCodeLine("            switch(jjstateSet[--i])");
        codeGenerator.genCodeLine("            {");
    }

    private static List<List<NfaState>> _partitionStatesSetForAscii(int[] nArray, int n) {
        int n2;
        NfaState nfaState;
        int n3;
        int n4;
        int[] nArray2 = new int[nArray.length];
        List<NfaState> list = new ArrayList();
        ArrayList<List<NfaState>> arrayList = new ArrayList<List<NfaState>>();
        int[] nArray3 = nArray;
        int n5 = nArray3.length;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray3[n4];
            list.add(null);
        }
        int n6 = 0;
        for (n5 = 0; n5 < nArray.length; ++n5) {
            nfaState = s_allStates.get(nArray[n5]);
            if (nfaState.m_asciiMoves[n] == 0L) continue;
            n3 = NfaState._numberOfBitsSet(nfaState.m_asciiMoves[n]);
            for (n4 = 0; n4 < n5 && nArray2[n4] > n3; ++n4) {
            }
            for (n2 = n5; n2 > n4; --n2) {
                nArray2[n2] = nArray2[n2 - 1];
            }
            nArray2[n4] = n3;
            list.add(n4, nfaState);
            ++n6;
        }
        while (list.size() < n6) {
            list.add(null);
        }
        if (list.size() > n6) {
            list = list.subList(0, n6);
        }
        while (!list.isEmpty()) {
            nfaState = (NfaState)list.remove(0);
            long l = nfaState.m_asciiMoves[n];
            ArrayList<NfaState> arrayList2 = new ArrayList<NfaState>();
            arrayList2.add(nfaState);
            for (n2 = 0; n2 < list.size(); ++n2) {
                NfaState nfaState2 = (NfaState)list.get(n2);
                if ((nfaState2.m_asciiMoves[n] & l) != 0L) continue;
                l |= nfaState2.m_asciiMoves[n];
                arrayList2.add(nfaState2);
                list.remove(n2--);
            }
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    private String _printNoBreak(CodeGenerator codeGenerator, int n, boolean[] blArray) {
        if (this.m_inNextOf != 1) {
            JavaCCErrors.internalError();
        }
        blArray[this.m_stateName] = true;
        if (n >= 0) {
            if (this.m_asciiMoves[n] != 0L) {
                codeGenerator.genCodeLine("               case " + this.m_stateName + ":");
                this._dumpAsciiMoveForCompositeState(codeGenerator, n, false);
                return "";
            }
        } else if (this.m_nonAsciiMethod != -1) {
            codeGenerator.genCodeLine("               case " + this.m_stateName + ":");
            this._dumpNonAsciiMoveForCompositeState(codeGenerator);
            return "";
        }
        return "               case " + this.m_stateName + ":\n";
    }

    private static void _dumpCompositeStatesAsciiMoves(CodeGenerator codeGenerator, String string, int n, boolean[] blArray) {
        int[] nArray = s_allNextStates.get(string);
        if (nArray.length == 1 || blArray[NfaState._stateNameForComposite(string)]) {
            return;
        }
        NfaState nfaState = null;
        int n2 = 0;
        NfaState nfaState2 = null;
        String string2 = "";
        boolean bl = s_stateBlockTable.get(string) != null;
        for (int n3 : nArray) {
            NfaState nfaState3 = s_allStates.get(n3);
            if (nfaState3.m_asciiMoves[n] != 0L) {
                if (n2++ == 1) break;
                nfaState = nfaState3;
            } else {
                blArray[nfaState3.m_stateName] = true;
            }
            if (nfaState3.m_stateForCase == null) continue;
            if (nfaState2 != null) {
                JavaCCErrors.internalError();
            }
            nfaState2 = nfaState3.m_stateForCase;
        }
        if (nfaState2 != null) {
            string2 = super._printNoBreak(codeGenerator, n, blArray);
        }
        if (n2 == 0) {
            if (nfaState2 != null && string2.length() == 0) {
                codeGenerator.genCodeLine("                  break;");
            }
            return;
        }
        if (n2 == 1) {
            if (StringHelper.hasText((String)string2)) {
                codeGenerator.genCode(string2);
            }
            codeGenerator.genCodeLine("               case " + NfaState._stateNameForComposite(string) + ":");
            if (!blArray[nfaState.m_stateName] && !bl && nfaState.m_inNextOf > 1) {
                codeGenerator.genCodeLine("               case " + nfaState.m_stateName + ":");
            }
            blArray[nfaState.m_stateName] = true;
            nfaState._dumpAsciiMove(codeGenerator, n, blArray);
            return;
        }
        Object object = NfaState._partitionStatesSetForAscii(nArray, n);
        if (StringHelper.hasText((String)string2)) {
            codeGenerator.genCode(string2);
        }
        int n4 = NfaState._stateNameForComposite(string);
        codeGenerator.genCodeLine("               case " + n4 + ":");
        if (n4 < s_generatedStates) {
            blArray[n4] = true;
        }
        for (int i = 0; i < object.size(); ++i) {
            List list = (List)object.get(i);
            int n5 = 0;
            for (NfaState nfaState4 : list) {
                if (bl) {
                    blArray[nfaState4.m_stateName] = true;
                }
                nfaState4._dumpAsciiMoveForCompositeState(codeGenerator, n, n5 != 0);
                ++n5;
            }
        }
        if (bl) {
            codeGenerator.genCodeLine("                  break;");
        } else {
            codeGenerator.genCodeLine("                  break;");
        }
    }

    private boolean _selfLoop() {
        if (this.m_next == null || this.m_next.m_epsilonMovesString == null) {
            return false;
        }
        int[] nArray = s_allNextStates.get(this.m_next.m_epsilonMovesString);
        return NfaState._elemOccurs(this.m_stateName, nArray) >= 0;
    }

    private void _dumpAsciiMoveForCompositeState(CodeGenerator codeGenerator, int n, boolean bl) {
        Object object;
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        boolean bl2 = this._selfLoop();
        for (int i = 0; i < s_allStates.size(); ++i) {
            object = s_allStates.get(i);
            if (this == object || ((NfaState)object).m_stateName == -1 || ((NfaState)object).m_dummy || this.m_stateName == ((NfaState)object).m_stateName || ((NfaState)object).m_asciiMoves[n] == 0L || bl2 || !NfaState._intersect(((NfaState)object).m_next.m_epsilonMovesString, this.m_next.m_epsilonMovesString)) continue;
            bl2 = true;
            break;
        }
        String string = "";
        if (this.m_asciiMoves[n] != -1L) {
            int n2 = NfaState._isOnlyOneBitSet(this.m_asciiMoves[n]);
            if (n2 != -1) {
                codeGenerator.genCodeLine("                  " + (bl ? "else " : "") + "if (curChar == " + (64 * n + n2) + ")");
            } else {
                codeGenerator.genCodeLine("                  " + (bl ? "else " : "") + "if ((" + eOutputLanguage.getLongHex(this.m_asciiMoves[n]) + " & l) != " + eOutputLanguage.getLongPlain(0L) + ")");
            }
            string = "   ";
        }
        if (this.m_kindToPrint != Integer.MAX_VALUE) {
            if (this.m_asciiMoves[n] != -1L) {
                codeGenerator.genCodeLine("                  {");
            }
            codeGenerator.genCodeLine(string + "                  if (kind > " + this.m_kindToPrint + ")");
            codeGenerator.genCodeLine(string + "                     kind = " + this.m_kindToPrint + ";");
        }
        if (this.m_next != null && this.m_next.m_usefulEpsilonMoves > 0) {
            object = s_allNextStates.get(this.m_next.m_epsilonMovesString);
            if (this.m_next.m_usefulEpsilonMoves == 1) {
                Object object2 = object[0];
                if (bl2) {
                    codeGenerator.genCodeLine(string + "                  { jjCheckNAdd(" + (int)object2 + "); }");
                } else {
                    codeGenerator.genCodeLine(string + "                  jjstateSet[jjnewStateCnt++] = " + (int)object2 + ";");
                }
            } else if (this.m_next.m_usefulEpsilonMoves == 2 && bl2) {
                codeGenerator.genCodeLine(string + "                  { jjCheckNAddTwoStates(" + (int)object[0] + ", " + (int)object[1] + "); }");
            } else {
                boolean bl3;
                int[] nArray = NfaState._getStateSetIndicesForUse(this.m_next.m_epsilonMovesString);
                boolean bl4 = bl3 = nArray[0] + 1 != nArray[1];
                if (bl2) {
                    codeGenerator.genCode(string + "                  { jjCheckNAddStates(" + nArray[0]);
                    if (bl3) {
                        s_jjCheckNAddStatesDualNeeded = true;
                        codeGenerator.genCode(", " + nArray[1]);
                    } else {
                        s_jjCheckNAddStatesUnaryNeeded = true;
                    }
                    codeGenerator.genCodeLine("); }");
                } else {
                    codeGenerator.genCodeLine(string + "                  { jjAddStates(" + nArray[0] + ", " + nArray[1] + "); }");
                }
            }
        }
        if (this.m_asciiMoves[n] != -1L && this.m_kindToPrint != Integer.MAX_VALUE) {
            codeGenerator.genCodeLine("                  }");
        }
    }

    private void _dumpAsciiMove(CodeGenerator codeGenerator, int n, boolean[] blArray) {
        Object object;
        int n2;
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        boolean bl = this._selfLoop() && this.m_isComposite;
        boolean bl2 = true;
        for (n2 = 0; n2 < s_allStates.size(); ++n2) {
            object = s_allStates.get(n2);
            if (this == object || ((NfaState)object).m_stateName == -1 || ((NfaState)object).m_dummy || this.m_stateName == ((NfaState)object).m_stateName || ((NfaState)object).m_asciiMoves[n] == 0L) continue;
            if (bl2 && (this.m_asciiMoves[n] & ((NfaState)object).m_asciiMoves[n]) != 0L) {
                bl2 = false;
            }
            if (!bl && NfaState._intersect(((NfaState)object).m_next.m_epsilonMovesString, this.m_next.m_epsilonMovesString)) {
                bl = true;
            }
            if (blArray[((NfaState)object).m_stateName] || ((NfaState)object).m_isComposite || this.m_asciiMoves[n] != ((NfaState)object).m_asciiMoves[n] || this.m_kindToPrint != ((NfaState)object).m_kindToPrint || this.m_next.m_epsilonMovesString != ((NfaState)object).m_next.m_epsilonMovesString && (this.m_next.m_epsilonMovesString == null || ((NfaState)object).m_next.m_epsilonMovesString == null || !this.m_next.m_epsilonMovesString.equals(((NfaState)object).m_next.m_epsilonMovesString))) continue;
            blArray[((NfaState)object).m_stateName] = true;
            codeGenerator.genCodeLine("               case " + ((NfaState)object).m_stateName + ":");
        }
        n2 = NfaState._isOnlyOneBitSet(this.m_asciiMoves[n]);
        if (this.m_asciiMoves[n] != -1L && (this.m_next == null || this.m_next.m_usefulEpsilonMoves == 0) && this.m_kindToPrint != Integer.MAX_VALUE) {
            object = "";
            if (!bl2) {
                object = " && kind > " + this.m_kindToPrint;
            }
            if (n2 != -1) {
                codeGenerator.genCodeLine("                  if (curChar == " + (64 * n + n2) + (String)object + ")");
            } else {
                codeGenerator.genCodeLine("                  if ((" + eOutputLanguage.getLongHex(this.m_asciiMoves[n]) + " & l) != " + eOutputLanguage.getLongPlain(0L) + (String)object + ")");
            }
            codeGenerator.genCodeLine("                     kind = " + this.m_kindToPrint + ";");
            if (bl2) {
                codeGenerator.genCodeLine("                  break;");
            } else {
                codeGenerator.genCodeLine("                  break;");
            }
            return;
        }
        object = "";
        if (this.m_kindToPrint != Integer.MAX_VALUE) {
            if (n2 != -1) {
                codeGenerator.genCodeLine("                  if (curChar != " + (64 * n + n2) + ")");
                codeGenerator.genCodeLine("                     break;");
            } else if (this.m_asciiMoves[n] != -1L) {
                codeGenerator.genCodeLine("                  if ((" + eOutputLanguage.getLongHex(this.m_asciiMoves[n]) + " & l) == " + eOutputLanguage.getLongPlain(0L) + ")");
                codeGenerator.genCodeLine("                     break;");
            }
            if (bl2) {
                codeGenerator.genCodeLine("                  kind = " + this.m_kindToPrint + ";");
            } else {
                codeGenerator.genCodeLine("                  if (kind > " + this.m_kindToPrint + ")");
                codeGenerator.genCodeLine("                     kind = " + this.m_kindToPrint + ";");
            }
        } else if (n2 != -1) {
            codeGenerator.genCodeLine("                  if (curChar == " + (64 * n + n2) + ")");
            object = "   ";
        } else if (this.m_asciiMoves[n] != -1L) {
            codeGenerator.genCodeLine("                  if ((" + eOutputLanguage.getLongHex(this.m_asciiMoves[n]) + " & l) != " + eOutputLanguage.getLongPlain(0L) + ")");
            object = "   ";
        }
        if (this.m_next != null && this.m_next.m_usefulEpsilonMoves > 0) {
            int[] nArray = s_allNextStates.get(this.m_next.m_epsilonMovesString);
            if (this.m_next.m_usefulEpsilonMoves == 1) {
                int n3 = nArray[0];
                if (bl) {
                    codeGenerator.genCodeLine((String)object + "                  { jjCheckNAdd(" + n3 + "); }");
                } else {
                    codeGenerator.genCodeLine((String)object + "                  jjstateSet[jjnewStateCnt++] = " + n3 + ";");
                }
            } else if (this.m_next.m_usefulEpsilonMoves == 2 && bl) {
                codeGenerator.genCodeLine((String)object + "                  { jjCheckNAddTwoStates(" + nArray[0] + ", " + nArray[1] + "); }");
            } else {
                boolean bl3;
                int[] nArray2 = NfaState._getStateSetIndicesForUse(this.m_next.m_epsilonMovesString);
                boolean bl4 = bl3 = nArray2[0] + 1 != nArray2[1];
                if (bl) {
                    codeGenerator.genCode((String)object + "                  { jjCheckNAddStates(" + nArray2[0]);
                    if (bl3) {
                        s_jjCheckNAddStatesDualNeeded = true;
                        codeGenerator.genCode(", " + nArray2[1]);
                    } else {
                        s_jjCheckNAddStatesUnaryNeeded = true;
                    }
                    codeGenerator.genCodeLine("); }");
                } else {
                    codeGenerator.genCodeLine((String)object + "                  { jjAddStates(" + nArray2[0] + ", " + nArray2[1] + "); }");
                }
            }
        }
        if (bl2) {
            codeGenerator.genCodeLine("                  break;");
        } else {
            codeGenerator.genCodeLine("                  break;");
        }
    }

    private static void _dumpAsciiMoves(CodeGenerator codeGenerator, int n) {
        boolean[] blArray = new boolean[Math.max(s_generatedStates, s_dummyStateIndex + 1)];
        NfaState._dumpHeadForCase(codeGenerator, n);
        for (String object : s_compositeStateTable.keySet()) {
            NfaState._dumpCompositeStatesAsciiMoves(codeGenerator, object, n, blArray);
        }
        for (int i = 0; i < s_allStates.size(); ++i) {
            NfaState nfaState = s_allStates.get(i);
            if (blArray[nfaState.m_stateName] || nfaState.m_lexState != LexGenJava.s_lexStateIndex || !nfaState.hasTransitions() || nfaState.m_dummy || nfaState.m_stateName == -1) continue;
            String string = "";
            if (nfaState.m_stateForCase != null) {
                if (nfaState.m_inNextOf == 1 || blArray[nfaState.m_stateForCase.m_stateName]) continue;
                string = nfaState.m_stateForCase._printNoBreak(codeGenerator, n, blArray);
                if (nfaState.m_asciiMoves[n] == 0L) {
                    if (!StringHelper.hasNoText((String)string)) continue;
                    codeGenerator.genCodeLine("                  break;");
                    continue;
                }
            }
            if (nfaState.m_asciiMoves[n] == 0L) continue;
            if (StringHelper.hasText((String)string)) {
                codeGenerator.genCode(string);
            }
            blArray[nfaState.m_stateName] = true;
            codeGenerator.genCodeLine("               case " + nfaState.m_stateName + ":");
            nfaState._dumpAsciiMove(codeGenerator, n, blArray);
        }
        if (n != 0 && n != 1) {
            codeGenerator.genCodeLine("               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;");
        } else {
            codeGenerator.genCodeLine("               default : break;");
        }
        codeGenerator.genCodeLine("            }");
        codeGenerator.genCodeLine("         } while(i != startsAt);");
    }

    private static void _dumpCompositeStatesNonAsciiMoves(CodeGenerator codeGenerator, String string, boolean[] blArray) {
        NfaState nfaState;
        int[] nArray = s_allNextStates.get(string);
        if (nArray.length == 1 || blArray[NfaState._stateNameForComposite(string)]) {
            return;
        }
        NfaState nfaState2 = null;
        int n = 0;
        NfaState nfaState3 = null;
        String string2 = "";
        boolean bl = s_stateBlockTable.get(string) != null;
        for (int n2 : nArray) {
            nfaState = s_allStates.get(n2);
            if (nfaState.m_nonAsciiMethod != -1) {
                if (n++ == 1) break;
                nfaState2 = nfaState;
            } else {
                blArray[nfaState.m_stateName] = true;
            }
            if (nfaState.m_stateForCase == null) continue;
            if (nfaState3 != null) {
                JavaCCErrors.internalError();
            }
            nfaState3 = nfaState.m_stateForCase;
        }
        if (nfaState3 != null) {
            string2 = super._printNoBreak(codeGenerator, -1, blArray);
        }
        if (n == 0) {
            if (nfaState3 != null && StringHelper.hasNoText((String)string2)) {
                codeGenerator.genCodeLine("                  break;");
            }
            return;
        }
        if (n == 1) {
            if (StringHelper.hasText((String)string2)) {
                codeGenerator.genCode(string2);
            }
            codeGenerator.genCodeLine("               case " + NfaState._stateNameForComposite(string) + ":");
            if (!blArray[nfaState2.m_stateName] && !bl && nfaState2.m_inNextOf > 1) {
                codeGenerator.genCodeLine("               case " + nfaState2.m_stateName + ":");
            }
            blArray[nfaState2.m_stateName] = true;
            nfaState2._dumpNonAsciiMove(codeGenerator, blArray);
            return;
        }
        if (StringHelper.hasText((String)string2)) {
            codeGenerator.genCode(string2);
        }
        int n3 = NfaState._stateNameForComposite(string);
        codeGenerator.genCodeLine("               case " + n3 + ":");
        if (n3 < s_generatedStates) {
            blArray[n3] = true;
        }
        for (int n4 : nArray) {
            nfaState = s_allStates.get(n4);
            if (nfaState.m_nonAsciiMethod == -1) continue;
            if (bl) {
                blArray[nfaState.m_stateName] = true;
            }
            nfaState._dumpNonAsciiMoveForCompositeState(codeGenerator);
        }
        if (bl) {
            codeGenerator.genCodeLine("                  break;");
        } else {
            codeGenerator.genCodeLine("                  break;");
        }
    }

    private final void _dumpNonAsciiMoveForCompositeState(CodeGenerator codeGenerator) {
        Object object;
        boolean bl = this._selfLoop();
        for (int i = 0; i < s_allStates.size(); ++i) {
            object = s_allStates.get(i);
            if (this == object || ((NfaState)object).m_stateName == -1 || ((NfaState)object).m_dummy || this.m_stateName == ((NfaState)object).m_stateName || ((NfaState)object).m_nonAsciiMethod == -1 || bl || !NfaState._intersect(((NfaState)object).m_next.m_epsilonMovesString, this.m_next.m_epsilonMovesString)) continue;
            bl = true;
            break;
        }
        if (!Options.isJavaUnicodeEscape() && !s_unicodeWarningGiven) {
            if (this.m_loByteVec != null && this.m_loByteVec.size() > 1) {
                codeGenerator.genCodeLine("                  if ((jjbitVec" + this.m_loByteVec.get(1) + "[i2] & l2) != 0L)");
            }
        } else {
            codeGenerator.genCodeLine("                  if (jjCanMove_" + this.m_nonAsciiMethod + "(hiByte, i1, i2, l1, l2))");
        }
        if (this.m_kindToPrint != Integer.MAX_VALUE) {
            codeGenerator.genCodeLine("                  {");
            codeGenerator.genCodeLine("                     if (kind > " + this.m_kindToPrint + ")");
            codeGenerator.genCodeLine("                        kind = " + this.m_kindToPrint + ";");
        }
        if (this.m_next != null && this.m_next.m_usefulEpsilonMoves > 0) {
            int[] nArray = s_allNextStates.get(this.m_next.m_epsilonMovesString);
            if (this.m_next.m_usefulEpsilonMoves == 1) {
                int n = nArray[0];
                if (bl) {
                    codeGenerator.genCodeLine("                     { jjCheckNAdd(" + n + "); }");
                } else {
                    codeGenerator.genCodeLine("                     jjstateSet[jjnewStateCnt++] = " + n + ";");
                }
            } else if (this.m_next.m_usefulEpsilonMoves == 2 && bl) {
                codeGenerator.genCodeLine("                     { jjCheckNAddTwoStates(" + nArray[0] + ", " + nArray[1] + "); }");
            } else {
                boolean bl2;
                object = NfaState._getStateSetIndicesForUse(this.m_next.m_epsilonMovesString);
                boolean bl3 = bl2 = object[0] + true != object[1];
                if (bl) {
                    codeGenerator.genCode("                     { jjCheckNAddStates(" + (int)object[0]);
                    if (bl2) {
                        s_jjCheckNAddStatesDualNeeded = true;
                        codeGenerator.genCode(", " + (int)object[1]);
                    } else {
                        s_jjCheckNAddStatesUnaryNeeded = true;
                    }
                    codeGenerator.genCodeLine("); }");
                } else {
                    codeGenerator.genCodeLine("                     { jjAddStates(" + (int)object[0] + ", " + (int)object[1] + "); }");
                }
            }
        }
        if (this.m_kindToPrint != Integer.MAX_VALUE) {
            codeGenerator.genCodeLine("                  }");
        }
    }

    private final void _dumpNonAsciiMove(CodeGenerator codeGenerator, boolean[] blArray) {
        Object object;
        boolean bl = this._selfLoop() && this.m_isComposite;
        for (int i = 0; i < s_allStates.size(); ++i) {
            object = s_allStates.get(i);
            if (this == object || ((NfaState)object).m_stateName == -1 || ((NfaState)object).m_dummy || this.m_stateName == ((NfaState)object).m_stateName || ((NfaState)object).m_nonAsciiMethod == -1) continue;
            if (!bl && NfaState._intersect(((NfaState)object).m_next.m_epsilonMovesString, this.m_next.m_epsilonMovesString)) {
                bl = true;
            }
            if (blArray[((NfaState)object).m_stateName] || ((NfaState)object).m_isComposite || this.m_nonAsciiMethod != ((NfaState)object).m_nonAsciiMethod || this.m_kindToPrint != ((NfaState)object).m_kindToPrint || this.m_next.m_epsilonMovesString != ((NfaState)object).m_next.m_epsilonMovesString && (this.m_next.m_epsilonMovesString == null || ((NfaState)object).m_next.m_epsilonMovesString == null || !this.m_next.m_epsilonMovesString.equals(((NfaState)object).m_next.m_epsilonMovesString))) continue;
            blArray[((NfaState)object).m_stateName] = true;
            codeGenerator.genCodeLine("               case " + ((NfaState)object).m_stateName + ":");
        }
        if (this.m_next == null || this.m_next.m_usefulEpsilonMoves <= 0) {
            String string = " && kind > " + this.m_kindToPrint;
            if (!Options.isJavaUnicodeEscape() && !s_unicodeWarningGiven) {
                if (this.m_loByteVec != null && this.m_loByteVec.size() > 1) {
                    codeGenerator.genCodeLine("                  if ((jjbitVec" + this.m_loByteVec.get(1) + "[i2] & l2) != 0L" + string + ")");
                }
            } else {
                codeGenerator.genCodeLine("                  if (jjCanMove_" + this.m_nonAsciiMethod + "(hiByte, i1, i2, l1, l2)" + string + ")");
            }
            codeGenerator.genCodeLine("                     kind = " + this.m_kindToPrint + ";");
            codeGenerator.genCodeLine("                  break;");
            return;
        }
        String string = "   ";
        if (this.m_kindToPrint != Integer.MAX_VALUE) {
            if (!Options.isJavaUnicodeEscape() && !s_unicodeWarningGiven) {
                if (this.m_loByteVec != null && this.m_loByteVec.size() > 1) {
                    codeGenerator.genCodeLine("                  if ((jjbitVec" + this.m_loByteVec.get(1) + "[i2] & l2) == 0L)");
                    codeGenerator.genCodeLine("                     break;");
                }
            } else {
                codeGenerator.genCodeLine("                  if (!jjCanMove_" + this.m_nonAsciiMethod + "(hiByte, i1, i2, l1, l2))");
                codeGenerator.genCodeLine("                     break;");
            }
            codeGenerator.genCodeLine("                  if (kind > " + this.m_kindToPrint + ")");
            codeGenerator.genCodeLine("                     kind = " + this.m_kindToPrint + ";");
            string = "";
        } else if (!Options.isJavaUnicodeEscape() && !s_unicodeWarningGiven) {
            if (this.m_loByteVec != null && this.m_loByteVec.size() > 1) {
                codeGenerator.genCodeLine("                  if ((jjbitVec" + this.m_loByteVec.get(1) + "[i2] & l2) != 0L)");
            }
        } else {
            codeGenerator.genCodeLine("                  if (jjCanMove_" + this.m_nonAsciiMethod + "(hiByte, i1, i2, l1, l2))");
        }
        if (this.m_next != null && this.m_next.m_usefulEpsilonMoves > 0) {
            object = s_allNextStates.get(this.m_next.m_epsilonMovesString);
            if (this.m_next.m_usefulEpsilonMoves == 1) {
                Object object2 = object[0];
                if (bl) {
                    codeGenerator.genCodeLine(string + "                  { jjCheckNAdd(" + (int)object2 + "); }");
                } else {
                    codeGenerator.genCodeLine(string + "                  jjstateSet[jjnewStateCnt++] = " + (int)object2 + ";");
                }
            } else if (this.m_next.m_usefulEpsilonMoves == 2 && bl) {
                codeGenerator.genCodeLine(string + "                  { jjCheckNAddTwoStates(" + (int)object[0] + ", " + (int)object[1] + "); }");
            } else {
                boolean bl2;
                int[] nArray = NfaState._getStateSetIndicesForUse(this.m_next.m_epsilonMovesString);
                boolean bl3 = bl2 = nArray[0] + 1 != nArray[1];
                if (bl) {
                    codeGenerator.genCode(string + "                  { jjCheckNAddStates(" + nArray[0]);
                    if (bl2) {
                        s_jjCheckNAddStatesDualNeeded = true;
                        codeGenerator.genCode(", " + nArray[1]);
                    } else {
                        s_jjCheckNAddStatesUnaryNeeded = true;
                    }
                    codeGenerator.genCodeLine("); }");
                } else {
                    codeGenerator.genCodeLine(string + "                  { jjAddStates(" + nArray[0] + ", " + nArray[1] + "); }");
                }
            }
        }
        codeGenerator.genCodeLine("                  break;");
    }

    public static void dumpCharAndRangeMoves(CodeGenerator codeGenerator) {
        boolean[] blArray = new boolean[Math.max(s_generatedStates, s_dummyStateIndex + 1)];
        NfaState._dumpHeadForCase(codeGenerator, -1);
        for (String object : s_compositeStateTable.keySet()) {
            NfaState._dumpCompositeStatesNonAsciiMoves(codeGenerator, object, blArray);
        }
        for (NfaState nfaState : s_allStates) {
            if (nfaState.m_stateName == -1 || blArray[nfaState.m_stateName] || nfaState.m_lexState != LexGenJava.s_lexStateIndex || !nfaState.hasTransitions() || nfaState.m_dummy) continue;
            String string = "";
            if (nfaState.m_stateForCase != null) {
                if (nfaState.m_inNextOf == 1 || blArray[nfaState.m_stateForCase.m_stateName]) continue;
                string = nfaState.m_stateForCase._printNoBreak(codeGenerator, -1, blArray);
                if (nfaState.m_nonAsciiMethod == -1) {
                    if (!StringHelper.hasNoText((String)string)) continue;
                    codeGenerator.genCodeLine("                  break;");
                    continue;
                }
            }
            if (nfaState.m_nonAsciiMethod == -1) continue;
            if (StringHelper.hasText((String)string)) {
                codeGenerator.genCode(string);
            }
            blArray[nfaState.m_stateName] = true;
            codeGenerator.genCodeLine("               case " + nfaState.m_stateName + ":");
            nfaState._dumpNonAsciiMove(codeGenerator, blArray);
        }
        if (Options.isJavaUnicodeEscape() || s_unicodeWarningGiven) {
            codeGenerator.genCodeLine("               default : if (i1 == 0 || l1 == 0 || i2 == 0 ||  l2 == 0) break; else break;");
        } else {
            codeGenerator.genCodeLine("               default : break;");
        }
        codeGenerator.genCodeLine("            }");
        codeGenerator.genCodeLine("         } while(i != startsAt);");
    }

    public static void dumpNonAsciiMoveMethods(CodeGenerator codeGenerator) {
        if (!Options.isJavaUnicodeEscape() && !s_unicodeWarningGiven) {
            return;
        }
        if (s_nonAsciiTableForMethod.size() <= 0) {
            return;
        }
        for (int i = 0; i < s_nonAsciiTableForMethod.size(); ++i) {
            NfaState nfaState = s_nonAsciiTableForMethod.get(i);
            nfaState._dumpNonAsciiMoveMethod(codeGenerator);
        }
    }

    private void _dumpNonAsciiMoveMethod(CodeGenerator codeGenerator) {
        int n;
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCodeLine("private static final " + eOutputLanguage.getTypeBoolean() + " jjCanMove_" + this.m_nonAsciiMethod + "(int hiByte, int i1, int i2, " + eOutputLanguage.getTypeLong() + " l1, " + eOutputLanguage.getTypeLong() + " l2)");
                break;
            }
            case CPP: {
                codeGenerator.generateMethodDefHeader(eOutputLanguage.getTypeBoolean(), LexGenJava.s_tokMgrClassName, "jjCanMove_" + this.m_nonAsciiMethod + "(int hiByte, int i1, int i2, " + eOutputLanguage.getTypeLong() + " l1, " + eOutputLanguage.getTypeLong() + " l2)");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        codeGenerator.genCodeLine("{");
        codeGenerator.genCodeLine("   switch(hiByte)");
        codeGenerator.genCodeLine("   {");
        if (this.m_loByteVec != null && this.m_loByteVec.size() > 0) {
            for (n = 0; n < this.m_loByteVec.size(); n += 2) {
                codeGenerator.genCodeLine("      case " + this.m_loByteVec.get(n) + ":");
                if (!NfaState.allBitsSet(s_allBitVectors.get(this.m_loByteVec.get(n + 1)))) {
                    codeGenerator.genCodeLine("         return ((jjbitVec" + this.m_loByteVec.get(n + 1) + "[i2] & l2) != 0L);");
                    continue;
                }
                codeGenerator.genCodeLine("            return true;");
            }
        }
        codeGenerator.genCodeLine("      default :");
        if (this.m_nonAsciiMoveIndices != null && (n = this.m_nonAsciiMoveIndices.length) > 0) {
            do {
                if (!NfaState.allBitsSet(s_allBitVectors.get(this.m_nonAsciiMoveIndices[n - 2]))) {
                    codeGenerator.genCodeLine("         if ((jjbitVec" + this.m_nonAsciiMoveIndices[n - 2] + "[i1] & l1) != 0L)");
                }
                if (!NfaState.allBitsSet(s_allBitVectors.get(this.m_nonAsciiMoveIndices[n - 1]))) {
                    codeGenerator.genCodeLine("            if ((jjbitVec" + this.m_nonAsciiMoveIndices[n - 1] + "[i2] & l2) == 0L)");
                    codeGenerator.genCodeLine("               return false;");
                    codeGenerator.genCodeLine("            else");
                }
                codeGenerator.genCodeLine("            return true;");
            } while ((n -= 2) > 0);
        }
        codeGenerator.genCodeLine("         return false;");
        codeGenerator.genCodeLine("   }");
        codeGenerator.genCodeLine("}");
    }

    private static void _reArrange() {
        List<NfaState> list = s_allStates;
        s_allStates = new ArrayList<Object>(Collections.nCopies(s_generatedStates, null));
        if (s_allStates.size() != s_generatedStates) {
            JavaCCErrors.internalError();
        }
        for (int i = 0; i < list.size(); ++i) {
            NfaState nfaState = list.get(i);
            if (nfaState.m_stateName == -1 || nfaState.m_dummy) continue;
            s_allStates.set(nfaState.m_stateName, nfaState);
        }
    }

    static void printBoilerPlateJava(CodeGenerator codeGenerator) {
        codeGenerator.genCodeLine("private void jjCheckNAdd(int state)");
        codeGenerator.genCodeLine("{");
        codeGenerator.genCodeLine("   if (jjrounds[state] != jjround)");
        codeGenerator.genCodeLine("   {");
        codeGenerator.genCodeLine("      jjstateSet[jjnewStateCnt++] = state;");
        codeGenerator.genCodeLine("      jjrounds[state] = jjround;");
        codeGenerator.genCodeLine("   }");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine("private void jjAddStates(int start, int end)");
        codeGenerator.genCodeLine("{");
        codeGenerator.genCodeLine("   do {");
        codeGenerator.genCodeLine("      jjstateSet[jjnewStateCnt++] = jjnextStates[start];");
        codeGenerator.genCodeLine("   } while (start++ != end);");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine("private void jjCheckNAddTwoStates(int state1, int state2)");
        codeGenerator.genCodeLine("{");
        codeGenerator.genCodeLine("   jjCheckNAdd(state1);");
        codeGenerator.genCodeLine("   jjCheckNAdd(state2);");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeNewLine();
        if (s_jjCheckNAddStatesDualNeeded) {
            codeGenerator.genCodeLine("private void jjCheckNAddStates(int start, int end)");
            codeGenerator.genCodeLine("{");
            codeGenerator.genCodeLine("   do {");
            codeGenerator.genCodeLine("      jjCheckNAdd(jjnextStates[start]);");
            codeGenerator.genCodeLine("   } while (start++ != end);");
            codeGenerator.genCodeLine("}");
            codeGenerator.genCodeNewLine();
        }
        if (s_jjCheckNAddStatesUnaryNeeded) {
            codeGenerator.genCodeLine("private void jjCheckNAddStates(int start)");
            codeGenerator.genCodeLine("{");
            codeGenerator.genCodeLine("   jjCheckNAdd(jjnextStates[start]);");
            codeGenerator.genCodeLine("   jjCheckNAdd(jjnextStates[start + 1]);");
            codeGenerator.genCodeLine("}");
            codeGenerator.genCodeNewLine();
        }
    }

    static void printBoilerPlateCPP(CodeGenerator codeGenerator) {
        codeGenerator.switchToIncludeFile();
        codeGenerator.genCodeLine("#define jjCheckNAdd(state)\\");
        codeGenerator.genCodeLine("{\\");
        codeGenerator.genCodeLine("   if (jjrounds[state] != jjround)\\");
        codeGenerator.genCodeLine("   {\\");
        codeGenerator.genCodeLine("      jjstateSet[jjnewStateCnt++] = state;\\");
        codeGenerator.genCodeLine("      jjrounds[state] = jjround;\\");
        codeGenerator.genCodeLine("   }\\");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine("#define jjAddStates(start, end)\\");
        codeGenerator.genCodeLine("{\\");
        codeGenerator.genCodeLine("   for (int x = start; x <= end; x++) {\\");
        codeGenerator.genCodeLine("      jjstateSet[jjnewStateCnt++] = jjnextStates[x];\\");
        codeGenerator.genCodeLine("   } /*while (start++ != end);*/\\");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeLine("#define jjCheckNAddTwoStates(state1, state2)\\");
        codeGenerator.genCodeLine("{\\");
        codeGenerator.genCodeLine("   jjCheckNAdd(state1);\\");
        codeGenerator.genCodeLine("   jjCheckNAdd(state2);\\");
        codeGenerator.genCodeLine("}");
        codeGenerator.genCodeNewLine();
        if (s_jjCheckNAddStatesDualNeeded) {
            codeGenerator.genCodeLine("#define jjCheckNAddStates(start, end)\\");
            codeGenerator.genCodeLine("{\\");
            codeGenerator.genCodeLine("   for (int x = start; x <= end; x++) {\\");
            codeGenerator.genCodeLine("      jjCheckNAdd(jjnextStates[x]);\\");
            codeGenerator.genCodeLine("   } /*while (start++ != end);*/\\");
            codeGenerator.genCodeLine("}");
            codeGenerator.genCodeNewLine();
        }
        if (s_jjCheckNAddStatesUnaryNeeded) {
            codeGenerator.genCodeLine("#define jjCheckNAddStates(start)\\");
            codeGenerator.genCodeLine("{\\");
            codeGenerator.genCodeLine("   jjCheckNAdd(jjnextStates[start]);\\");
            codeGenerator.genCodeLine("   jjCheckNAdd(jjnextStates[start + 1]);\\");
            codeGenerator.genCodeLine("}");
            codeGenerator.genCodeNewLine();
        }
        codeGenerator.switchToMainFile();
    }

    private static void _findStatesWithNoBreak() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean[] blArray = new boolean[s_generatedStates];
        int n = 0;
        int n2 = 0;
        block0: for (int i = 0; i < s_allStates.size(); ++i) {
            NfaState nfaState;
            int n3;
            String string;
            NfaState nfaState2 = null;
            NfaState nfaState3 = s_allStates.get(i);
            if (nfaState3.m_stateName == -1 || nfaState3.m_dummy || !nfaState3._isUsefulState() || nfaState3.m_next == null || nfaState3.m_next.m_usefulEpsilonMoves < 1 || s_compositeStateTable.get(string = nfaState3.m_next.m_epsilonMovesString) != null || hashMap.get(string) != null) continue;
            hashMap.put(string, string);
            int[] nArray = s_allNextStates.get(string);
            if (nArray.length == 1) continue;
            int n4 = n;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n4 = nArray[n3];
                if (n4 == -1) continue;
                nfaState = s_allStates.get(n4);
                if (nfaState.m_isComposite || nfaState.m_inNextOf != 1) continue;
                if (blArray[n4]) {
                    JavaCCErrors.internalError();
                }
                n2 = n3;
                ++n;
                nfaState2 = nfaState;
                blArray[n4] = true;
                break;
            }
            if (nfaState2 == null) continue;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n4 = nArray[n3];
                if (n4 == -1) continue;
                nfaState = s_allStates.get(n4);
                if (blArray[n4] || nfaState.m_inNextOf <= 1 || nfaState.m_isComposite || nfaState.m_stateForCase != null) continue;
                ++n;
                nArray[n3] = -1;
                blArray[n4] = true;
                int n5 = nArray[0];
                nArray[0] = nArray[n2];
                nArray[n2] = n5;
                nfaState.m_stateForCase = nfaState2;
                nfaState2.m_stateForCase = nfaState;
                s_stateSetsToFix.put(string, nArray);
                continue block0;
            }
            for (int n6 : nArray) {
                n4 = n6;
                if (n4 == -1) continue;
                NfaState nfaState4 = s_allStates.get(n4);
                if (nfaState4.m_inNextOf > 1) continue;
                blArray[n4] = false;
            }
        }
    }

    public static void dumpMoveNfa(CodeGenerator codeGenerator) {
        int[] nArray = null;
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        if (s_kinds == null) {
            s_kinds = new int[LexGenJava.s_maxLexStates][];
            s_statesForState = new int[LexGenJava.s_maxLexStates][][];
        }
        NfaState._reArrange();
        for (int i = 0; i < s_allStates.size(); ++i) {
            NfaState object = s_allStates.get(i);
            if (object.m_lexState != LexGenJava.s_lexStateIndex || !object.hasTransitions() || object.m_dummy || object.m_stateName == -1) continue;
            if (nArray == null) {
                nArray = new int[s_generatedStates];
                NfaState.s_statesForState[LexGenJava.s_lexStateIndex] = new int[Math.max(s_generatedStates, s_dummyStateIndex + 1)][];
            }
            nArray[object.m_stateName] = object.m_lookingFor;
            NfaState.s_statesForState[LexGenJava.s_lexStateIndex][object.m_stateName] = object.m_compositeStates;
            object._generateNonAsciiMoves(codeGenerator);
        }
        for (Map.Entry<String, Integer> entry : s_stateNameForComposite.entrySet()) {
            String string = entry.getKey();
            int n = entry.getValue();
            if (n < s_generatedStates) continue;
            NfaState.s_statesForState[LexGenJava.s_lexStateIndex][n] = s_allNextStates.get(string);
        }
        if (s_stateSetsToFix.size() != 0) {
            NfaState._fixStateSets();
        }
        NfaState.s_kinds[LexGenJava.s_lexStateIndex] = nArray;
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCodeLine("private int jjMoveNfa" + LexGenJava.s_lexStateSuffix + "(int startState, int curPos)");
                break;
            }
            case CPP: {
                codeGenerator.generateMethodDefHeader("int", LexGenJava.s_tokMgrClassName, "jjMoveNfa" + LexGenJava.s_lexStateSuffix + "(int startState, int curPos)");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        codeGenerator.genCodeLine("{");
        if (s_generatedStates == 0) {
            codeGenerator.genCodeLine("   return curPos;");
            codeGenerator.genCodeLine("}");
            return;
        }
        if (LexGenJava.s_mixed[LexGenJava.s_lexStateIndex]) {
            codeGenerator.genCodeLine("   int strKind = jjmatchedKind;");
            codeGenerator.genCodeLine("   int strPos = jjmatchedPos;");
            codeGenerator.genCodeLine("   int seenUpto;");
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("   input_stream.backup(seenUpto = curPos + 1);");
                    codeGenerator.genCodeLine("   try { curChar = input_stream.readChar(); }");
                    codeGenerator.genCodeLine("   catch(java.io.IOException e) { throw new Error(\"Internal Error\"); }");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("   input_stream->backup(seenUpto = curPos + 1);");
                    codeGenerator.genCodeLine("   assert(!input_stream->endOfInput());");
                    codeGenerator.genCodeLine("   curChar = input_stream->readChar();");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            codeGenerator.genCodeLine("   curPos = 0;");
        }
        codeGenerator.genCodeLine("   int startsAt = 0;");
        codeGenerator.genCodeLine("   jjnewStateCnt = " + s_generatedStates + ";");
        codeGenerator.genCodeLine("   int i = 1;");
        codeGenerator.genCodeLine("   jjstateSet[0] = startState;");
        if (Options.isDebugTokenManager()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("      debugStream.println(\"   Starting NFA to match one of : \" + jjKindsForStateVector(curLexState, jjstateSet, 0, 1));");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("      fprintf(debugStream, \"   Starting NFA to match one of : %s\\n\", jjKindsForStateVector(curLexState, jjstateSet, 0, 1).c_str());");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        if (Options.isDebugTokenManager()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("      debugStream.println(" + (LexGenJava.s_maxLexStates > 1 ? "\"<\" + lexStateNames[curLexState] + \">\" + " : "") + "\"Current character : \" + " + Options.getTokenMgrErrorClass() + ".addEscapes(String.valueOf(curChar)) + \" (\" + (int)curChar + \") at line \" + input_stream.getEndLine() + \" column \" + input_stream.getEndColumn());");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("   fprintf(debugStream, \"<%s>Current character : %c(%d) at line %d column %d\\n\",addUnicodeEscapes(lexStateNames[curLexState]).c_str(), curChar, (int)curChar, input_stream->getEndLine(), input_stream->getEndColumn());");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        codeGenerator.genCodeLine("   int kind = 0x" + Integer.toHexString(Integer.MAX_VALUE) + ";");
        codeGenerator.genCodeLine("   for (;;)");
        codeGenerator.genCodeLine("   {");
        codeGenerator.genCodeLine("      if (++jjround == 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
        codeGenerator.genCodeLine("         ReInitRounds();");
        codeGenerator.genCodeLine("      if (curChar < 64)");
        codeGenerator.genCodeLine("      {");
        NfaState._dumpAsciiMoves(codeGenerator, 0);
        codeGenerator.genCodeLine("      }");
        codeGenerator.genCodeLine("      else if (curChar < 128)");
        codeGenerator.genCodeLine("      {");
        NfaState._dumpAsciiMoves(codeGenerator, 1);
        codeGenerator.genCodeLine("      }");
        codeGenerator.genCodeLine("      else");
        codeGenerator.genCodeLine("      {");
        NfaState.dumpCharAndRangeMoves(codeGenerator);
        codeGenerator.genCodeLine("      }");
        codeGenerator.genCodeLine("      if (kind != 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
        codeGenerator.genCodeLine("      {");
        codeGenerator.genCodeLine("         jjmatchedKind = kind;");
        codeGenerator.genCodeLine("         jjmatchedPos = curPos;");
        codeGenerator.genCodeLine("         kind = 0x" + Integer.toHexString(Integer.MAX_VALUE) + ";");
        codeGenerator.genCodeLine("      }");
        codeGenerator.genCodeLine("      ++curPos;");
        if (Options.isDebugTokenManager()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("      if (jjmatchedKind != 0 && jjmatchedKind != 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
                    codeGenerator.genCodeLine("         debugStream.println(\"   Currently matched the first \" + (jjmatchedPos + 1) + \" characters as a \" + tokenImage[jjmatchedKind] + \" token.\");");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("      if (jjmatchedKind != 0 && jjmatchedKind != 0x" + Integer.toHexString(Integer.MAX_VALUE) + ")");
                    codeGenerator.genCodeLine("   fprintf(debugStream, \"   Currently matched the first %d characters as a \\\"%s\\\" token.\\n\",  (jjmatchedPos + 1),  addUnicodeEscapes(tokenImage[jjmatchedKind]).c_str());");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCodeLine("      i = jjnewStateCnt;");
                codeGenerator.genCodeLine("      jjnewStateCnt = startsAt;");
                codeGenerator.genCodeLine("      startsAt = " + s_generatedStates + " - jjnewStateCnt;");
                codeGenerator.genCodeLine("      if (i == startsAt)");
                break;
            }
            case CPP: {
                codeGenerator.genCodeLine("      if ((i = jjnewStateCnt), (jjnewStateCnt = startsAt), (i == (startsAt = " + s_generatedStates + " - startsAt)))");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        if (LexGenJava.s_mixed[LexGenJava.s_lexStateIndex]) {
            codeGenerator.genCodeLine("         break;");
        } else {
            codeGenerator.genCodeLine("         return curPos;");
        }
        if (Options.isDebugTokenManager()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("      debugStream.println(\"   Possible kinds of longer matches : \" + jjKindsForStateVector(curLexState, jjstateSet, startsAt, i));");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("      fprintf(debugStream, \"   Possible kinds of longer matches : %s\\n\", jjKindsForStateVector(curLexState, jjstateSet, startsAt, i).c_str());");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCodeLine("      try { curChar = input_stream.readChar(); }");
                if (LexGenJava.s_mixed[LexGenJava.s_lexStateIndex]) {
                    codeGenerator.genCodeLine("      catch(java.io.IOException e) { break; }");
                    break;
                }
                codeGenerator.genCodeLine("      catch(java.io.IOException e) { return curPos; }");
                break;
            }
            case CPP: {
                if (LexGenJava.s_mixed[LexGenJava.s_lexStateIndex]) {
                    codeGenerator.genCodeLine("      if (input_stream->endOfInput()) { break; }");
                } else {
                    codeGenerator.genCodeLine("      if (input_stream->endOfInput()) { return curPos; }");
                }
                codeGenerator.genCodeLine("      curChar = input_stream->readChar();");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        if (Options.isDebugTokenManager()) {
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("      debugStream.println(" + (LexGenJava.s_maxLexStates > 1 ? "\"<\" + lexStateNames[curLexState] + \">\" + " : "") + "\"Current character : \" + " + Options.getTokenMgrErrorClass() + ".addEscapes(String.valueOf(curChar)) + \" (\" + (int)curChar + \") at line \" + input_stream.getEndLine() + \" column \" + input_stream.getEndColumn());");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("   fprintf(debugStream, \"<%s>Current character : %c(%d) at line %d column %d\\n\",addUnicodeEscapes(lexStateNames[curLexState]).c_str(), curChar, (int)curChar, input_stream->getEndLine(), input_stream->getEndColumn());");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
        }
        codeGenerator.genCodeLine("   }");
        if (LexGenJava.s_mixed[LexGenJava.s_lexStateIndex]) {
            codeGenerator.genCodeLine("   if (jjmatchedPos > strPos)");
            codeGenerator.genCodeLine("      return curPos;");
            codeGenerator.genCodeNewLine();
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("   int toRet = Math.max(curPos, seenUpto);");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("   int toRet = MAX(curPos, seenUpto);");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            codeGenerator.genCodeNewLine();
            codeGenerator.genCodeLine("   if (curPos < toRet)");
            switch (eOutputLanguage) {
                case JAVA: {
                    codeGenerator.genCodeLine("      for (i = toRet - Math.min(curPos, seenUpto); i-- > 0; )");
                    codeGenerator.genCodeLine("         try { curChar = input_stream.readChar(); }");
                    codeGenerator.genCodeLine("         catch(java.io.IOException e) { throw new Error(\"Internal Error : Please send a bug report.\"); }");
                    break;
                }
                case CPP: {
                    codeGenerator.genCodeLine("      for (i = toRet - MIN(curPos, seenUpto); i-- > 0; )");
                    codeGenerator.genCodeLine("        {  assert(!input_stream->endOfInput());");
                    codeGenerator.genCodeLine("           curChar = input_stream->readChar(); }");
                    break;
                }
                default: {
                    throw new UnsupportedOutputLanguageException(eOutputLanguage);
                }
            }
            codeGenerator.genCodeNewLine();
            codeGenerator.genCodeLine("   if (jjmatchedPos < strPos)");
            codeGenerator.genCodeLine("   {");
            codeGenerator.genCodeLine("      jjmatchedKind = strKind;");
            codeGenerator.genCodeLine("      jjmatchedPos = strPos;");
            codeGenerator.genCodeLine("   }");
            codeGenerator.genCodeLine("   else if (jjmatchedPos == strPos && jjmatchedKind > strKind)");
            codeGenerator.genCodeLine("      jjmatchedKind = strKind;");
            codeGenerator.genCodeNewLine();
            codeGenerator.genCodeLine("   return toRet;");
        }
        codeGenerator.genCodeLine("}");
        s_allStates.clear();
    }

    public static void dumpStatesForStateCPP(CodeGenerator codeGenerator) {
        int n;
        int n2;
        if (s_statesForState == null) {
            assert (false) : "This should never be null.";
            codeGenerator.genCodeLine("null;");
            return;
        }
        codeGenerator.switchToStaticsFile();
        for (n2 = 0; n2 < LexGenJava.s_maxLexStates; ++n2) {
            if (s_statesForState[n2] == null) continue;
            for (n = 0; n < s_statesForState[n2].length; ++n) {
                int[] nArray = s_statesForState[n2][n];
                codeGenerator.genCode("const int stateSet_" + n2 + "_" + n + "[" + LexGenJava.s_stateSetSize + "] = ");
                if (nArray == null) {
                    codeGenerator.genCodeLine("   { " + n + " };");
                    continue;
                }
                codeGenerator.genCode("   { ");
                for (int n3 : nArray) {
                    codeGenerator.genCode(n3 + ", ");
                }
                codeGenerator.genCodeLine("};");
            }
        }
        for (n2 = 0; n2 < LexGenJava.s_maxLexStates; ++n2) {
            codeGenerator.genCodeLine("const int *stateSet_" + n2 + "[] = {");
            if (s_statesForState[n2] == null) {
                codeGenerator.genCodeLine(" NULL, ");
                codeGenerator.genCodeLine("};");
                continue;
            }
            for (n = 0; n < s_statesForState[n2].length; ++n) {
                codeGenerator.genCode("stateSet_" + n2 + "_" + n + ",");
            }
            codeGenerator.genCodeLine("};");
        }
        codeGenerator.genCode("const int** statesForState[] = { ");
        for (n2 = 0; n2 < LexGenJava.s_maxLexStates; ++n2) {
            codeGenerator.genCodeLine("stateSet_" + n2 + ", ");
        }
        codeGenerator.genCodeLine("\n};");
        codeGenerator.switchToMainFile();
    }

    public static void dumpStatesForStateJava(CodeGenerator codeGenerator) {
        codeGenerator.genCodeLine("protected static final class States {");
        codeGenerator.genCode("  protected static final int[][][] statesForState = ");
        if (s_statesForState == null) {
            codeGenerator.genCodeLine("null;");
        } else {
            codeGenerator.genCodeLine("{");
            for (int i = 0; i < LexGenJava.s_maxLexStates; ++i) {
                if (s_statesForState[i] == null) {
                    codeGenerator.genCodeLine(" {},");
                    continue;
                }
                codeGenerator.genCodeLine(" {");
                for (int j = 0; j < s_statesForState[i].length; ++j) {
                    int[] nArray = s_statesForState[i][j];
                    if (nArray == null) {
                        codeGenerator.genCodeLine("   { " + j + " },");
                        continue;
                    }
                    codeGenerator.genCode("   { ");
                    for (int n : nArray) {
                        codeGenerator.genCode(n + ", ");
                    }
                    codeGenerator.genCodeLine("},");
                }
                codeGenerator.genCodeLine("},");
            }
            codeGenerator.genCodeLine("\n};");
        }
        codeGenerator.genCodeLine("}");
    }

    public static void dumpStatesForKind(CodeGenerator codeGenerator) {
        EOutputLanguage eOutputLanguage = codeGenerator.getOutputLanguage();
        switch (eOutputLanguage) {
            case JAVA: {
                NfaState.dumpStatesForStateJava(codeGenerator);
                break;
            }
            case CPP: {
                NfaState.dumpStatesForStateCPP(codeGenerator);
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        boolean bl = false;
        int n = 0;
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCodeLine("protected static final class Kinds {");
                codeGenerator.genCode("  protected static final int[][] kindForState = ");
                break;
            }
            case CPP: {
                codeGenerator.switchToStaticsFile();
                codeGenerator.genCode("static const int kindForState[" + LexGenJava.s_stateSetSize + "][" + LexGenJava.s_stateSetSize + "] = ");
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        if (s_kinds == null) {
            codeGenerator.genCodeLine("null;");
        } else {
            codeGenerator.genCodeLine("{");
            for (int[] nArray : s_kinds) {
                if (bl) {
                    codeGenerator.genCodeLine(",");
                }
                bl = true;
                if (nArray == null) {
                    codeGenerator.genCodeLine("{}");
                    continue;
                }
                n = 0;
                codeGenerator.genCode("{ ");
                for (int n2 : nArray) {
                    if (n % 15 == 0) {
                        codeGenerator.genCode("\n  ");
                    } else if (n > 1) {
                        codeGenerator.genCode(" ");
                    }
                    codeGenerator.genCode(n2 + ", ");
                }
                codeGenerator.genCode("}");
            }
            codeGenerator.genCodeLine("\n};");
        }
        switch (eOutputLanguage) {
            case JAVA: {
                codeGenerator.genCode("}");
                break;
            }
            case CPP: {
                break;
            }
            default: {
                throw new UnsupportedOutputLanguageException(eOutputLanguage);
            }
        }
        codeGenerator.switchToMainFile();
    }

    public static void reInit() {
        s_unicodeWarningGiven = false;
        s_generatedStates = 0;
        s_idCnt = 0;
        s_lohiByteCnt = 0;
        s_dummyStateIndex = -1;
        s_done = false;
        s_mark = null;
        s_stateDone = null;
        s_allStates.clear();
        s_indexedAllStates.clear();
        s_nonAsciiTableForMethod.clear();
        s_equivStatesTable.clear();
        s_allNextStates.clear();
        s_lohiByteTab.clear();
        s_stateNameForComposite.clear();
        s_compositeStateTable.clear();
        s_stateBlockTable.clear();
        s_stateSetsToFix.clear();
        s_allBitVectors.clear();
        s_tmpIndices = new int[512];
        s_allBits = "{\n   0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL\n};";
        s_tableToDump.clear();
        s_orderedStateSet.clear();
        s_lastIndex = 0;
        s_jjCheckNAddStatesUnaryNeeded = false;
        s_jjCheckNAddStatesDualNeeded = false;
        s_kinds = null;
        s_statesForState = null;
    }

    static void updateNfaData(int n, int n2, int n3, int n4) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<NfaState> arrayList = new ArrayList<NfaState>();
        NfaState nfaState = null;
        for (int i = 0; i < s_allStates.size(); ++i) {
            NfaState nfaState2 = s_allStates.get(i);
            if (nfaState2.m_stateName == -1 || hashSet.contains(nfaState2.m_stateName)) continue;
            hashSet.add(nfaState2.m_stateName);
            arrayList.add(nfaState2);
            if (nfaState2.m_stateName != n2) continue;
            nfaState = nfaState2;
        }
        s_initialStates.put(n3, nfaState);
        s_statesForLexicalState.put(n3, arrayList);
        s_nfaStateOffset.put(n3, n);
        if (n4 > 0) {
            s_matchAnyChar.put(n3, n4);
        } else {
            s_matchAnyChar.put(n3, Integer.MAX_VALUE);
        }
    }

    public static void buildTokenizerData(TokenizerData tokenizerData) {
        SequencedCollection<NfaState> sequencedCollection;
        ArrayList<NfaState> arrayList = new ArrayList<NfaState>();
        Object object = s_statesForLexicalState.keySet().iterator();
        while (object.hasNext()) {
            int n = object.next();
            int n2 = s_nfaStateOffset.get(n);
            sequencedCollection = s_statesForLexicalState.get(n);
            for (int i = 0; i < sequencedCollection.size(); ++i) {
                NfaState object2 = sequencedCollection.get(i);
                if (object2.m_stateName == -1) continue;
                sequencedCollection.get((int)i).m_stateName += n2;
            }
            arrayList.addAll(sequencedCollection);
        }
        NfaState[] nfaStateArray = new NfaState[arrayList.size()];
        for (NfaState nfaState : arrayList) {
            assert (nfaStateArray[nfaState.m_stateName] == null);
            nfaStateArray[nfaState.m_stateName] = nfaState;
            TreeSet<Character> treeSet = new TreeSet<Character>();
            for (int i = 0; i <= 65535; ++i) {
                if (!nfaState._canMoveUsingChar((char)i)) continue;
                treeSet.add(Character.valueOf((char)i));
            }
            sequencedCollection = new TreeSet();
            if (nfaState.m_next != null) {
                for (NfaState nfaState2 : nfaState.m_next.m_epsilonMoves) {
                    sequencedCollection.add((NfaState)((Object)Integer.valueOf(nfaState2.m_stateName)));
                }
            }
            TreeSet treeSet2 = new TreeSet();
            if (nfaState.m_isComposite) {
                for (int n : nfaState.m_compositeStates) {
                    treeSet2.add(n);
                }
            }
            tokenizerData.addNfaState(nfaState.m_stateName, (Set<Character>)treeSet, (Set<Integer>)((Object)sequencedCollection), treeSet2, nfaState.m_kindToPrint);
        }
        object = new HashMap();
        for (int n : s_initialStates.keySet()) {
            if (s_initialStates.get(n) == null) {
                object.put(n, -1);
                continue;
            }
            object.put(n, NfaState.s_initialStates.get((Object)Integer.valueOf((int)n)).m_stateName);
        }
        tokenizerData.setInitialStates((Map<Integer, Integer>)object);
        tokenizerData.setWildcardKind(s_matchAnyChar);
    }

    static NfaState getNfaState(int n) {
        if (n == -1) {
            return null;
        }
        for (NfaState nfaState : s_allStates) {
            if (nfaState.m_stateName != n) continue;
            return nfaState;
        }
        assert (false);
        return null;
    }

    static {
        s_dummyStateIndex = -1;
        s_allStates = new ArrayList<NfaState>();
        s_indexedAllStates = new ArrayList<NfaState>();
        s_nonAsciiTableForMethod = new ArrayList<NfaState>();
        s_equivStatesTable = new HashMap<String, NfaState>();
        s_allNextStates = new HashMap<String, int[]>();
        s_lohiByteTab = new HashMap<String, Integer>();
        s_stateNameForComposite = new HashMap<String, Integer>();
        s_compositeStateTable = new HashMap<String, int[]>();
        s_stateBlockTable = new HashMap<String, String>();
        s_stateSetsToFix = new HashMap<String, int[]>();
        s_jjCheckNAddStatesUnaryNeeded = false;
        s_jjCheckNAddStatesDualNeeded = false;
        s_allBitVectors = new ArrayList<String>();
        s_tmpIndices = new int[512];
        s_allBits = "{\n   0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL, 0xffffffffffffffffL\n};";
        s_tableToDump = new HashMap<String, int[]>();
        s_orderedStateSet = new ArrayList<int[]>();
        s_lastIndex = 0;
        s_initialStates = new HashMap<Integer, NfaState>();
        s_statesForLexicalState = new HashMap<Integer, List<NfaState>>();
        s_nfaStateOffset = new HashMap<Integer, Integer>();
        s_matchAnyChar = new HashMap<Integer, Integer>();
    }
}

