/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.db.ColDesc;
import org.beetl.sql.core.db.TableDesc;
import org.beetl.sql.core.kit.ThreadSafeCaseInsensitiveHashMap;

public class MetadataManager {
    private ConnectionSource ds = null;
    ThreadSafeCaseInsensitiveHashMap map = null;
    TableDesc NOT_EXIST = new TableDesc("$NOT_EXIST", "");
    SQLManager sm = null;
    String defaultSchema;
    String defalutCatalog;
    String dbType = null;
    boolean checkAuto = true;

    public MetadataManager(ConnectionSource ds, SQLManager sm) {
        this.ds = ds;
        this.sm = sm;
        this.dbType = sm.getDbStyle().getName();
        this.initDefaultSchema();
    }

    public ConnectionSource getDs() {
        return this.ds;
    }

    public void setDs(ConnectionSource ds) {
        this.ds = ds;
    }

    public boolean existTable(String tableName) {
        TableDesc t = this.getTable(tableName);
        return t != null;
    }

    public TableDesc getTable(String name) {
        TableDesc table = this.getTableFromMap(name);
        if (table == null) {
            throw new BeetlSQLException(8, "table \"" + name + "\" not exist");
        }
        if (table.getCols().size() == 0) {
            table = this.initTable(table);
        }
        return table;
    }

    public Set<String> allTable() {
        if (this.map == null) {
            this.initMetadata();
        }
        return this.map.keySet();
    }

    public void refresh() {
        this.map = null;
        this.initMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableDesc getTableFromMap(String tableName) {
        TableDesc desc = null;
        if (this.map == null) {
            MetadataManager metadataManager = this;
            synchronized (metadataManager) {
                if (this.map != null) {
                    desc = (TableDesc)this.map.get(tableName);
                } else {
                    this.initMetadata();
                    desc = (TableDesc)this.map.get(tableName);
                }
            }
        } else {
            desc = (TableDesc)this.map.get(tableName);
        }
        if (desc == this.NOT_EXIST) {
            return null;
        }
        if (desc == null) {
            int index = tableName.indexOf(".");
            if (index != -1) {
                String schema = tableName.substring(0, index);
                String table = tableName.substring(index + 1);
                return this.initOtherSchemaTabel(schema, table);
            }
            return null;
        }
        return desc;
    }

    private TableDesc initTable(TableDesc desc) {
        TableDesc tableDesc = desc;
        synchronized (tableDesc) {
            TableDesc tableDesc2;
            if (desc.getCols().size() != 0) {
                return desc;
            }
            Connection conn = null;
            ResultSet rs = null;
            try {
                String catalog = desc.getCatalog();
                String schema = desc.getSchema();
                conn = this.ds.getMetaData();
                DatabaseMetaData dbmd = conn.getMetaData();
                rs = dbmd.getPrimaryKeys(catalog, schema, desc.getName());
                while (rs.next()) {
                    String idName = rs.getString("COLUMN_NAME");
                    desc.addIdName(idName);
                }
                rs.close();
                rs = dbmd.getColumns(catalog, schema, desc.getName(), "%");
                while (rs.next()) {
                    String colName = rs.getString("COLUMN_NAME");
                    Integer sqlType = rs.getInt("DATA_TYPE");
                    Integer size = rs.getInt("COLUMN_SIZE");
                    Object o = rs.getObject("DECIMAL_DIGITS");
                    Integer digit = null;
                    if (o != null) {
                        digit = ((Number)o).intValue();
                    }
                    String remark = rs.getString("REMARKS");
                    ColDesc col = new ColDesc(colName, sqlType, size, digit, remark);
                    try {
                        String auto;
                        if (this.checkAuto && (auto = rs.getString("IS_AUTOINCREMENT")).equals("YES")) {
                            col.isAuto = true;
                        }
                    }
                    catch (SQLException ex) {
                        this.checkAuto = false;
                    }
                    desc.addCols(col);
                }
                rs.close();
                tableDesc2 = desc;
                this.close(conn);
            }
            catch (SQLException e) {
                try {
                    throw new BeetlSQLException(1, e);
                }
                catch (Throwable throwable) {
                    this.close(conn);
                    throw throwable;
                }
            }
            return tableDesc2;
        }
    }

    private synchronized void initMetadata() {
        if (this.map != null) {
            return;
        }
        ThreadSafeCaseInsensitiveHashMap tempMap = new ThreadSafeCaseInsensitiveHashMap();
        Connection conn = null;
        try {
            conn = this.ds.getMetaData();
            DatabaseMetaData dbmd = conn.getMetaData();
            String catalog = this.defalutCatalog;
            String schema = this.defaultSchema;
            String namePattern = this.getTableNamePattern(dbmd);
            ResultSet rs = dbmd.getTables(catalog, schema, namePattern, new String[]{"TABLE", "VIEW"});
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                String remarks = rs.getString("REMARKS");
                TableDesc desc = new TableDesc(name, remarks);
                desc.setSchema(this.defaultSchema);
                desc.setCatalog(catalog);
                tempMap.put(desc.getName(), (Object)desc);
            }
            rs.close();
            this.map = tempMap;
        }
        catch (SQLException e) {
            throw new BeetlSQLException(1, e);
        }
        finally {
            this.close(conn);
        }
    }

    private TableDesc initOtherSchemaTabel(String sc, String table) {
        Connection conn = null;
        try {
            TableDesc tableDesc;
            conn = this.ds.getMetaData();
            DatabaseMetaData dbmd = conn.getMetaData();
            String catalog = this.getDbCatalog(sc);
            String schema = this.getDbSchema(sc);
            ResultSet rs = null;
            rs = dbmd.getTables(catalog, schema, this.getDbTableName(table), new String[]{"TABLE", "VIEW"});
            TableDesc desc = null;
            while (rs.next()) {
                String name = rs.getString("TABLE_NAME");
                String remarks = rs.getString("REMARKS");
                desc = new TableDesc(name, remarks);
                desc.setSchema(sc);
                desc.setCatalog(catalog);
                this.map.put(sc + "." + table, (Object)desc);
            }
            rs.close();
            if (desc != null) {
                tableDesc = desc;
                return tableDesc;
            }
            this.map.put(schema + "." + table, (Object)this.NOT_EXIST);
            tableDesc = null;
            return tableDesc;
        }
        catch (SQLException e) {
            throw new BeetlSQLException(1, e);
        }
        finally {
            this.close(conn);
        }
    }

    private void close(Connection conn) {
        try {
            if (!this.ds.isTransaction() && conn != null) {
                conn.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initDefaultSchema() {
        this.defaultSchema = this.sm.getDefaultSchema();
        if (this.defaultSchema == null) {
            Connection conn = this.ds.getMetaData();
            try {
                this.setDefaultSchema(conn);
                conn.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void setDefaultSchema(Connection conn) throws SQLException {
        try {
            this.defalutCatalog = conn.getCatalog();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.defaultSchema = conn.getSchema();
        }
        catch (Throwable e) {
            String dbName = this.sm.getDbStyle().getName();
            this.defaultSchema = dbName.equals("postgres") ? "public" : (dbName.equals("sqlserver") ? "dbo" : (dbName.equals("oracle") ? conn.getMetaData().getUserName() : null));
        }
    }

    private String getDbSchema(DatabaseMetaData dbmd, String namespace) {
        if (this.dbType.equals("mysql")) {
            return null;
        }
        if (this.dbType.equals("oracle")) {
            return namespace.toUpperCase();
        }
        return namespace;
    }

    private String getTableNamePattern(DatabaseMetaData meta) throws SQLException {
        int c;
        String p = meta.getDatabaseProductName();
        if (p.equalsIgnoreCase("mysql") && (c = meta.getDriverMajorVersion()) == 6) {
            return "%";
        }
        return null;
    }

    private String getDbSchema(String namespace) {
        if (this.dbType.equals("mysql")) {
            return null;
        }
        if (this.dbType.equals("oracle")) {
            return namespace.toUpperCase();
        }
        return namespace;
    }

    private String getDbCatalog(String schema) {
        if (this.dbType.equals("mysql")) {
            return schema;
        }
        return null;
    }

    private String getDbTableName(String name) {
        if (this.dbType.equals("oracle")) {
            return name.toUpperCase();
        }
        return name;
    }
}

