/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfACopy;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfSmartCopy;
import com.itextpdf.text.pdf.RefKey;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;

public class PdfASmartCopy
extends PdfACopy {
    private HashMap<PdfSmartCopy.ByteStore, PdfIndirectReference> streamMap = null;
    private final HashMap<RefKey, Integer> serialized = new HashMap();

    public PdfASmartCopy(Document document, OutputStream os, PdfAConformanceLevel conformanceLevel) throws DocumentException {
        super(document, os, conformanceLevel);
        this.streamMap = new HashMap();
    }

    protected PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        PdfObject type;
        PdfIndirectReference theRef;
        RefKey key;
        PdfCopy.IndirectReferences iRef;
        PdfIndirectReference streamRef;
        PdfObject srcObj = PdfReader.getPdfObjectRelease((PdfObject)in);
        PdfSmartCopy.ByteStore streamKey = null;
        boolean validStream = false;
        if (srcObj.isStream()) {
            streamKey = new PdfSmartCopy.ByteStore((PRStream)srcObj, this.serialized);
            validStream = true;
            streamRef = this.streamMap.get(streamKey);
            if (streamRef != null) {
                return streamRef;
            }
        } else if (srcObj.isDictionary()) {
            streamKey = new PdfSmartCopy.ByteStore((PdfDictionary)srcObj, this.serialized);
            validStream = true;
            streamRef = this.streamMap.get(streamKey);
            if (streamRef != null) {
                return streamRef;
            }
        }
        if ((iRef = (PdfCopy.IndirectReferences)this.indirects.get(key = new RefKey(in))) != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.body.getPdfIndirectReference();
            iRef = new PdfCopy.IndirectReferences(theRef);
            this.indirects.put(key, iRef);
        }
        if (srcObj.isDictionary() && (type = PdfReader.getPdfObjectRelease((PdfObject)((PdfDictionary)srcObj).get(PdfName.TYPE))) != null && PdfName.PAGE.equals((Object)type)) {
            return theRef;
        }
        iRef.setCopied();
        if (validStream) {
            this.streamMap.put(streamKey, theRef);
        }
        PdfObject obj = this.copyObject(srcObj);
        this.addToBody(obj, theRef);
        return theRef;
    }

    public void freeReader(PdfReader reader) throws IOException {
        this.serialized.clear();
        super.freeReader(reader);
    }

    public void addPage(PdfImportedPage iPage) throws IOException, BadPdfFormatException {
        if (this.currentPdfReaderInstance.getReader() != this.reader) {
            this.serialized.clear();
        }
        super.addPage(iPage);
    }
}

