/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLBuffer;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLDevice;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLKernel;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLPlatform;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.PlatformUtils;
import java.nio.ByteOrder;
import org.bridj.Pointer;

class ByteOrderHack {
    public static final boolean hackEnabled = "1".equals(System.getenv("JAVACL_GUESS_ENDIANNESS")) || "true".equals(System.getProperty("javacl.guessEndianness"));

    ByteOrderHack() {
    }

    public static ByteOrder guessByteOrderNeededForBuffers(CLDevice device) {
        CLPlatform platform = device.getPlatform();
        PlatformUtils.PlatformKind knownPlatform = PlatformUtils.guessPlatformKind(platform);
        if (!hackEnabled || knownPlatform != PlatformUtils.PlatformKind.AMDApp) {
            return device.getByteOrder();
        }
        return ByteOrderHack.checkByteOrderNeededForBuffers(device);
    }

    public static ByteOrder checkByteOrderNeededForBuffers(CLDevice device) {
        CLContext context = JavaCL.createContext(null, device);
        CLQueue queue = context.createDefaultQueue(new CLDevice.QueueProperties[0]);
        try {
            int otherIndex;
            ByteOrder otherOrder;
            int index;
            ByteOrder order;
            boolean littleOk;
            int n = 16;
            String testValueStr = "123456789f";
            float testValue = Float.parseFloat(testValueStr);
            boolean BIG_INDEX = false;
            boolean LITTLE_INDEX = true;
            Pointer inPtr = Pointer.allocateFloats((long)n);
            inPtr.order(ByteOrder.BIG_ENDIAN).set(0L, (Object)Float.valueOf(testValue));
            inPtr.order(ByteOrder.LITTLE_ENDIAN).set(1L, (Object)Float.valueOf(testValue));
            CLBuffer<Float> inOut = context.createFloatBuffer(CLMem.Usage.InputOutput, (Pointer<Float>)inPtr);
            CLBuffer<Integer> success = context.createIntBuffer(CLMem.Usage.Output, n);
            String src = "__kernel void compare_endiannesses(__global float *inout, __global int *success) {\nsize_t i = get_global_id(0);\nsuccess[i] = (inout[i] == " + testValueStr + ");\n" + "inout[i] = " + testValueStr + ";\n" + "}";
            CLKernel test = context.createProgram(src).createKernel("compare_endiannesses", new Object[0]);
            test.setArgs(inOut, success);
            test.enqueueNDRange(queue, new int[]{n}, new int[]{1}, new CLEvent[0]);
            Pointer successPtr = Pointer.allocateInts((long)n);
            success.read(queue, (Pointer<Integer>)successPtr, true, new CLEvent[0]);
            Pointer outPtr = Pointer.allocateFloats((long)n);
            inOut.read(queue, (Pointer<Float>)outPtr, true, new CLEvent[0]);
            boolean bigOk = (Integer)successPtr.get(0L) != 0;
            boolean bl = littleOk = (Integer)successPtr.get(1L) != 0;
            if (bigOk) {
                order = ByteOrder.BIG_ENDIAN;
                index = 0;
                otherOrder = ByteOrder.LITTLE_ENDIAN;
                otherIndex = 1;
            } else {
                order = ByteOrder.LITTLE_ENDIAN;
                index = 1;
                otherOrder = ByteOrder.BIG_ENDIAN;
                otherIndex = 0;
            }
            float value = ((Float)outPtr.order(order).get((long)index)).floatValue();
            float otherValue = ((Float)outPtr.order(otherOrder).get((long)otherIndex)).floatValue();
            if (JavaCL.debug) {
                System.out.println("[" + device + "] Endianness test: bigOk = " + bigOk + ", littleOk = " + littleOk + "; value = " + value + ", otherValue = " + otherValue);
            }
            if (!(bigOk ^ littleOk)) {
                throw new RuntimeException("[" + device + "] Endianness check failed, kernel recognized both endiannesses...");
            }
            if (value != testValue || otherValue == testValue) {
                throw new RuntimeException("[" + device + "] Endianness double-check failed, expected " + testValue + " and found " + value + " instead for endianness " + order + " (otherValue = " + otherValue + " for " + otherOrder + ")");
            }
            ByteOrder byteOrder = order;
            return byteOrder;
        }
        catch (Throwable ex) {
            throw new RuntimeException("[" + device + "] Endianness check failed: " + ex, ex);
        }
        finally {
            queue.release();
            context.release();
        }
    }
}

