/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLImageFormat;
import com.nativelibs4java.opencl.CLMem;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.InfoName;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.ReusablePointers;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.opencl.library.cl_image_format;
import com.nativelibs4java.util.Pair;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CLImage
extends CLMem {
    CLImageFormat format;

    CLImage(CLContext context, long entityPeer, CLImageFormat format) {
        super(context, -1L, entityPeer);
        this.format = format;
    }

    @InfoName(value="CL_IMAGE_FORMAT")
    public CLImageFormat getFormat() {
        if (this.format == null) {
            this.format = new CLImageFormat(new cl_image_format(infos.getMemory(this.getEntity(), 4368)));
        }
        return this.format;
    }

    @InfoName(value="CL_IMAGE_ELEMENT_SIZE")
    public long getElementSize() {
        return infos.getIntOrLong(this.getEntity(), 4369);
    }

    protected CLEvent read(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Buffer out, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.read(queue, origin, region, rowPitch, slicePitch, Pointer.pointerToBuffer((Buffer)out), blocking, eventsToWaitFor);
    }

    protected CLEvent read(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Pointer<?> out, boolean blocking, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = new int[1];
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<OpenCLLibrary.cl_event> eventOut = blocking || eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueReadImage(queue.getEntity(), this.getEntity(), blocking ? 1 : 0, Pointer.getPeer(origin), Pointer.getPeer(region), rowPitch, slicePitch, Pointer.getPeer(out), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }

    protected CLEvent write(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Buffer in, boolean blocking, CLEvent ... eventsToWaitFor) {
        return this.write(queue, origin, region, rowPitch, slicePitch, Pointer.pointerToBuffer((Buffer)in), blocking, eventsToWaitFor);
    }

    protected CLEvent write(CLQueue queue, Pointer<SizeT> origin, Pointer<SizeT> region, long rowPitch, long slicePitch, Pointer<?> in, boolean blocking, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = new int[1];
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<OpenCLLibrary.cl_event> eventOut = blocking || eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        CLException.error(JavaCL.CL.clEnqueueWriteImage(queue.getEntity(), this.getEntity(), blocking ? 1 : 0, Pointer.getPeer(origin), Pointer.getPeer(region), rowPitch, slicePitch, Pointer.getPeer(in), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        CLEvent evt = CLEvent.createEventFromPointer(queue, eventOut);
        if (!blocking) {
            final Pointer<?> toHold = in;
            evt.invokeUponCompletion(new Runnable(){

                public void run() {
                    toHold.order();
                }
            });
        }
        return evt;
    }

    protected Pair<ByteBuffer, CLEvent> map(CLQueue queue, CLMem.MapFlags flags, Pointer<SizeT> offset3, Pointer<SizeT> length3, Long imageRowPitch, Long imageSlicePitch, boolean blocking, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = new int[1];
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<OpenCLLibrary.cl_event> eventOut = blocking || eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        Pointer<Integer> pErr = ptrs.pErr;
        long mappedPeer = JavaCL.CL.clEnqueueMapImage(queue.getEntity(), this.getEntity(), blocking ? 1 : 0, flags.value(), Pointer.getPeer(offset3), Pointer.getPeer(length3), imageRowPitch == null ? 0L : Pointer.getPeer(ptrs.sizeT3_1.pointerToSizeTs(imageRowPitch)), imageSlicePitch == null ? 0L : Pointer.getPeer(ptrs.sizeT3_1.pointerToSizeTs(imageSlicePitch)), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut), Pointer.getPeer(pErr));
        CLException.error(pErr.getInt());
        return new Pair((Object)Pointer.pointerToAddress((long)mappedPeer).getByteBuffer(this.getByteCount()), (Object)CLEvent.createEventFromPointer(queue, eventOut));
    }

    public CLEvent unmap(CLQueue queue, ByteBuffer buffer, CLEvent ... eventsToWaitFor) {
        ReusablePointers ptrs = ReusablePointers.get();
        int[] eventsInCount = new int[1];
        Pointer eventsIn = CLAbstractEntity.copyNonNullEntities(eventsToWaitFor, eventsInCount, ptrs.events_in);
        Pointer<OpenCLLibrary.cl_event> eventOut = eventsToWaitFor == null || CLEvent.containsFireAndForget(eventsToWaitFor) ? null : ptrs.event_out;
        Pointer pBuffer = Pointer.pointerToBuffer((Buffer)buffer);
        CLException.error(JavaCL.CL.clEnqueueUnmapMemObject(queue.getEntity(), this.getEntity(), Pointer.getPeer((Pointer)pBuffer), eventsInCount[0], Pointer.getPeer(eventsIn), Pointer.getPeer(eventOut)));
        return CLEvent.createEventFromPointer(queue, eventOut);
    }
}

