/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import org.bridj.Pointer;
import org.bridj.SizeT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ReusablePointer {
    private final Pointer<?> pointer;
    private final long bytesCapacity;

    public ReusablePointer(long bytesCapacity) {
        this.bytesCapacity = bytesCapacity;
        this.pointer = Pointer.allocateBytes((long)bytesCapacity).withoutValidityInformation();
    }

    public Pointer<Integer> pointerToInts(int ... values) {
        if (values == null) {
            return null;
        }
        long needed = 4 * values.length;
        if (needed > this.bytesCapacity) {
            return Pointer.pointerToInts((int[])values);
        }
        return this.pointer.setInts(values);
    }

    public Pointer<SizeT> pointerToSizeTs(long ... values) {
        if (values == null) {
            return null;
        }
        long needed = SizeT.SIZE * values.length;
        if (needed > this.bytesCapacity) {
            return Pointer.pointerToSizeTs((long[])values);
        }
        return this.pointer.setSizeTs(values);
    }

    public Pointer<SizeT> pointerToSizeTs(int ... values) {
        if (values == null) {
            return null;
        }
        long needed = SizeT.SIZE * values.length;
        if (needed > this.bytesCapacity) {
            return Pointer.pointerToSizeTs((int[])values);
        }
        return this.pointer.setSizeTs(values);
    }

    public <T> Pointer<T> allocatedBytes(int needed) {
        if (needed == 0) {
            return null;
        }
        if ((long)needed > this.bytesCapacity) {
            return Pointer.allocateBytes((long)needed);
        }
        return this.pointer;
    }
}

