/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.library.cl_image_format;
import com.nativelibs4java.util.EnumValues;
import com.nativelibs4java.util.ValuedEnum;

public class CLImageFormat {
    private final ChannelOrder channelOrder;
    private final ChannelDataType channelDataType;
    static CLImageFormat INT_ARGB_FORMAT = new CLImageFormat(ChannelOrder.BGRA, ChannelDataType.UNormInt8);

    CLImageFormat(cl_image_format fmt) {
        this(ChannelOrder.getEnum(fmt.image_channel_order()), ChannelDataType.getEnum(fmt.image_channel_data_type()));
    }

    cl_image_format to_cl_image_format() {
        return new cl_image_format().image_channel_order((int)this.channelOrder.value()).image_channel_data_type((int)this.channelDataType.value());
    }

    public CLImageFormat(ChannelOrder channelOrder, ChannelDataType channelDataType) {
        this.channelDataType = channelDataType;
        this.channelOrder = channelOrder;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CLImageFormat)) {
            return false;
        }
        CLImageFormat f = (CLImageFormat)obj;
        if (this.channelOrder == null ? f.channelOrder != null : !this.channelOrder.equals(f.channelOrder)) {
            return false;
        }
        if (this.channelDataType == null) {
            return f.channelDataType == null;
        }
        return this.channelDataType.equals(f.channelDataType);
    }

    public int hashCode() {
        int h = super.hashCode();
        if (this.channelOrder != null) {
            h ^= this.channelOrder.hashCode();
        }
        if (this.channelDataType != null) {
            h ^= this.channelDataType.hashCode();
        }
        return h;
    }

    public boolean isIntBased() {
        if (this.channelDataType == null || this.channelOrder == null) {
            return false;
        }
        switch (this.getChannelOrder()) {
            case ARGB: 
            case BGRA: 
            case RGBA: {
                switch (this.getChannelDataType()) {
                    case SNormInt8: 
                    case SignedInt8: 
                    case UNormInt8: 
                    case UnsignedInt8: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public final ChannelOrder getChannelOrder() {
        return this.channelOrder;
    }

    public final ChannelDataType getChannelDataType() {
        return this.channelDataType;
    }

    public String toString() {
        return "(" + this.channelOrder + ", " + this.channelDataType + ")";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChannelDataType implements ValuedEnum
    {
        SNormInt8(4304L, 8),
        SNormInt16(4305L, 16),
        UNormInt8(4306L, 8),
        UNormInt16(4307L, 16),
        UNormShort565(4308L, 16),
        UNormShort555(4309L, 15),
        UNormInt101010(4310L, 30),
        SignedInt8(4311L, 8),
        SignedInt16(4312L, 16),
        SignedInt32(4313L, 32),
        UnsignedInt8(4314L, 8),
        UnsignedInt16(4315L, 16),
        UnsignedInt32(4316L, 32),
        HalfFloat(4317L, 16),
        Float(4318L, 32);

        public final int SIZE;
        long value;

        private ChannelDataType(long value, int bits) {
            this.SIZE = bits;
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static ChannelDataType getEnum(long v) {
            return EnumValues.getEnum(v, ChannelDataType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChannelOrder implements ValuedEnum
    {
        R(4272L),
        Rx(4282L),
        A(4273L),
        INTENSITY(4280L),
        LUMINANCE(4281L),
        RG(4274L),
        RGx(4283L),
        RA(4275L),
        RGB(4276L),
        RGBx(4284L),
        RGBA(4277L),
        ARGB(4279L),
        BGRA(4278L);

        long value;

        private ChannelOrder(long value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static ChannelOrder getEnum(long v) {
            return EnumValues.getEnum(v, ChannelOrder.class);
        }
    }
}

