/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nepxion.discovery.common.entity.DiscoveryEntity;
import com.nepxion.discovery.common.entity.RouterEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.entity.WeightEntityWrapper;
import com.nepxion.discovery.common.entity.WeightFilterEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.common.util.UrlUtil;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(path={"/router"})
@Api(tags={"\u8def\u7531\u63a5\u53e3"})
public class RouterEndpoint {
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private DiscoveryClient discoveryClient;
    private RestTemplate routerRestTemplate = new RestTemplate();

    @RequestMapping(path={"/services"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u670d\u52a1\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public List<String> services() {
        return this.getServices();
    }

    @RequestMapping(path={"/instances/{serviceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u672c\u5730\u8282\u70b9\u53ef\u8bbf\u95ee\u5176\u4ed6\u8282\u70b9\uff08\u6839\u636e\u670d\u52a1\u540d\uff09\u7684\u5b9e\u4f8b\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public List<ServiceInstance> instances(@PathVariable(value="serviceId") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u540d", required=true) String serviceId) {
        return this.getInstanceList(serviceId);
    }

    @RequestMapping(path={"/info"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u672c\u5730\u8282\u70b9\u4fe1\u606f", notes="\u83b7\u53d6\u5f53\u524d\u8282\u70b9\u7684\u7b80\u5355\u4fe1\u606f", response=RouterEntity.class, httpMethod="GET")
    @ResponseBody
    public RouterEntity info() {
        return this.getRouterEntity();
    }

    @RequestMapping(path={"/route/{routeServiceId}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u672c\u5730\u8282\u70b9\u53ef\u8bbf\u95ee\u5176\u4ed6\u8282\u70b9\uff08\u6839\u636e\u670d\u52a1\u540d\uff09\u7684\u8def\u7531\u4fe1\u606f\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public List<RouterEntity> route(@PathVariable(value="routeServiceId") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u540d", required=true) String routeServiceId) {
        return this.getRouterEntityList(routeServiceId);
    }

    @RequestMapping(path={"/route/{routeServiceId}/{routeHost}/{routePort}/{routeContextPath}"}, method={RequestMethod.GET})
    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u8282\u70b9\uff08\u6839\u636eIP\u5730\u5740\u548c\u7aef\u53e3\uff09\u53ef\u8bbf\u95ee\u5176\u4ed6\u8282\u70b9\uff08\u6839\u636e\u670d\u52a1\u540d\uff09\u7684\u8def\u7531\u4fe1\u606f\u5217\u8868", notes="", response=List.class, httpMethod="GET")
    @ResponseBody
    public List<RouterEntity> route(@PathVariable(value="routeServiceId") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u540d", required=true) String routeServiceId, @PathVariable(value="routeHost") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u6240\u5728\u673a\u5668\u7684IP\u5730\u5740", required=true) String routeHost, @PathVariable(value="routePort") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u6240\u5728\u673a\u5668\u7684\u7aef\u53e3\u53f7", required=true) int routePort, @PathVariable(value="routeContextPath") @ApiParam(value="\u76ee\u6807\u670d\u52a1\u7684\u8c03\u7528\u8def\u5f84\u524d\u7f00", required=true, defaultValue="/") String routeContextPath) {
        return this.getRouterEntityList(routeServiceId, routeHost, routePort, routeContextPath);
    }

    @RequestMapping(path={"/routes"}, method={RequestMethod.POST})
    @ApiOperation(value="\u83b7\u53d6\u5168\u8def\u5f84\u7684\u8def\u7531\u4fe1\u606f\u6811", notes="\u53c2\u6570\u6309\u8c03\u7528\u670d\u52a1\u540d\u7684\u524d\u540e\u6b21\u5e8f\u6392\u5217\uff0c\u8d77\u59cb\u8282\u70b9\u7684\u670d\u52a1\u540d\u4e0d\u80fd\u52a0\u4e0a\u53bb\u3002\u5982\u679c\u591a\u4e2a\u7528\u201c;\u201d\u5206\u9694\uff0c\u4e0d\u5141\u8bb8\u51fa\u73b0\u7a7a\u683c", response=RouterEntity.class, httpMethod="POST")
    @ResponseBody
    public RouterEntity routes(@RequestBody @ApiParam(value="\u4f8b\u5982\uff1aservice-a;service-b", required=true) String routeServiceIds) {
        return this.routeTree(routeServiceIds);
    }

    public List<String> getServices() {
        return this.discoveryClient.getServices();
    }

    public List<ServiceInstance> getInstanceList(String serviceId) {
        return this.discoveryClient.getInstances(serviceId);
    }

    public RouterEntity getRouterEntity() {
        String serviceType = this.pluginAdapter.getServiceType();
        String serviceId = this.pluginAdapter.getServiceId();
        String version = this.pluginAdapter.getVersion();
        String region = this.pluginAdapter.getRegion();
        String environment = this.pluginAdapter.getEnvironment();
        String zone = this.pluginAdapter.getZone();
        String host = this.pluginAdapter.getHost();
        int port = this.pluginAdapter.getPort();
        int weight = -1;
        String contextPath = this.pluginAdapter.getContextPath();
        RouterEntity routerEntity = new RouterEntity();
        routerEntity.setServiceType(serviceType);
        routerEntity.setServiceId(serviceId);
        routerEntity.setVersion(version);
        routerEntity.setRegion(region);
        routerEntity.setEnvironment(environment);
        routerEntity.setZone(zone);
        routerEntity.setHost(host);
        routerEntity.setPort(port);
        routerEntity.setWeight(weight);
        routerEntity.setContextPath(contextPath);
        return routerEntity;
    }

    public List<RouterEntity> getRouterEntityList(String routeServiceId) {
        List<ServiceInstance> instanceList = null;
        try {
            instanceList = this.getInstanceList(routeServiceId);
        }
        catch (Exception e) {
            throw new DiscoveryException("Get instance list for route serviceId=" + routeServiceId + " failed", (Throwable)e);
        }
        if (CollectionUtils.isEmpty(instanceList)) {
            return null;
        }
        ArrayList<RouterEntity> routerEntityList = new ArrayList<RouterEntity>();
        for (ServiceInstance instance : instanceList) {
            String serviceId = this.pluginAdapter.getInstanceServiceId(instance);
            String serviceType = this.pluginAdapter.getInstanceServiceType(instance);
            String version = this.pluginAdapter.getInstanceVersion(instance);
            String region = this.pluginAdapter.getInstanceRegion(instance);
            String environment = this.pluginAdapter.getInstanceEnvironment(instance);
            String zone = this.pluginAdapter.getInstanceZone(instance);
            String host = instance.getHost();
            int port = instance.getPort();
            int weight = this.getWeight(routeServiceId, version, region);
            String contextPath = this.pluginAdapter.getInstanceContextPath(instance);
            RouterEntity routerEntity = new RouterEntity();
            routerEntity.setServiceType(serviceType);
            routerEntity.setServiceId(serviceId);
            routerEntity.setVersion(version);
            routerEntity.setRegion(region);
            routerEntity.setEnvironment(environment);
            routerEntity.setZone(zone);
            routerEntity.setHost(host);
            routerEntity.setPort(port);
            routerEntity.setWeight(weight);
            routerEntity.setContextPath(contextPath);
            routerEntityList.add(routerEntity);
        }
        return routerEntityList;
    }

    public List<RouterEntity> getRouterEntityList(String routeServiceId, String routeHost, int routePort, String routeContextPath) {
        String url = "http://" + routeHost + ":" + routePort + UrlUtil.formatContextPath((String)routeContextPath) + "router/route/" + routeServiceId;
        String result = null;
        try {
            result = (String)this.routerRestTemplate.getForEntity(url, String.class, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            throw new DiscoveryException("Failed to execute to route, serviceId=" + routeServiceId + ", url=" + url, (Throwable)e);
        }
        if (StringUtils.isEmpty((CharSequence)result)) {
            return null;
        }
        List routerEntityList = (List)JsonUtil.fromJson((String)result, (TypeReference)new TypeReference<List<RouterEntity>>(){});
        return routerEntityList;
    }

    public RouterEntity routeTree(String routeServiceIds) {
        if (StringUtils.isEmpty((CharSequence)routeServiceIds)) {
            throw new DiscoveryException("Route serviceIds is empty");
        }
        String[] serviceIdArray = null;
        try {
            serviceIdArray = StringUtils.split((String)routeServiceIds, (String)";");
        }
        catch (Exception e) {
            throw new DiscoveryException("Route serviceIds must be separated with ';'", (Throwable)e);
        }
        RouterEntity firstRouterEntity = this.getRouterEntity();
        HashMap<Integer, List<RouterEntity>> routerEntityMap = new HashMap<Integer, List<RouterEntity>>();
        int routerDepth = 0;
        for (String serviceId : serviceIdArray) {
            serviceId = serviceId.toLowerCase().trim();
            if (routerDepth == 0) {
                this.routeFirst(firstRouterEntity, serviceId);
                this.retrieveRouterEntityList(routerEntityMap, routerDepth).addAll(firstRouterEntity.getNexts());
            } else {
                List<RouterEntity> routerEntityList = this.retrieveRouterEntityList(routerEntityMap, routerDepth - 1);
                for (RouterEntity routerEntity : routerEntityList) {
                    String routeHost = routerEntity.getHost();
                    int routePort = routerEntity.getPort();
                    String routeContextPath = routerEntity.getContextPath();
                    this.route(routerEntity, serviceId, routeHost, routePort, routeContextPath);
                    this.retrieveRouterEntityList(routerEntityMap, routerDepth).addAll(routerEntity.getNexts());
                }
            }
            ++routerDepth;
        }
        return firstRouterEntity;
    }

    private void routeFirst(RouterEntity routerEntity, String routeServiceId) {
        List<RouterEntity> routerEntityList = this.getRouterEntityList(routeServiceId);
        if (CollectionUtils.isNotEmpty(routerEntityList)) {
            routerEntity.getNexts().addAll(routerEntityList);
        }
    }

    private void route(RouterEntity routerEntity, String routeServiceId, String routeHost, int routePort, String routeContextPath) {
        List<RouterEntity> routerEntityList = this.getRouterEntityList(routeServiceId, routeHost, routePort, routeContextPath);
        if (CollectionUtils.isNotEmpty(routerEntityList)) {
            routerEntity.getNexts().addAll(routerEntityList);
        }
    }

    private List<RouterEntity> retrieveRouterEntityList(HashMap<Integer, List<RouterEntity>> routerEntityMap, int routerDepth) {
        List<RouterEntity> routerEntityList = routerEntityMap.get(routerDepth);
        if (routerEntityList == null) {
            routerEntityList = new ArrayList<RouterEntity>();
            routerEntityMap.put(routerDepth, routerEntityList);
        }
        return routerEntityList;
    }

    private int getWeight(String providerServiceId, String providerVersion, String providerRegion) {
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity == null) {
            return -1;
        }
        DiscoveryEntity discoveryEntity = ruleEntity.getDiscoveryEntity();
        if (discoveryEntity == null) {
            return -1;
        }
        WeightFilterEntity weightFilterEntity = discoveryEntity.getWeightFilterEntity();
        if (weightFilterEntity == null || !weightFilterEntity.hasWeight()) {
            return -1;
        }
        String serviceId = this.pluginAdapter.getServiceId();
        return WeightEntityWrapper.getWeight((WeightFilterEntity)weightFilterEntity, (String)providerServiceId, (String)providerVersion, (String)providerRegion, (String)serviceId);
    }
}

