/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.generator;

import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class GroupGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(GroupGenerator.class);
    @Autowired
    private ApplicationContext applicationContext;
    private Integer generatorLength;
    private String generatorCharacter;
    private String applicationName;
    private String group;

    @PostConstruct
    public void initialize() {
        this.generatorLength = PluginContextAware.getGroupGeneratorLength(this.applicationContext.getEnvironment());
        this.generatorCharacter = PluginContextAware.getGroupGeneratorCharacter(this.applicationContext.getEnvironment());
        this.applicationName = PluginContextAware.getApplicationName(this.applicationContext.getEnvironment());
        int characterIndex = this.applicationName.indexOf(this.generatorCharacter);
        if (this.generatorLength > 0) {
            this.group = this.applicationName.substring(0, this.generatorLength);
        } else if (StringUtils.isNotEmpty((CharSequence)this.generatorCharacter) && characterIndex > 0) {
            this.group = this.applicationName.substring(0, characterIndex);
        }
        LOG.info("--------------------------------------------------");
        if (StringUtils.isNotEmpty((CharSequence)this.group)) {
            LOG.info("Use application name prefix={} as metadata group", (Object)this.group);
        } else {
            LOG.error("Not substring application name prefix for generator length={} or character={}, use default metadata group setting", (Object)this.generatorLength, (Object)this.generatorCharacter);
        }
        LOG.info("--------------------------------------------------");
    }

    public Integer getGeneratorLength() {
        return this.generatorLength;
    }

    public String getGeneratorCharacter() {
        return this.generatorCharacter;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getGroup() {
        return this.group;
    }
}

