/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.context;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextHolder;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyMonitorContext;
import com.nepxion.discovery.plugin.strategy.wrapper.StrategyWrapper;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractStrategyContextHolder
implements PluginContextHolder,
StrategyContextHolder {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyWrapper strategyWrapper;
    @Autowired(required=false)
    protected StrategyMonitorContext strategyMonitorContext;

    public String getContext(String name) {
        return this.getHeader(name);
    }

    public String getContextRouteVersion() {
        String versionValue = this.getContext("n-d-version");
        if (StringUtils.isEmpty((CharSequence)versionValue)) {
            versionValue = this.getRouteVersion();
        }
        return versionValue;
    }

    public String getContextRouteRegion() {
        String regionValue = this.getContext("n-d-region");
        if (StringUtils.isEmpty((CharSequence)regionValue)) {
            regionValue = this.getRouteRegion();
        }
        return regionValue;
    }

    public String getContextRouteEnvironment() {
        String environmentValue = this.getContext("n-d-env");
        if (StringUtils.isEmpty((CharSequence)environmentValue)) {
            environmentValue = this.getRouteEnvironment();
        }
        return environmentValue;
    }

    public String getContextRouteAddress() {
        String addressValue = this.getContext("n-d-address");
        if (StringUtils.isEmpty((CharSequence)addressValue)) {
            addressValue = this.getRouteAddress();
        }
        return addressValue;
    }

    public String getContextRouteVersionWeight() {
        String versionWeightValue = this.getContext("n-d-version-weight");
        if (StringUtils.isEmpty((CharSequence)versionWeightValue)) {
            versionWeightValue = this.getRouteVersionWeight();
        }
        return versionWeightValue;
    }

    public String getContextRouteRegionWeight() {
        String regionWeightValue = this.getContext("n-d-region-weight");
        if (StringUtils.isEmpty((CharSequence)regionWeightValue)) {
            regionWeightValue = this.getRouteRegionWeight();
        }
        return regionWeightValue;
    }

    public String getContextRouteIdBlacklist() {
        String idBlacklistValue = this.getContext("n-d-id-blacklist");
        if (StringUtils.isEmpty((CharSequence)idBlacklistValue)) {
            idBlacklistValue = this.getRouteIdBlacklist();
        }
        return idBlacklistValue;
    }

    public String getContextRouteAddressBlacklist() {
        String addressBlacklistValue = this.getContext("n-d-address-blacklist");
        if (StringUtils.isEmpty((CharSequence)addressBlacklistValue)) {
            addressBlacklistValue = this.getRouteAddressBlacklist();
        }
        return addressBlacklistValue;
    }

    @Override
    public String getRouteVersion() {
        boolean isInnerConditionHeaderForced = this.isInnerConditionHeaderForced();
        if (isInnerConditionHeaderForced) {
            Map<String, String> headerMap = this.strategyWrapper.getHeaderMap();
            return this.strategyWrapper.getRouteVersion(headerMap);
        }
        return this.strategyWrapper.getRouteVersion();
    }

    @Override
    public String getRouteRegion() {
        boolean isInnerConditionHeaderForced = this.isInnerConditionHeaderForced();
        if (isInnerConditionHeaderForced) {
            Map<String, String> headerMap = this.strategyWrapper.getHeaderMap();
            return this.strategyWrapper.getRouteRegion(headerMap);
        }
        return this.strategyWrapper.getRouteRegion();
    }

    @Override
    public String getRouteEnvironment() {
        return null;
    }

    @Override
    public String getRouteAddress() {
        boolean isInnerConditionHeaderForced = this.isInnerConditionHeaderForced();
        if (isInnerConditionHeaderForced) {
            Map<String, String> headerMap = this.strategyWrapper.getHeaderMap();
            return this.strategyWrapper.getRouteAddress(headerMap);
        }
        return this.strategyWrapper.getRouteAddress();
    }

    @Override
    public String getRouteVersionWeight() {
        boolean isInnerConditionHeaderForced = this.isInnerConditionHeaderForced();
        if (isInnerConditionHeaderForced) {
            Map<String, String> headerMap = this.strategyWrapper.getHeaderMap();
            return this.strategyWrapper.getRouteVersionWeight(headerMap);
        }
        return this.strategyWrapper.getRouteVersionWeight();
    }

    @Override
    public String getRouteRegionWeight() {
        boolean isInnerConditionHeaderForced = this.isInnerConditionHeaderForced();
        if (isInnerConditionHeaderForced) {
            Map<String, String> headerMap = this.strategyWrapper.getHeaderMap();
            return this.strategyWrapper.getRouteRegionWeight(headerMap);
        }
        return this.strategyWrapper.getRouteRegionWeight();
    }

    @Override
    public String getRouteIdBlacklist() {
        return this.strategyWrapper.getRouteIdBlacklist();
    }

    @Override
    public String getRouteAddressBlacklist() {
        return this.strategyWrapper.getRouteAddressBlacklist();
    }

    public String getTraceId() {
        if (this.strategyMonitorContext != null) {
            return this.strategyMonitorContext.getTraceId();
        }
        return null;
    }

    public String getSpanId() {
        if (this.strategyMonitorContext != null) {
            return this.strategyMonitorContext.getSpanId();
        }
        return null;
    }

    public PluginAdapter getPluginAdapter() {
        return this.pluginAdapter;
    }

    public StrategyWrapper getStrategyWrapper() {
        return this.strategyWrapper;
    }

    protected boolean isInnerConditionHeaderForced() {
        return false;
    }
}

