/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static Logger logger = LoggerFactory.getLogger(IOUtils.class);

    public static void closeAndIgnoreException(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeAndLogException(Closeable closeable) {
        block4: {
            if (closeable == null) {
                logger.trace("closeable was null");
            } else {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (logger == null) break block4;
                    logger.error("failed to close InputStream: {}", (Object)e.getMessage());
                    logger.debug("failed to close InputStream:", (Throwable)e);
                }
            }
        }
    }

    public static void copy(InputStream from, OutputStream to) throws IOException {
        ReadableByteChannel in = Channels.newChannel(from);
        WritableByteChannel out = Channels.newChannel(to);
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (in.read(buffer) != -1) {
            buffer.flip();
            out.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            out.write(buffer);
        }
    }

    public static void copyFromString(String from, OutputStream to) throws IOException {
        IOUtils.copyFromString(from, Charset.defaultCharset(), to);
    }

    public static void copyFromString(String from, Charset fromCharset, OutputStream to) throws IOException {
        to.write(from.getBytes(fromCharset));
    }

    public static String copyToString(InputStream from) throws IOException {
        return IOUtils.copyToString(from, Charset.defaultCharset());
    }

    public static String copyToString(InputStream from, Charset toCharset) throws IOException {
        StringBuilder builder = new StringBuilder();
        byte[] byteBuffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = from.read(byteBuffer, 0, 1024)) >= 0) {
            builder.append(new String(byteBuffer, 0, bytesRead, toCharset));
        }
        return builder.toString();
    }

    public static void deleteFiles(File ... files) {
        for (File file : files) {
            file.delete();
        }
    }

    public static String readFile(File file) throws IOException {
        return IOUtils.readFile(file, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, Charset charset) throws IOException {
        String contents = null;
        FileInputStream from = null;
        try {
            from = new FileInputStream(file);
            contents = IOUtils.copyToString(from, charset);
        }
        catch (Throwable throwable) {
            IOUtils.closeAndLogException(from);
            throw throwable;
        }
        IOUtils.closeAndLogException(from);
        return contents;
    }

    public static void writeFile(File file, String contents) throws IOException {
        IOUtils.writeFile(file, contents, Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String contents, Charset charset) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            IOUtils.copyFromString(contents, charset, outputStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeAndLogException(outputStream);
            throw throwable;
        }
        IOUtils.closeAndLogException(outputStream);
    }
}

