/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.tunnel;

public class Tunnel {
    private String spec;
    private String destinationHostname;
    private int destinationPort;
    private String localAlias;
    private int localPort;
    private int assignedLocalPort;

    public Tunnel(String spec) {
        String[] parts = spec.split(":");
        if (parts.length == 4) {
            this.localAlias = parts[0];
            this.localPort = Integer.parseInt(parts[1]);
            this.destinationHostname = parts[2];
            this.destinationPort = Integer.parseInt(parts[3]);
        } else if (parts.length == 3) {
            this.localPort = Integer.parseInt(parts[0]);
            this.destinationHostname = parts[1];
            this.destinationPort = Integer.parseInt(parts[2]);
        } else {
            this.localPort = 0;
            this.destinationHostname = parts[0];
            this.destinationPort = Integer.parseInt(parts[1]);
        }
    }

    public Tunnel(String destinationHostname, int destinationPort) {
        this(0, destinationHostname, destinationPort);
    }

    public Tunnel(int localPort, String destinationHostname, int destinationPort) {
        this(null, localPort, destinationHostname, destinationPort);
    }

    public Tunnel(String localAlias, int localPort, String destinationHostname, int destinationPort) {
        this.localAlias = localAlias;
        this.localPort = localPort;
        this.destinationHostname = destinationHostname;
        this.destinationPort = destinationPort;
    }

    public boolean equals(Object other) {
        return other instanceof Tunnel && this.getSpec().equals(((Tunnel)other).getSpec());
    }

    public int getAssignedLocalPort() {
        return this.assignedLocalPort == 0 ? this.localPort : this.assignedLocalPort;
    }

    public String getDestinationHostname() {
        return this.destinationHostname;
    }

    public int getDestinationPort() {
        return this.destinationPort;
    }

    public String getLocalAlias() {
        return this.localAlias;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getSpec() {
        if (this.spec == null) {
            this.spec = this.toString().toLowerCase();
        }
        return this.spec;
    }

    public int hashCode() {
        return this.getSpec().hashCode();
    }

    void setAssignedLocalPort(int port) {
        this.assignedLocalPort = port;
    }

    public String toString() {
        return (this.localAlias == null ? "" : this.localAlias + ":") + (this.assignedLocalPort == 0 ? Integer.valueOf(this.localPort) : "(0)" + this.assignedLocalPort) + ":" + this.destinationHostname + ":" + this.destinationPort;
    }
}

