/*
 * Decompiled with CFR 0.152.
 */
package com.pastdev.jsch.nio.file;

import com.jcraft.jsch.JSchException;
import com.pastdev.jsch.command.CommandRunner;
import com.pastdev.jsch.nio.file.UnixSshFileSystemWatchService;
import com.pastdev.jsch.nio.file.UnixSshPath;
import com.pastdev.jsch.nio.file.UnixSshPathWatchKey;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.WatchEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnixSshPathINotifyWatchKey
extends UnixSshPathWatchKey {
    private static Logger logger = LoggerFactory.getLogger(UnixSshPathINotifyWatchKey.class);
    private static final String SEPARATOR = " ";
    private CommandRunner commandRunner = null;

    public UnixSshPathINotifyWatchKey(UnixSshFileSystemWatchService watchService, UnixSshPath dir, WatchEvent.Kind<?>[] kinds) {
        super(watchService, dir, kinds, -1L, null);
    }

    private void closeCommandRunner() {
        if (this.commandRunner != null) {
            try {
                this.commandRunner.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void cancel() {
        this.closeCommandRunner();
        super.cancel();
    }

    private void event(String line) {
        String[] actionAndFile = line.split(SEPARATOR);
        UnixSshPath filePath = this.dir.toAbsolutePath().relativize(this.dir.resolve(actionAndFile[1]).toAbsolutePath());
        if ("CREATE".equals(actionAndFile[0])) {
            this.addCreateEvent(filePath);
        } else if ("MODIFY".equals(actionAndFile[0])) {
            this.addModifyEvent(filePath);
        } else if ("DELETE".equals(actionAndFile[0])) {
            this.addDeleteEvent(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StringBuilder commandBuilder = new StringBuilder(this.dir.getFileSystem().getCommand("inotifywait")).append(" -m -e create -e modify -e delete  --format '%:e").append(SEPARATOR).append("%f' ").append(this.dir.toAbsolutePath().quotedString());
        try {
            this.commandRunner = this.dir.getFileSystem().getCommandRunner().duplicate();
            CommandRunner.ChannelExecWrapper channel = this.commandRunner.open(commandBuilder.toString());
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(channel.getInputStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.event(line);
                }
            }
        }
        catch (JSchException e) {
            logger.debug("watch service failed: ", (Object)e.getMessage());
        }
        catch (IOException e) {
            logger.debug("watch service failed: ", (Object)e.getMessage());
        }
        catch (ClosedWatchServiceException e) {
            logger.debug("watch service was closed, so exit");
        }
        finally {
            this.closeCommandRunner();
        }
        logger.info("poller stopped for {}", (Object)this.dir);
    }
}

