/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.blocks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;

@StatelessCheck
public class NeedBracesCheck
extends AbstractCheck {
    public static final String MSG_KEY_NEED_BRACES = "needBraces";
    private boolean allowSingleLineStatement;
    private boolean allowEmptyLoopBody;

    public void setAllowSingleLineStatement(boolean allowSingleLineStatement) {
        this.allowSingleLineStatement = allowSingleLineStatement;
    }

    public void setAllowEmptyLoopBody(boolean allowEmptyLoopBody) {
        this.allowEmptyLoopBody = allowEmptyLoopBody;
    }

    @Override
    public int[] getDefaultTokens() {
        return new int[]{85, 92, 91, 83, 84};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{85, 92, 91, 83, 84, 93, 94, 181};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean skipEmptyLoopBody;
        DetailAST slistAST = ast.findFirstToken(7);
        boolean isElseIf = false;
        if (ast.getType() == 92 && ast.findFirstToken(83) != null) {
            isElseIf = true;
        }
        boolean isDefaultInAnnotation = NeedBracesCheck.isDefaultInAnnotation(ast);
        boolean skipStatement = this.isSkipStatement(ast);
        boolean bl = skipEmptyLoopBody = this.allowEmptyLoopBody && NeedBracesCheck.isEmptyLoopBody(ast);
        if (!(slistAST != null || isElseIf || isDefaultInAnnotation || skipStatement || skipEmptyLoopBody)) {
            this.log(ast.getLineNo(), MSG_KEY_NEED_BRACES, ast.getText());
        }
    }

    private static boolean isDefaultInAnnotation(DetailAST ast) {
        boolean isDefaultInAnnotation = false;
        if (ast.getType() == 94 && ast.getParent().getType() == 161) {
            isDefaultInAnnotation = true;
        }
        return isDefaultInAnnotation;
    }

    private boolean isSkipStatement(DetailAST statement) {
        return this.allowSingleLineStatement && NeedBracesCheck.isSingleLineStatement(statement);
    }

    private static boolean isEmptyLoopBody(DetailAST ast) {
        boolean noBodyLoop = false;
        if (ast.getType() == 91 || ast.getType() == 84) {
            DetailAST currentToken = ast.getFirstChild();
            while (currentToken.getNextSibling() != null) {
                currentToken = currentToken.getNextSibling();
            }
            noBodyLoop = currentToken.getType() == 38;
        }
        return noBodyLoop;
    }

    private static boolean isSingleLineStatement(DetailAST statement) {
        boolean result;
        switch (statement.getType()) {
            case 83: {
                result = NeedBracesCheck.isSingleLineIf(statement);
                break;
            }
            case 91: {
                result = NeedBracesCheck.isSingleLineFor(statement);
                break;
            }
            case 85: {
                result = NeedBracesCheck.isSingleLineDoWhile(statement);
                break;
            }
            case 84: {
                result = NeedBracesCheck.isSingleLineWhile(statement);
                break;
            }
            case 181: {
                result = NeedBracesCheck.isSingleLineLambda(statement);
                break;
            }
            case 93: {
                result = NeedBracesCheck.isSingleLineCase(statement);
                break;
            }
            case 94: {
                result = NeedBracesCheck.isSingleLineDefault(statement);
                break;
            }
            default: {
                result = NeedBracesCheck.isSingleLineElse(statement);
            }
        }
        return result;
    }

    private static boolean isSingleLineWhile(DetailAST literalWhile) {
        boolean result = false;
        if (literalWhile.getParent().getType() == 7 && literalWhile.getLastChild().getType() != 7) {
            DetailAST block = literalWhile.getLastChild().getPreviousSibling();
            result = literalWhile.getLineNo() == block.getLineNo();
        }
        return result;
    }

    private static boolean isSingleLineDoWhile(DetailAST literalDo) {
        boolean result = false;
        if (literalDo.getParent().getType() == 7 && literalDo.getFirstChild().getType() != 7) {
            DetailAST block = literalDo.getFirstChild();
            result = block.getLineNo() == literalDo.getLineNo();
        }
        return result;
    }

    private static boolean isSingleLineFor(DetailAST literalFor) {
        boolean result = false;
        if (literalFor.getLastChild().getType() == 38) {
            result = true;
        } else if (literalFor.getParent().getType() == 7 && literalFor.getLastChild().getType() != 7) {
            result = literalFor.getLineNo() == literalFor.getLastChild().getLineNo();
        }
        return result;
    }

    private static boolean isSingleLineIf(DetailAST literalIf) {
        boolean result = false;
        if (literalIf.getParent().getType() == 7) {
            DetailAST literalIfLastChild = literalIf.getLastChild();
            DetailAST block = literalIfLastChild.getType() == 92 ? literalIfLastChild.getPreviousSibling() : literalIfLastChild;
            DetailAST ifCondition = literalIf.findFirstToken(28);
            result = ifCondition.getLineNo() == block.getLineNo();
        }
        return result;
    }

    private static boolean isSingleLineLambda(DetailAST lambda) {
        boolean result = false;
        DetailAST block = lambda.getLastChild();
        if (block.getType() != 7) {
            result = lambda.getLineNo() == block.getLineNo();
        }
        return result;
    }

    private static boolean isSingleLineCase(DetailAST literalCase) {
        boolean result = false;
        DetailAST slist = literalCase.getNextSibling();
        if (slist == null) {
            result = true;
        } else {
            DetailAST caseBreak;
            DetailAST block = slist.getFirstChild();
            if (block.getType() != 7 && (caseBreak = slist.findFirstToken(86)) != null) {
                boolean atOneLine = literalCase.getLineNo() == block.getLineNo();
                result = atOneLine && block.getLineNo() == caseBreak.getLineNo();
            }
        }
        return result;
    }

    private static boolean isSingleLineDefault(DetailAST literalDefault) {
        boolean result = false;
        DetailAST slist = literalDefault.getNextSibling();
        if (slist == null) {
            result = true;
        } else {
            DetailAST block = slist.getFirstChild();
            if (block != null && block.getType() != 7) {
                result = literalDefault.getLineNo() == block.getLineNo();
            }
        }
        return result;
    }

    private static boolean isSingleLineElse(DetailAST literalElse) {
        boolean result = false;
        DetailAST block = literalElse.getFirstChild();
        if (block.getType() != 7) {
            result = literalElse.getLineNo() == block.getLineNo();
        }
        return result;
    }
}

