/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import com.puppycrawl.tools.checkstyle.utils.TokenUtils;

@StatelessCheck
public class IllegalTokenCheck
extends AbstractCheck {
    public static final String MSG_KEY = "illegal.token";

    @Override
    public int[] getDefaultTokens() {
        return new int[]{22};
    }

    @Override
    public int[] getAcceptableTokens() {
        return TokenUtils.getAllTokenIds();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtils.EMPTY_INT_ARRAY;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    @Override
    public void visitToken(DetailAST ast) {
        this.log(ast.getLineNo(), ast.getColumnNo(), MSG_KEY, IllegalTokenCheck.convertToString(ast));
    }

    private static String convertToString(DetailAST ast) {
        String tokenText;
        switch (ast.getType()) {
            case 22: {
                tokenText = ast.getFirstChild().getText() + ast.getText();
                break;
            }
            case 183: {
                tokenText = JavadocUtils.escapeAllControlChars(ast.getText());
                break;
            }
            default: {
                tokenText = ast.getText();
            }
        }
        return tokenText;
    }
}

