/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.internal.ExceptionHandler;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.StreamUtils;
import com.samczsun.skype4j.internal.Utils;
import com.samczsun.skype4j.internal.utils.Encoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.imageio.ImageIO;

public class Endpoints {
    private static Map<Class<?>, Converter<?>> converters = new HashMap();
    public static final Provider<String> AUTHORIZATION;
    public static final Provider<String> COOKIE;
    public static final Endpoints ACCEPT_CONTACT_REQUEST;
    public static final Endpoints GET_JOIN_URL;
    public static final Endpoints CHAT_INFO_URL;
    public static final Endpoints CONVERSATION_PROPERTY_SELF;
    public static final Endpoints SEND_MESSAGE_URL;
    public static final Endpoints MODIFY_MEMBER_URL;
    public static final Endpoints CONVERSATION_PROPERTY_GLOBAL;
    public static final Endpoints ADD_MEMBER_URL;
    public static final Endpoints LOGIN_URL;
    public static final Endpoints PING_URL;
    public static final Endpoints TOKEN_AUTH_URL;
    public static final Endpoints LOGOUT_URL;
    public static final Endpoints ENDPOINTS_URL;
    public static final Endpoints AUTH_REQUESTS_URL;
    public static final Endpoints TROUTER_URL;
    public static final Endpoints POLICIES_URL;
    public static final Endpoints REGISTRATIONS;
    public static final Endpoints THREAD_URL;
    public static final Endpoints SUBSCRIPTIONS_URL;
    public static final Endpoints MESSAGINGSERVICE_URL;
    public static final Endpoints POLL;
    public static final Endpoints NEW_GUEST;
    public static final Endpoints LEAVE_GUEST;
    public static final Endpoints ACTIVE;
    public static final Endpoints LOAD_CHATS;
    public static final Endpoints LOAD_MESSAGES;
    public static final Endpoints OBJECTS;
    public static final Endpoints UPLOAD_IMAGE;
    public static final Endpoints IMG_STATUS;
    public static final Endpoints FETCH_IMAGE;
    public static final Endpoints VISIBILITY;
    public static final Endpoints SEARCH_SKYPE_DIRECTORY;
    public static final Endpoints GET_ALL_CONTACTS;
    public static final Endpoints GET_CONTACT_BY_ID;
    public static final Endpoints BLOCK_CONTACT;
    public static final Endpoints UNBLOCK_CONTACT;
    public static final Endpoints AUTHORIZE_CONTACT;
    public static final Endpoints UNAUTHORIZE_CONTACT;
    public static final Endpoints DECLINE_CONTACT_REQUEST;
    public static final Endpoints UNAUTHORIZE_CONTACT_SELF;
    public static final Endpoints AUTHORIZATION_REQUEST;
    public static final Endpoints CONTACT_INFO;
    public static final Endpoints RECONNECT_WEBSOCKET;
    private boolean requiresCloud;
    private boolean requiresRegToken;
    private boolean requiresSkypeToken;
    private Map<String, Provider<String>> providers = new HashMap<String, Provider<String>>();
    private String url;

    public static <T> T convert(Class<?> type, SkypeImpl skype, HttpURLConnection in) throws IOException {
        return (T)converters.get(type).convert(in);
    }

    public String url() {
        return this.url;
    }

    private Endpoints(String url) {
        this.url = url;
    }

    public static EndpointConnection<HttpURLConnection> custom(String url, SkypeImpl skype, String ... args) {
        if (skype.isShutdownRequested()) {
            throw new IllegalStateException("API is shut down");
        }
        return new EndpointConnection(new Endpoints(url), skype, args).as(HttpURLConnection.class);
    }

    public EndpointConnection<HttpURLConnection> open(SkypeImpl skype, Object ... args) {
        if (skype.isShutdownRequested()) {
            throw new IllegalStateException("API is shut down");
        }
        return new EndpointConnection(this, skype, args).as(HttpURLConnection.class);
    }

    private Endpoints cloud() {
        this.requiresCloud = true;
        return this;
    }

    private Endpoints regtoken() {
        this.requiresRegToken = true;
        return this;
    }

    private Endpoints skypetoken() {
        this.requiresSkypeToken = true;
        return this;
    }

    private Endpoints defaultHeader(String key, Provider<String> val) {
        this.providers.put(key, val);
        return this;
    }

    static {
        converters.put(InputStream.class, URLConnection::getInputStream);
        converters.put(HttpURLConnection.class, in -> in);
        converters.put(JsonObject.class, in -> Utils.parseJsonObject(in.getInputStream()));
        converters.put(JsonArray.class, in -> Utils.parseJsonArray(in.getInputStream()));
        converters.put(String.class, in -> StreamUtils.readFully(in.getInputStream()));
        converters.put(BufferedImage.class, in -> ImageIO.read(in.getInputStream()));
        AUTHORIZATION = skype -> "skype_token " + skype.getSkypeToken();
        COOKIE = skype -> "skypetoken_asm=" + skype.getSkypeToken();
        ACCEPT_CONTACT_REQUEST = new Endpoints("https://api.skype.com/users/self/contacts/auth-request/%s/accept").skypetoken();
        GET_JOIN_URL = new Endpoints("https://api.scheduler.skype.com/threads").skypetoken();
        CHAT_INFO_URL = new Endpoints("https://%sclient-s.gateway.messenger.live.com/v1/threads/%s/?view=msnp24Equivalent").cloud().regtoken();
        CONVERSATION_PROPERTY_SELF = new Endpoints("https://%sclient-s.gateway.messenger.live.com/v1/users/ME/conversations/%s/properties?name=%s").cloud().regtoken();
        SEND_MESSAGE_URL = new Endpoints("https://%sclient-s.gateway.messenger.live.com/v1/users/ME/conversations/%s/messages").cloud().regtoken();
        MODIFY_MEMBER_URL = new Endpoints("https://%sclient-s.gateway.messenger.live.com/v1/threads/%s/members/8:%s").cloud().regtoken();
        CONVERSATION_PROPERTY_GLOBAL = new Endpoints("https://%sclient-s.gateway.messenger.live.com/v1/threads/%s/properties?name=%s").cloud().regtoken();
        ADD_MEMBER_URL = new Endpoints("https://client-s.gateway.messenger.live.com/v1/threads/%s/members/8:%s").regtoken();
        LOGIN_URL = new Endpoints("https://api.skype.com/login/skypetoken");
        PING_URL = new Endpoints("https://web.skype.com/api/v1/session-ping").skypetoken();
        TOKEN_AUTH_URL = new Endpoints("https://api.asm.skype.com/v1/skypetokenauth");
        LOGOUT_URL = new Endpoints("https://login.skype.com/logout?client_id=578134&redirect_uri=https%3A%2F%2Fweb.skype.com&intsrc=client-_-webapp-_-production-_-go-signin");
        ENDPOINTS_URL = new Endpoints("https://client-s.gateway.messenger.live.com/v1/users/ME/endpoints");
        AUTH_REQUESTS_URL = new Endpoints("https://api.skype.com/users/self/contacts/auth-request").skypetoken();
        TROUTER_URL = new Endpoints("https://go.trouter.io/v2/a");
        POLICIES_URL = new Endpoints("https://prod.tpc.skype.com/v1/policies").skypetoken();
        REGISTRATIONS = new Endpoints("https://prod.registrar.skype.com/v2/registrations").skypetoken();
        THREAD_URL = new Endpoints("https://%sclient-s.gateway.messenger.live.com/v1/threads").cloud().regtoken();
        SUBSCRIPTIONS_URL = new Endpoints("https://%sclient-s.gateway.messenger.live.com/v1/users/ME/endpoints/SELF/subscriptions").cloud().regtoken();
        MESSAGINGSERVICE_URL = new Endpoints("https://%sclient-s.gateway.messenger.live.com/v1/users/ME/endpoints/%s/presenceDocs/messagingService").cloud().regtoken();
        POLL = new Endpoints("https://%sclient-s.gateway.messenger.live.com/v1/users/ME/endpoints/SELF/subscriptions/%s/poll").cloud().regtoken();
        NEW_GUEST = new Endpoints("https://join.skype.com/api/v1/users/guests");
        LEAVE_GUEST = new Endpoints("https://join.skype.com/guests/leave?threadId=%s");
        ACTIVE = new Endpoints("https://client-s.gateway.messenger.live.com/v1/users/ME/endpoints/%s/active").regtoken();
        LOAD_CHATS = new Endpoints("https://client-s.gateway.messenger.live.com/v1/users/ME/conversations?startTime=%s&pageSize=%s&view=msnp24Equivalent&targetType=Passport|Skype|Lync|Thread").regtoken();
        LOAD_MESSAGES = new Endpoints("https://client-s.gateway.messenger.live.com/v1/users/ME/conversations/%s/messages?startTime=0&pageSize=%s&view=msnp24Equivalent|supportsMessageProperties&targetType=Passport|Skype|Lync|Thread").regtoken();
        OBJECTS = new Endpoints("https://api.asm.skype.com/v1/objects").defaultHeader("Authorization", AUTHORIZATION);
        UPLOAD_IMAGE = new Endpoints("https://api.asm.skype.com/v1/objects/%s/content/%s").defaultHeader("Authorization", AUTHORIZATION);
        IMG_STATUS = new Endpoints("https://api.asm.skype.com/v1/objects/%s/views/%s/status").defaultHeader("Cookie", COOKIE);
        FETCH_IMAGE = new Endpoints("https://api.asm.skype.com/v1/objects/%s/views/%s").defaultHeader("Authorization", AUTHORIZATION);
        VISIBILITY = new Endpoints("https://%sclient-s.gateway.messenger.live.com/v1/users/ME/presenceDocs/messagingService").cloud().regtoken();
        SEARCH_SKYPE_DIRECTORY = new Endpoints("https://api.skype.com/search/users/any?keyWord=%s&contactTypes[]=skype").skypetoken();
        GET_ALL_CONTACTS = new Endpoints("https://contacts.skype.com/contacts/v1/users/%s/contacts?$filter=type%%20eq%%20%%27skype%%27%%20or%%20type%%20eq%%20%%27msn%%27%%20or%%20type%%20eq%%20%%27pstn%%27%%20or%%20type%%20eq%%20%%27agent%%27&reason=%s").skypetoken();
        GET_CONTACT_BY_ID = new Endpoints("https://contacts.skype.com/contacts/v1/users/%s/contacts?$filter=id%%20eq%%20%%27%s%%27&reason=default").skypetoken();
        BLOCK_CONTACT = new Endpoints("https://api.skype.com/users/self/contacts/%s/block").skypetoken();
        UNBLOCK_CONTACT = new Endpoints("https://api.skype.com/users/self/contacts/%s/unblock").skypetoken();
        AUTHORIZE_CONTACT = new Endpoints("https://api.skype.com/users/self/contacts/auth-request/%s/accept").skypetoken();
        UNAUTHORIZE_CONTACT = new Endpoints("https://client-s.gateway.messenger.live.com/v1/users/ME/contacts/8:%s").regtoken();
        DECLINE_CONTACT_REQUEST = new Endpoints("https://api.skype.com/users/self/contacts/auth-request/%s/decline").skypetoken();
        UNAUTHORIZE_CONTACT_SELF = new Endpoints("https://api.skype.com/users/self/contacts/%s").skypetoken();
        AUTHORIZATION_REQUEST = new Endpoints("https://api.skype.com/users/self/contacts/auth-request/%s").skypetoken();
        CONTACT_INFO = new Endpoints("https://api.skype.com/users/self/contacts/profiles").skypetoken();
        RECONNECT_WEBSOCKET = new Endpoints("https://go.trouter.io/v2/h?ccid=%s&dom=web.skype.com");
    }

    public static interface UncheckedFunction<R>
    extends Function<HttpURLConnection, R> {
        @Override
        default public R apply(HttpURLConnection httpURLConnection) {
            try {
                return this.apply0(httpURLConnection);
            }
            catch (Throwable t) {
                Utils.sneakyThrow(t);
                return null;
            }
        }

        public R apply0(HttpURLConnection var1) throws Throwable;
    }

    public static interface Converter<T> {
        public T convert(HttpURLConnection var1) throws IOException;
    }

    public static interface Provider<T> {
        public T provide(SkypeImpl var1);
    }

    public static class EndpointConnection<E_TYPE> {
        private Class<E_TYPE> clazz = HttpURLConnection.class;
        private Endpoints endpoint;
        private SkypeImpl skype;
        private Object[] args;
        private Map<String, String> headers = new HashMap<String, String>();
        private Map<String, String> cookies = new HashMap<String, String>();
        private Map<Predicate<Integer>, UncheckedFunction<E_TYPE>> errors = new HashMap<Predicate<Integer>, UncheckedFunction<E_TYPE>>();
        private URL url;
        private String cause;
        private boolean dontConnect;
        private boolean redirect = true;

        private EndpointConnection(Endpoints endpoint, SkypeImpl skype, Object[] args) {
            this.endpoint = endpoint;
            this.skype = skype;
            this.args = args;
            this.header("User-Agent", "Mozilla/5.0 (Windows NT 10; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.73 Safari/537.36 Skype4J/0.1.5-SNAPSHOT");
        }

        public EndpointConnection<E_TYPE> header(String key, String val) {
            this.headers.put(key, val);
            return this;
        }

        public EndpointConnection<E_TYPE> cookie(String key, String val) {
            this.cookies.put(key, val);
            return this;
        }

        public EndpointConnection<E_TYPE> cookies(Map<String, String> cookies) {
            this.cookies.putAll(cookies);
            return this;
        }

        public EndpointConnection<E_TYPE> on(int code, UncheckedFunction<E_TYPE> action) {
            return this.on(x -> x == code, action);
        }

        public EndpointConnection<E_TYPE> on(Predicate<Integer> check, UncheckedFunction<E_TYPE> result) {
            this.errors.put(check, result);
            return this;
        }

        public EndpointConnection<E_TYPE> expect(int code, String cause) {
            return this.expect(x -> x == code, cause);
        }

        public EndpointConnection<E_TYPE> expect(Predicate<Integer> check, String cause) {
            this.cause = cause;
            return this.on(check, (HttpURLConnection connection) -> Endpoints.convert(this.clazz, this.skype, connection));
        }

        public EndpointConnection<E_TYPE> noRedirects() {
            this.redirect = false;
            return this;
        }

        public <NEW_E_TYPE> EndpointConnection<NEW_E_TYPE> as(Class<NEW_E_TYPE> clazz) {
            this.clazz = clazz;
            return this;
        }

        public EndpointConnection<E_TYPE> dontConnect() {
            this.dontConnect = true;
            return this;
        }

        public E_TYPE get() throws ConnectionException {
            return this.connect("GET", new byte[0]);
        }

        public E_TYPE delete() throws ConnectionException {
            return this.connect("DELETE", new byte[0]);
        }

        public E_TYPE post() throws ConnectionException {
            return this.connect("POST", new byte[0]);
        }

        public E_TYPE post(String data) throws ConnectionException {
            return this.connect("POST", data);
        }

        public E_TYPE post(JsonValue json) throws ConnectionException {
            return this.header("Content-Type", "application/json").connect("POST", json.toString());
        }

        public E_TYPE put() throws ConnectionException {
            return this.connect("PUT", new byte[0]);
        }

        public E_TYPE put(String data) throws ConnectionException {
            return this.connect("PUT", data);
        }

        public E_TYPE put(JsonValue json) throws ConnectionException {
            return this.header("Content-Type", "application/json").connect("PUT", json.toString());
        }

        public E_TYPE connect(String method, String data) throws ConnectionException {
            return this.connect(method, data != null ? data.getBytes(StandardCharsets.UTF_8) : new byte[]{});
        }

        public E_TYPE connect(String method, byte[] rawData) throws ConnectionException {
            if (!this.cookies.isEmpty()) {
                this.header("Cookie", this.serializeCookies(this.cookies));
            }
            if (this.endpoint.requiresRegToken) {
                this.header("RegistrationToken", this.skype.getRegistrationToken());
            }
            if (this.endpoint.requiresSkypeToken) {
                this.header("X-SkypeToken", this.skype.getSkypeToken());
            }
            if (this.redirect) {
                this.on(code -> code >= 301 && code <= 303 || code == 307 || code == 308, (HttpURLConnection connection) -> {
                    this.skype.updateCloud(connection.getHeaderField("Location"));
                    this.url = new URL(connection.getHeaderField("Location"));
                    return this.connect(method, rawData);
                });
            }
            for (Map.Entry provider : this.endpoint.providers.entrySet()) {
                this.header((String)provider.getKey(), (String)((Provider)provider.getValue()).provide(this.skype));
            }
            HttpURLConnection connection2 = null;
            try {
                if (this.url == null) {
                    int i;
                    Iterator<Map.Entry<Predicate<Integer>, UncheckedFunction<E_TYPE>>> surl = this.endpoint.url;
                    if (this.endpoint.requiresCloud) {
                        Object[] objectArray = new Object[this.args.length + 1];
                        objectArray[0] = this.skype.getCloud();
                        for (i = 1; i < objectArray.length; ++i) {
                            objectArray[i] = this.args[i - 1].toString();
                        }
                        surl = String.format((String)((Object)surl), objectArray);
                    } else if (this.args.length > 0) {
                        Object[] objectArray = new Object[this.args.length];
                        for (i = 0; i < objectArray.length; ++i) {
                            objectArray[i] = this.args[i].toString();
                        }
                        surl = String.format((String)((Object)surl), this.args);
                    }
                    this.url = new URL((String)((Object)surl));
                }
                connection2 = (HttpURLConnection)this.url.openConnection();
                connection2.setRequestMethod(method);
                connection2.setInstanceFollowRedirects(false);
                for (Map.Entry entry : this.headers.entrySet()) {
                    connection2.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
                }
                if (!method.equalsIgnoreCase("GET")) {
                    connection2.setDoOutput(true);
                    if (rawData != null) {
                        connection2.getOutputStream().write(rawData);
                    } else {
                        connection2.getOutputStream().write(new byte[0]);
                    }
                }
                if (!this.dontConnect) {
                    if (connection2.getHeaderField("Set-RegistrationToken") != null) {
                        this.skype.setRegistrationToken(connection2.getHeaderField("Set-RegistrationToken"));
                    }
                    for (Map.Entry<Predicate<Integer>, UncheckedFunction<E_TYPE>> entry : this.errors.entrySet()) {
                        if (!entry.getKey().test(connection2.getResponseCode())) continue;
                        try {
                            return entry.getValue().apply(connection2);
                        }
                        catch (Throwable t) {
                            Utils.sneakyThrow(t);
                        }
                    }
                    throw ExceptionHandler.generateException(this.cause == null ? this.url.toString() : this.cause, connection2);
                }
                if (HttpURLConnection.class.isAssignableFrom(this.clazz)) {
                    return (E_TYPE)connection2;
                }
                throw new IllegalArgumentException("DontConnect requested but did not request cast to HttpURLConnection");
            }
            catch (IOException e) {
                if (connection2 != null) {
                    connection2.disconnect();
                }
                throw ExceptionHandler.generateException(this.cause, e);
            }
        }

        private String serializeCookies(Map<String, String> cookies) {
            StringBuilder result = new StringBuilder();
            for (Map.Entry<String, String> cookie : cookies.entrySet()) {
                result.append(Encoder.encode(cookie.getKey())).append("=").append(Encoder.encode(cookie.getValue())).append(";");
            }
            return result.toString();
        }
    }
}

