/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal.chat;

import com.samczsun.skype4j.chat.IndividualChat;
import com.samczsun.skype4j.exceptions.ChatNotFoundException;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.UserImpl;
import com.samczsun.skype4j.internal.chat.ChatImpl;
import com.samczsun.skype4j.user.User;
import java.util.HashMap;

public class ChatIndividual
extends ChatImpl
implements IndividualChat {
    private User partner;

    protected ChatIndividual(SkypeImpl skype, String identity) throws ConnectionException, ChatNotFoundException {
        super(skype, identity);
    }

    @Override
    protected void load() throws ConnectionException {
        if (this.isLoaded()) {
            return;
        }
        this.isLoading.set(true);
        HashMap<String, UserImpl> newUsers = new HashMap<String, UserImpl>();
        String username = this.getIdentity().substring(2);
        UserImpl user = (UserImpl)this.users.get(username.toLowerCase());
        if (user == null) {
            user = new UserImpl(username, this, this.getClient());
        }
        newUsers.put(username.toLowerCase(), user);
        this.partner = user;
        UserImpl me = (UserImpl)this.users.get(this.getClient().getUsername().toLowerCase());
        if (me == null) {
            me = new UserImpl(this.getClient().getUsername(), this, this.getClient());
            newUsers.put(this.getClient().getUsername().toLowerCase(), me);
        }
        this.users.clear();
        this.users.putAll(newUsers);
        this.isLoading.set(false);
        this.hasLoaded.set(true);
    }

    @Override
    public void addUser(String username) {
        throw new IllegalArgumentException("Cannot add user to individual chat");
    }

    @Override
    public void removeUser(String username) {
        throw new IllegalArgumentException("Cannot remove user from individual chat");
    }

    @Override
    public User getPartner() {
        return this.partner;
    }
}

