/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal.client;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.samczsun.skype4j.chat.GroupChat;
import com.samczsun.skype4j.events.contact.ContactRequestEvent;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.exceptions.InvalidCredentialsException;
import com.samczsun.skype4j.exceptions.handler.ErrorHandler;
import com.samczsun.skype4j.exceptions.handler.ErrorSource;
import com.samczsun.skype4j.internal.ContactImpl;
import com.samczsun.skype4j.internal.ContactRequestImpl;
import com.samczsun.skype4j.internal.Endpoints;
import com.samczsun.skype4j.internal.ExceptionHandler;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.threads.AuthenticationChecker;
import com.samczsun.skype4j.internal.threads.KeepaliveThread;
import com.samczsun.skype4j.internal.utils.Encoder;
import com.samczsun.skype4j.internal.utils.UncheckedRunnable;
import com.samczsun.skype4j.user.Contact;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

public class FullClient
extends SkypeImpl {
    private static final Pattern URL_PATTERN = Pattern.compile("threads/(.*)", 2);
    private final String password;

    public FullClient(String username, String password, Set<String> resources, Logger customLogger, List<ErrorHandler> errorHandlers) {
        super(username, resources, customLogger, errorHandlers);
        this.password = password;
    }

    @Override
    public void login() throws InvalidCredentialsException, ConnectionException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("scopes", "client");
        data.put("clientVersion", "0/7.4.85.102/259/");
        data.put("username", this.username);
        data.put("passwordHash", this.hash());
        JsonObject loginData = Endpoints.LOGIN_URL.open(this, new Object[0]).as(JsonObject.class).expect(200, "While logging in").post(Encoder.encode(data));
        this.setSkypeToken(loginData.get("skypetoken").asString());
        ArrayList<UncheckedRunnable> tasks = new ArrayList<UncheckedRunnable>();
        tasks.add(this::registerEndpoint);
        tasks.add(() -> {
            HttpURLConnection asmResponse = this.getAsmToken();
            String[] setCookie = asmResponse.getHeaderField("Set-Cookie").split(";")[0].split("=");
            this.cookies.put(setCookie[0], setCookie[1]);
        });
        tasks.add(this::loadAllContacts);
        tasks.add(() -> this.getContactRequests(false));
        tasks.add(() -> {
            try {
                this.registerWebSocket();
            }
            catch (Exception e) {
                this.handleError(ErrorSource.REGISTERING_WEBSOCKET, e, false);
            }
        });
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(5);
            tasks.forEach(executorService::submit);
            executorService.shutdown();
            executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.loggedIn.set(true);
        this.sessionKeepaliveThread = new KeepaliveThread(this);
        this.sessionKeepaliveThread.start();
        this.reauthThread = new AuthenticationChecker(this);
        this.reauthThread.start();
    }

    @Override
    public void logout() throws ConnectionException {
        Endpoints.LOGOUT_URL.open(this, new Object[0]).noRedirects().expect(code -> code >= 301 && code <= 303 || code == 307 || code == 308, "While logging out").cookies(this.cookies).get();
        this.shutdown();
    }

    @Override
    public void loadAllContacts() throws ConnectionException {
        JsonObject object = Endpoints.GET_ALL_CONTACTS.open(this, this.getUsername(), "default").as(JsonObject.class).expect(200, "While loading contacts").get();
        for (JsonValue value : object.get("contacts").asArray()) {
            JsonObject obj = value.asObject();
            if (obj.get("suggested") != null && obj.get("suggested").asBoolean() || this.allContacts.containsKey(obj.get("id").asString())) continue;
            this.allContacts.put(obj.get("id").asString(), new ContactImpl((SkypeImpl)this, obj));
        }
    }

    @Override
    public void getContactRequests(boolean fromWebsocket) throws ConnectionException {
        JsonArray array = Endpoints.AUTH_REQUESTS_URL.open(this, new Object[0]).as(JsonArray.class).expect(200, "While loading authorization requests").get();
        for (JsonValue contactRequest : array) {
            JsonObject contactRequestObj = contactRequest.asObject();
            try {
                ContactRequestImpl request = new ContactRequestImpl(contactRequestObj.get("event_time").asString(), contactRequestObj.get("sender").asString(), contactRequestObj.get("greeting").asString(), this);
                if (!this.allContactRequests.add(request) || !fromWebsocket) continue;
                ContactRequestEvent event = new ContactRequestEvent(request);
                this.getEventDispatcher().callEvent(event);
            }
            catch (ParseException e) {
                this.getLogger().log(Level.WARNING, "Could not parse date for contact request", e);
            }
        }
        if (fromWebsocket) {
            this.updateContactList();
        }
    }

    @Override
    public void updateContactList() throws ConnectionException {
        JsonObject obj = Endpoints.GET_ALL_CONTACTS.open(this, this.getUsername(), "notification").as(JsonObject.class).expect(200, "While loading contacts").get();
        for (JsonValue value : obj.get("contacts").asArray()) {
            if (value.asObject().get("suggested") != null && value.asObject().get("suggested").asBoolean()) continue;
            String id = value.asObject().get("id").asString();
            ContactImpl impl = (ContactImpl)this.allContacts.get(id);
            impl.update(value.asObject());
        }
    }

    @Override
    public GroupChat createGroupChat(Contact ... contacts) throws ConnectionException {
        JsonObject obj = new JsonObject();
        JsonArray allContacts = new JsonArray();
        allContacts.add(new JsonObject().add("id", "8:" + this.getUsername()).add("role", "Admin"));
        for (Contact contact : contacts) {
            allContacts.add(new JsonObject().add("id", "8:" + contact.getUsername()).add("role", "User"));
        }
        obj.add("members", allContacts);
        HttpURLConnection con = Endpoints.THREAD_URL.open(this, new Object[0]).as(HttpURLConnection.class).expect(201, "While creating group chat").post(obj);
        String url = con.getHeaderField("Location");
        Matcher chatMatcher = URL_PATTERN.matcher(url);
        if (chatMatcher.find()) {
            String id = chatMatcher.group(1);
            while (this.getChat(id) == null) {
            }
            return (GroupChat)this.getChat(id);
        }
        throw ExceptionHandler.generateException("No chat location", con);
    }

    private String hash() {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] encodedMD = messageDigest.digest(String.format("%s\nskyper\n%s", this.username, this.password).getBytes(StandardCharsets.UTF_8));
            return DatatypeConverter.printBase64Binary((byte[])encodedMD);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

