/*
 * Decompiled with CFR 0.152.
 */
package com.samczsun.skype4j.internal.client;

import com.eclipsesource.json.JsonObject;
import com.samczsun.skype4j.chat.GroupChat;
import com.samczsun.skype4j.exceptions.ConnectionException;
import com.samczsun.skype4j.exceptions.NotParticipatingException;
import com.samczsun.skype4j.exceptions.handler.ErrorHandler;
import com.samczsun.skype4j.exceptions.handler.ErrorSource;
import com.samczsun.skype4j.internal.Endpoints;
import com.samczsun.skype4j.internal.SkypeImpl;
import com.samczsun.skype4j.internal.threads.AuthenticationChecker;
import com.samczsun.skype4j.internal.threads.KeepaliveThread;
import com.samczsun.skype4j.internal.utils.UncheckedRunnable;
import com.samczsun.skype4j.user.Contact;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class GuestClient
extends SkypeImpl {
    private final String chatId;

    public GuestClient(String username, String chatId, Set<String> resources, Logger logger, List<ErrorHandler> errorHandlers) {
        super(username, resources, logger, errorHandlers);
        this.chatId = chatId;
    }

    @Override
    public void login() throws ConnectionException {
        JsonObject response = Endpoints.NEW_GUEST.open(this, new Object[0]).as(JsonObject.class).on(303, connection -> {
            throw new NotParticipatingException();
        }).expect(201, "While logging in").header("csrf_token", "skype4j").cookie("csrf_token", "skype4j").post(new JsonObject().add("name", this.username).add("threadId", this.chatId).add("shortId", "Skype4J").add("flowId", "Skype4J"));
        this.setSkypeToken(response.get("skypetoken").asString());
        ArrayList<UncheckedRunnable> tasks = new ArrayList<UncheckedRunnable>();
        tasks.add(this::registerEndpoint);
        tasks.add(() -> {
            HttpURLConnection asmResponse = this.getAsmToken();
            String[] setCookie = asmResponse.getHeaderField("Set-Cookie").split(";")[0].split("=");
            this.cookies.put(setCookie[0], setCookie[1]);
        });
        tasks.add(() -> {
            try {
                this.registerWebSocket();
            }
            catch (Exception e) {
                this.handleError(ErrorSource.REGISTERING_WEBSOCKET, e, false);
            }
        });
        try {
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            tasks.forEach(executorService::submit);
            executorService.shutdown();
            executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.loggedIn.set(true);
        this.sessionKeepaliveThread = new KeepaliveThread(this);
        this.sessionKeepaliveThread.start();
        this.reauthThread = new AuthenticationChecker(this);
        this.reauthThread.start();
    }

    @Override
    public void logout() throws ConnectionException {
        Endpoints.LEAVE_GUEST.open(this, this.chatId).expect(200, "While logging out").cookie("guest_token_" + this.chatId, "skype4j::" + this.getSkypeToken()).cookie("csrf_token", "skype4j").cookie("launcher_session_id", "Skype4J").get();
        this.shutdown();
    }

    @Override
    public GroupChat createGroupChat(Contact ... contacts) {
        throw new UnsupportedOperationException("Not supported with a guest account");
    }

    @Override
    public void loadAllContacts() {
        throw new UnsupportedOperationException("Not supported with a guest account");
    }

    @Override
    public void getContactRequests(boolean fromWebsocket) {
        throw new UnsupportedOperationException("Not supported with a guest account");
    }

    @Override
    public void updateContactList() {
        throw new UnsupportedOperationException("Not supported with a guest account");
    }
}

