/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.INArrayRep;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.utilint.SizeofMarker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class INTargetRep
extends INArrayRep<INTargetRep, Type, Node> {
    public INTargetRep(IN parent) {
        super(parent);
    }

    public static class None
    extends INTargetRep {
        final int nodeMaxEntries;

        public Type getType() {
            return Type.NONE;
        }

        public None(IN parent, int nodeMaxEntries) {
            super(parent);
            this.nodeMaxEntries = nodeMaxEntries;
        }

        public None(SizeofMarker marker) {
            super(null);
            this.nodeMaxEntries = 0;
        }

        public Node get(int idx) {
            return null;
        }

        public INTargetRep set(int idx, Node node) {
            Sparse targets = new Sparse(this.parent, this.nodeMaxEntries);
            this.noteRepChange(targets);
            return (INTargetRep)((INArrayRep)targets).set(idx, node);
        }

        public int length() {
            return this.nodeMaxEntries;
        }

        public INTargetRep copy(int from, int to, int n) {
            return this;
        }

        public long calculateMemorySize() {
            return MemoryBudget.NULL_TARGET_ENTRY_OVERHEAD;
        }

        public INTargetRep compact() {
            return this;
        }

        public void updateCacheStats(boolean increment, Evictor evictor) {
            if (increment) {
                evictor.getNINNoTarget().incrementAndGet();
            } else {
                evictor.getNINNoTarget().decrementAndGet();
            }
        }
    }

    public static class Sparse
    extends INTargetRep {
        public static final int MAX_ENTRIES = 4;
        public static final int MAX_INDEX = Short.MAX_VALUE;
        final int nodeMaxEntries;
        final short[] idxs = new short[4];
        final Node[] targets = new Node[4];

        public Type getType() {
            return Type.SPARSE;
        }

        public long calculateMemorySize() {
            return MemoryBudget.SPARSE_TARGET_ENTRY_OVERHEAD;
        }

        public Sparse(IN parent, int capacity) {
            super(parent);
            this.nodeMaxEntries = capacity;
            this.idxs[3] = -1;
            this.idxs[2] = -1;
            this.idxs[1] = -1;
            this.idxs[0] = -1;
        }

        public Sparse(SizeofMarker marker) {
            super(null);
            this.nodeMaxEntries = 0;
        }

        public INTargetRep copy(int from, int to, int n) {
            INTargetRep target;
            block4: {
                target = this;
                if (to == from || n == 0) break block4;
                if (to < from) {
                    for (int i = 0; i < n; ++i) {
                        target = (INTargetRep)((INArrayRep)target).set(to++, this.get(from++));
                    }
                } else {
                    from += n;
                    to += n;
                    for (int i = 0; i < n; ++i) {
                        target = (INTargetRep)((INArrayRep)target).set(--to, this.get(--from));
                    }
                }
            }
            return target;
        }

        public Node get(int j) {
            assert (j >= 0 && j <= Short.MAX_VALUE);
            if (j >= this.nodeMaxEntries) {
                throw new IndexOutOfBoundsException("index:" + j + "exceeds capacity:" + this.nodeMaxEntries);
            }
            if (this.idxs[0] == j) {
                return this.targets[0];
            }
            if (this.idxs[1] == j) {
                return this.targets[1];
            }
            if (this.idxs[2] == j) {
                return this.targets[2];
            }
            if (this.idxs[3] == j) {
                return this.targets[3];
            }
            return null;
        }

        public int length() {
            return this.nodeMaxEntries;
        }

        public INTargetRep set(int j, Node node) {
            assert (j >= 0 && j <= Short.MAX_VALUE);
            if (j >= this.nodeMaxEntries) {
                throw new ArrayIndexOutOfBoundsException("j:" + j + " >= " + "capacity: " + this.nodeMaxEntries);
            }
            int slot = -1;
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.idxs[i] == j) {
                    this.targets[i] = node;
                    return this;
                }
                if (slot >= 0 || this.targets[i] != null) continue;
                slot = i;
            }
            if (slot >= 0) {
                this.targets[slot] = node;
                this.idxs[slot] = (short)j;
                return this;
            }
            Default fe = new Default(this.parent, this.nodeMaxEntries);
            this.noteRepChange(fe);
            for (int i = 0; i < this.targets.length; ++i) {
                if (this.targets[i] == null) continue;
                fe.set((int)this.idxs[i], this.targets[i]);
            }
            return fe.set(j, node);
        }

        public INTargetRep compact() {
            int count = 0;
            for (Node target : this.targets) {
                if (target == null) continue;
                ++count;
            }
            if (count == 0) {
                None newRep = new None(this.parent, this.nodeMaxEntries);
                this.noteRepChange(newRep);
                return newRep;
            }
            return this;
        }

        public void updateCacheStats(boolean increment, Evictor evictor) {
            long stat;
            long l = stat = increment ? evictor.getNINSparseTarget().incrementAndGet() : evictor.getNINSparseTarget().decrementAndGet();
            assert (stat >= 0L);
        }
    }

    public static class Default
    extends INTargetRep {
        private final Node[] targets;

        public Type getType() {
            return Type.DEFAULT;
        }

        public long calculateMemorySize() {
            return MemoryBudget.DEFAULT_TARGET_ENTRY_OVERHEAD + MemoryBudget.objectArraySize(this.targets.length);
        }

        public Default(IN parent, int capacity) {
            super(parent);
            this.targets = new Node[capacity];
        }

        public Default(SizeofMarker marker) {
            super(null);
            this.targets = null;
        }

        public Node get(int idx) {
            return this.targets[idx];
        }

        public INTargetRep set(int idx, Node node) {
            this.targets[idx] = node;
            return this;
        }

        public int length() {
            return this.targets.length;
        }

        public INTargetRep copy(int from, int to, int n) {
            System.arraycopy(this.targets, from, this.targets, to, n);
            return this;
        }

        public INTargetRep compact() {
            int count = 0;
            for (Node target : this.targets) {
                if (target == null) continue;
                ++count;
            }
            if (count > 4 || this.targets.length > Short.MAX_VALUE) {
                return this;
            }
            INTargetRep newRep = null;
            if (count == 0) {
                newRep = new None(this.parent, this.targets.length);
            } else {
                newRep = new Sparse(this.parent, this.targets.length);
                for (int i = 0; i < this.targets.length; ++i) {
                    if (this.targets[i] == null) continue;
                    newRep.set(i, this.targets[i]);
                }
            }
            this.noteRepChange(newRep);
            return newRep;
        }

        public void updateCacheStats(boolean increment, Evictor evictor) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DEFAULT,
        SPARSE,
        NONE;

    }
}

