/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jax_ws_commons.jaxws;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.jvnet.jax_ws_commons.jaxws.AbstractWsGenMojo;

@Mojo(name="wsdlgen", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.RUNTIME)
public class WsdlGenMojo
extends AbstractWsGenMojo {
    @Parameter(defaultValue="${project.build.directory}/generated-sources/wsdl")
    private File resourceDestDir;

    @Override
    protected File getResourceDestDir() {
        return this.resourceDestDir;
    }

    @Override
    protected File getClassesDir() {
        return new File(this.project.getBuild().getOutputDirectory());
    }

    @Override
    protected File getDestDir() {
        return this.resourceDestDir;
    }

    @Override
    protected File getSourceDestDir() {
        return this.getDefaultSrcOut();
    }

    @Override
    protected boolean getGenWSDL() {
        return true;
    }

    @Override
    protected File getDefaultSrcOut() {
        return new File(this.project.getBuild().getDirectory(), "generated-sources/wsgen");
    }

    @Override
    protected void processSei(String sei) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Processing: " + sei));
        List<String> args = this.getWsGenArgs(sei, false);
        args.add("-Xnosource");
        this.getLog().info((CharSequence)("jaxws:wsgen args: " + args));
        this.exec(args);
    }
}

