/*
 * Decompiled with CFR 0.152.
 */
package de.is24.maven.enforcer.rules;

import de.is24.maven.enforcer.rules.ArtifactRepositoryAnalyzer;
import de.is24.maven.enforcer.rules.ClassFilter;
import de.is24.maven.enforcer.rules.Repository;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.StringUtils;

public final class IllegalTransitiveDependencyCheck
implements EnforcerRule {
    private static final String NO_CACHE_ID_AVAILABLE = null;
    private static final String OUTPUT_FILE_EXTENSION = ".txt";
    private static final String OUTPUT_FILE_PREFIX = "itd-";
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private DependencyGraphBuilder dependencyGraphBuilder;
    private List<ArtifactRepository> remoteRepositories;
    private String outputDirectory;
    private MavenProject project;
    private Log logger;
    private boolean reportOnly;
    private boolean listMissingArtifacts;
    private String[] regexIgnoredClasses;
    private boolean useClassesFromLastBuild;
    private boolean suppressTypesFromJavaRuntime;
    private ClassFilter filter;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        this.logger = helper.getLog();
        if (this.reportOnly) {
            this.logger.info((CharSequence)"Flag 'reportOnly' is set. Exceptions from rule will only be reported!");
        }
        if (this.listMissingArtifacts) {
            this.logger.info((CharSequence)"Flag 'listMissingArtifacts' is set. Transitively used artifacts are resolved.");
            this.initializeDependencyGraphBuilder(helper);
        }
        if (this.useClassesFromLastBuild) {
            this.logger.info((CharSequence)"Flag 'useClassesFromLastBuild' is set. Try to use existing output folder.");
        }
        if (this.suppressTypesFromJavaRuntime) {
            this.logger.info((CharSequence)"Flag 'suppressTypesFromJavaRuntime' is set. Classes available in current Java-runtime will be ignored.");
        }
        this.initializeArtifactResolver(helper);
        this.initializeProject((ExpressionEvaluator)helper);
        Artifact artifact = this.resolveArtifact();
        if (artifact.getFile() == null) {
            this.logger.info((CharSequence)("Nothing to analyze in '" + artifact.getId() + "'."));
            return;
        }
        this.filter = new ClassFilter(this.logger, this.suppressTypesFromJavaRuntime, this.regexIgnoredClasses);
        Repository artifactClassesRepository = ArtifactRepositoryAnalyzer.analyzeArtifacts(this.logger, true, this.filter).analyzeArtifacts(Collections.singleton(artifact));
        Set<Artifact> dependencies = this.resolveDirectDependencies(artifact);
        Repository dependenciesClassesRepository = ArtifactRepositoryAnalyzer.analyzeArtifacts(this.logger, false, this.filter).analyzeArtifacts(dependencies);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("Artifact's type dependencies are: " + artifactClassesRepository.getDependencies()));
            this.logger.debug((CharSequence)("Classes defined in direct dependencies are: " + dependenciesClassesRepository.getTypes()));
        }
        HashSet<String> unresolvedTypes = new HashSet<String>(artifactClassesRepository.getDependencies());
        unresolvedTypes.removeAll(artifactClassesRepository.getTypes());
        unresolvedTypes.removeAll(dependenciesClassesRepository.getTypes());
        if (unresolvedTypes.isEmpty()) {
            this.logger.info((CharSequence)("No illegal transitive dependencies found in '" + artifact.getId() + "'."));
        } else {
            String message = this.buildOutput(artifact, unresolvedTypes);
            this.writeOutputFile(artifact, message);
            if (this.reportOnly) {
                this.logger.error((CharSequence)message);
            } else {
                throw new EnforcerRuleException(message);
            }
        }
    }

    private Set<Artifact> resolveTransitiveDependencies(Artifact artifact) throws EnforcerRuleException {
        DependencyNode root;
        try {
            root = this.dependencyGraphBuilder.buildDependencyGraph(this.project, null);
        }
        catch (DependencyGraphBuilderException e) {
            throw new EnforcerRuleException("Unable to build the dependency graph!", (Exception)((Object)e));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("Root node is '" + root + "'."));
        }
        HashSet<Artifact> transitiveDependencies = new HashSet<Artifact>();
        this.traverseDependencyNodes(root, transitiveDependencies);
        Set<Artifact> directDependencies = this.resolveDirectDependencies(artifact);
        transitiveDependencies.removeAll(directDependencies);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("Transitive dependencies are '" + transitiveDependencies + "'."));
        }
        return transitiveDependencies;
    }

    private void traverseDependencyNodes(DependencyNode node, Set<Artifact> transitiveDependencies) throws EnforcerRuleException {
        List children = node.getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        for (DependencyNode child : children) {
            Artifact artifact = child.getArtifact();
            this.enforceArtifactResolution(artifact);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((CharSequence)("Add dependency '" + artifact.getId() + "'"));
            }
            transitiveDependencies.add(artifact);
            this.traverseDependencyNodes(child, transitiveDependencies);
        }
    }

    private Set<Artifact> resolveDirectDependencies(Artifact artifact) {
        HashSet<Artifact> dependencies = new HashSet<Artifact>(this.project.getDependencyArtifacts());
        dependencies.remove(artifact);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)("Direct dependencies are '" + dependencies + "'."));
        }
        return dependencies;
    }

    private void initializeProject(ExpressionEvaluator helper) throws EnforcerRuleException {
        try {
            this.project = (MavenProject)helper.evaluate("${project}");
            this.localRepository = (ArtifactRepository)helper.evaluate("${localRepository}");
            this.remoteRepositories = (List)helper.evaluate("${project.remoteArtifactRepositories}");
            this.outputDirectory = (String)helper.evaluate("${project.build.directory}");
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to locate Maven project and/or repositories!", (Exception)((Object)e));
        }
        this.logger.debug((CharSequence)("Analyze project '" + this.project + "'."));
    }

    private void initializeArtifactResolver(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            this.resolver = (ArtifactResolver)helper.getComponent(ArtifactResolver.class);
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup artifact resolver!", (Exception)((Object)e));
        }
    }

    private void initializeDependencyGraphBuilder(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            this.dependencyGraphBuilder = (DependencyGraphBuilder)helper.getContainer().lookup(DependencyGraphBuilder.class, "default");
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup dependency graph builder!", (Exception)((Object)e));
        }
    }

    private Artifact resolveArtifact() throws EnforcerRuleException {
        Artifact artifact = this.project.getArtifact();
        this.logger.info((CharSequence)("Analyze dependencies of artifact '" + artifact.getId() + "'."));
        if (this.useClassesFromLastBuild) {
            File targetClassesDirectory = this.getTargetClassesDirectory();
            artifact.setFile(targetClassesDirectory);
            return artifact;
        }
        return this.enforceArtifactResolution(artifact);
    }

    private File getTargetClassesDirectory() {
        File targetClasses;
        String classesOutputDirectory;
        Build build = this.project.getBuild();
        if (build != null && StringUtils.isNotEmpty((String)(classesOutputDirectory = build.getOutputDirectory())) && (targetClasses = new File(classesOutputDirectory)).isDirectory() && targetClasses.list().length > 0) {
            this.logger.debug((CharSequence)("Found valid target/classes directory '" + targetClasses.getAbsolutePath() + "'."));
            return targetClasses;
        }
        this.logger.debug((CharSequence)"No target/classes directory found.");
        return null;
    }

    private Artifact enforceArtifactResolution(Artifact artifact) throws EnforcerRuleException {
        this.logger.debug((CharSequence)("Enforce artifact resolution for project '" + this.project + "'."));
        try {
            this.resolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            return artifact;
        }
        catch (AbstractArtifactResolutionException e) {
            String error = "Unable to resolve artifact '" + artifact.getId() + "'!";
            this.logger.error((CharSequence)error, (Throwable)e);
            throw new EnforcerRuleException(error, (Exception)((Object)e));
        }
    }

    private String buildOutput(Artifact artifact, Set<String> unresolvedTypes) throws EnforcerRuleException {
        StringBuilder output = new StringBuilder();
        output.append("Found ").append(unresolvedTypes.size()).append(" illegal transitive type dependencies in artifact '").append(artifact.getId()).append("':\n");
        ArrayList<String> illegalTransitiveDependencies = this.listMissingArtifacts ? new ArrayList<String>(this.findArtifactsForUnresolvedTypes(artifact, unresolvedTypes)) : new ArrayList<String>(unresolvedTypes);
        Collections.sort(illegalTransitiveDependencies);
        int k = 1;
        for (String illegalTransitiveDependency : illegalTransitiveDependencies) {
            output.append(k).append(".) ").append(illegalTransitiveDependency).append("\n");
            ++k;
        }
        return output.toString();
    }

    private Set<String> findArtifactsForUnresolvedTypes(Artifact artifact, Set<String> unresolvedTypes) throws EnforcerRuleException {
        Set<Artifact> transitiveDependencies = this.resolveTransitiveDependencies(artifact);
        HashSet<String> unresolvedTypesWithArtifact = new HashSet<String>();
        for (Artifact transitiveDependency : transitiveDependencies) {
            if (unresolvedTypesWithArtifact.size() == unresolvedTypes.size()) break;
            Repository repository = ArtifactRepositoryAnalyzer.analyzeArtifacts(this.logger, false, this.filter).analyzeArtifacts(Collections.singleton(transitiveDependency));
            Set<String> repositoryTypes = repository.getTypes();
            for (String unresolvedType : unresolvedTypes) {
                if (!repositoryTypes.contains(unresolvedType)) continue;
                unresolvedTypesWithArtifact.add(unresolvedType + ", [" + transitiveDependency.getId() + "]");
            }
        }
        return unresolvedTypesWithArtifact;
    }

    private void writeOutputFile(Artifact artifact, String output) throws EnforcerRuleException {
        if (this.outputDirectory == null) {
            this.logger.warn((CharSequence)"Project's output directory has not been set, skip writing!");
            return;
        }
        String outputFilePath = this.determineOutputFilePath(artifact);
        File outputFile = new File(outputFilePath);
        File targetFolder = outputFile.getParentFile();
        if (!targetFolder.exists() && !targetFolder.mkdirs()) {
            String error = "Unable to create directory '" + targetFolder + "'!";
            this.logger.error((CharSequence)error);
            throw new EnforcerRuleException(error);
        }
        FileWriter resultFileWriter = null;
        try {
            resultFileWriter = new FileWriter(outputFile);
            resultFileWriter.write(output);
        }
        catch (IOException e) {
            throw this.logAndWrapIOException(e, outputFilePath);
        }
        finally {
            if (resultFileWriter != null) {
                try {
                    resultFileWriter.close();
                }
                catch (IOException e) {
                    throw this.logAndWrapIOException(e, outputFilePath);
                }
            }
        }
    }

    private EnforcerRuleException logAndWrapIOException(IOException e, String outputFilePath) {
        String error = "Unable to write output file '" + outputFilePath + "'!";
        this.logger.error((CharSequence)error, (Throwable)e);
        return new EnforcerRuleException(error, (Exception)e);
    }

    private String determineOutputFilePath(Artifact artifact) {
        String separator = this.outputDirectory.endsWith("/") ? "" : "/";
        String formattedArtifactId = artifact.getId().replace(':', '-');
        return this.outputDirectory + separator + OUTPUT_FILE_PREFIX + formattedArtifactId + OUTPUT_FILE_EXTENSION;
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule enforcerRule) {
        return false;
    }

    public String getCacheId() {
        return NO_CACHE_ID_AVAILABLE;
    }

    public void setListMissingArtifacts(boolean listMissingArtifacts) {
        this.listMissingArtifacts = listMissingArtifacts;
    }

    public void setReportOnly(boolean reportOnly) {
        this.reportOnly = reportOnly;
    }

    public void setRegexIgnoredClasses(String[] regexIgnoredClasses) {
        this.regexIgnoredClasses = regexIgnoredClasses;
    }

    public void setUseClassesFromLastBuild(boolean useClassesFromLastBuild) {
        this.useClassesFromLastBuild = useClassesFromLastBuild;
    }

    public void setSuppressTypesFromJavaRuntime(boolean suppressTypesFromJavaRuntime) {
        this.suppressTypesFromJavaRuntime = suppressTypesFromJavaRuntime;
    }
}

