/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.builditem.CompiledJavaVersionBuildItem;
import io.quarkus.deployment.pkg.steps.NativeImageBuildRunner;
import io.quarkus.deployment.util.ProcessUtil;
import io.quarkus.runtime.util.ContainerRuntimeUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.jboss.logging.Logger;

public abstract class NativeImageBuildContainerRunner
extends NativeImageBuildRunner {
    private static final Logger log = Logger.getLogger(NativeImageBuildContainerRunner.class);
    final NativeConfig nativeConfig;
    protected final ContainerRuntimeUtil.ContainerRuntime containerRuntime;
    String[] baseContainerRuntimeArgs;
    protected final String outputPath;
    private final String containerName;
    private final boolean needJava17Image;

    public NativeImageBuildContainerRunner(NativeConfig nativeConfig, Path outputDir, CompiledJavaVersionBuildItem.JavaVersion javaVersion) {
        this.nativeConfig = nativeConfig;
        this.containerRuntime = nativeConfig.containerRuntime.orElseGet(ContainerRuntimeUtil::detectContainerRuntime);
        log.infof("Using %s to run the native image builder", (Object)this.containerRuntime.getExecutableName());
        this.baseContainerRuntimeArgs = new String[]{"--env", "LANG=C", "--rm"};
        this.outputPath = outputDir == null ? null : outputDir.toAbsolutePath().toString();
        this.containerName = "build-native-" + RandomStringUtils.random((int)5, (boolean)true, (boolean)false);
        this.needJava17Image = javaVersion.isExactlyJava11() == CompiledJavaVersionBuildItem.JavaVersion.Status.FALSE;
    }

    @Override
    public void setup(boolean processInheritIODisabled) {
        if (this.containerRuntime == ContainerRuntimeUtil.ContainerRuntime.DOCKER || this.containerRuntime == ContainerRuntimeUtil.ContainerRuntime.PODMAN) {
            String effectiveBuilderImage = this.nativeConfig.getEffectiveBuilderImage(this.needJava17Image);
            log.info((Object)("Checking image status " + effectiveBuilderImage));
            Process pullProcess = null;
            try {
                ProcessBuilder pb = new ProcessBuilder(Arrays.asList(this.containerRuntime.getExecutableName(), "pull", effectiveBuilderImage));
                pullProcess = ProcessUtil.launchProcess(pb, processInheritIODisabled);
                pullProcess.waitFor();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Failed to pull builder image " + effectiveBuilderImage, e);
            }
            finally {
                if (pullProcess != null) {
                    pullProcess.destroy();
                }
            }
        }
    }

    @Override
    protected String[] getGraalVMVersionCommand(List<String> args) {
        return this.buildCommand("run", Collections.singletonList("--rm"), args);
    }

    @Override
    protected String[] getBuildCommand(List<String> args) {
        List<String> containerRuntimeBuildArgs = this.getContainerRuntimeBuildArgs();
        ArrayList<String> effectiveContainerRuntimeBuildArgs = new ArrayList<String>(containerRuntimeBuildArgs.size() + 2);
        effectiveContainerRuntimeBuildArgs.addAll(containerRuntimeBuildArgs);
        effectiveContainerRuntimeBuildArgs.add("--name");
        effectiveContainerRuntimeBuildArgs.add(this.containerName);
        return this.buildCommand("run", effectiveContainerRuntimeBuildArgs, args);
    }

    @Override
    protected void objcopy(String ... args) {
        List<String> containerRuntimeBuildArgs = this.getContainerRuntimeBuildArgs();
        Collections.addAll(containerRuntimeBuildArgs, "--entrypoint", "/bin/bash");
        ArrayList<String> objcopyCommand = new ArrayList<String>(2);
        objcopyCommand.add("-c");
        objcopyCommand.add("objcopy " + String.join((CharSequence)" ", args));
        String[] command = this.buildCommand("run", containerRuntimeBuildArgs, objcopyCommand);
        NativeImageBuildContainerRunner.runCommand(command, null, null);
    }

    @Override
    public void addShutdownHook(Process process) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (process.isAlive()) {
                try {
                    Process removeProcess = new ProcessBuilder(List.of(this.containerRuntime.getExecutableName(), "rm", "-f", this.containerName)).redirectOutput(ProcessBuilder.Redirect.DISCARD).redirectError(ProcessBuilder.Redirect.DISCARD).start();
                    removeProcess.waitFor(2L, TimeUnit.SECONDS);
                }
                catch (IOException | InterruptedException e) {
                    log.debug((Object)"Unable to stop running container", (Throwable)e);
                }
            }
        }));
    }

    protected List<String> getContainerRuntimeBuildArgs() {
        ArrayList<String> containerRuntimeArgs = new ArrayList<String>();
        this.nativeConfig.containerRuntimeOptions.ifPresent(containerRuntimeArgs::addAll);
        if (this.nativeConfig.debugBuildProcess && this.nativeConfig.publishDebugBuildProcessPort) {
            containerRuntimeArgs.add("--publish=5005:5005");
        }
        return containerRuntimeArgs;
    }

    protected String[] buildCommand(String dockerCmd, List<String> containerRuntimeArgs, List<String> command) {
        return (String[])Stream.of(Stream.of(this.containerRuntime.getExecutableName()), Stream.of(dockerCmd), Stream.of(this.baseContainerRuntimeArgs), containerRuntimeArgs.stream(), Stream.of(this.nativeConfig.getEffectiveBuilderImage(this.needJava17Image)), command.stream()).flatMap(Function.identity()).toArray(String[]::new);
    }
}

