/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ServiceStartBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.PackageTypeBuildItem;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class PackageTypeVerificationBuildStep {
    @BuildStep
    List<PackageTypeBuildItem> builtins() {
        return Arrays.asList(new PackageTypeBuildItem("native"), new PackageTypeBuildItem("native-sources"), new PackageTypeBuildItem("jar"), new PackageTypeBuildItem("fast-jar"), new PackageTypeBuildItem("legacy-jar"), new PackageTypeBuildItem("uber-jar"), new PackageTypeBuildItem("mutable-jar"));
    }

    @BuildStep
    ServiceStartBuildItem verify(List<PackageTypeBuildItem> items, PackageConfig config) {
        Set registered = items.stream().map(PackageTypeBuildItem::getType).collect(Collectors.toSet());
        if (!registered.contains(config.type)) {
            throw new IllegalStateException("Unknown packaging type '" + config.type + "' known types are " + registered);
        }
        return null;
    }
}

