/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.ide;

import io.quarkus.dev.console.DevConsoleManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public enum Ide {
    IDEA("idea", null, "--help"),
    ECLIPSE("eclipse", null, null),
    VSCODE("code", null, "--version"),
    NETBEANS("netbeans", null, "--help");

    private final String defaultCommand;
    private final List<String> markerArgs;
    private final String lineNumberArg;
    private String machineSpecificCommand;
    private String effectiveCommand;

    private Ide(String defaultCommand, String lineNumberArg, String ... markerArgs) {
        this.defaultCommand = defaultCommand;
        this.lineNumberArg = lineNumberArg;
        this.markerArgs = markerArgs != null ? Arrays.asList(markerArgs) : Collections.emptyList();
    }

    public String getEffectiveCommand() {
        if (this.effectiveCommand != null) {
            return this.effectiveCommand;
        }
        this.effectiveCommand = this.doGetEffectiveCommand();
        return this.effectiveCommand;
    }

    private String doGetEffectiveCommand() {
        if (this.defaultCommand != null) {
            if (this.markerArgs == null) {
                return this.defaultCommand;
            }
            try {
                ArrayList<String> command = new ArrayList<String>(1 + this.markerArgs.size());
                command.add(this.defaultCommand);
                command.addAll(this.markerArgs);
                new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.DISCARD.file()).redirectOutput(ProcessBuilder.Redirect.DISCARD.file()).start().waitFor(10L, TimeUnit.SECONDS);
                return this.defaultCommand;
            }
            catch (Exception e) {
                return this.machineSpecificCommand;
            }
        }
        return this.machineSpecificCommand;
    }

    public List<String> createFileOpeningArgs(String fileName, String line) {
        if (line == null || line.isEmpty()) {
            return Collections.singletonList(fileName);
        }
        if (this.lineNumberArg == null) {
            return Collections.singletonList(fileName + ":" + line);
        }
        String formattedLineArg = String.format(this.lineNumberArg, line);
        return List.of(formattedLineArg, fileName);
    }

    public void setMachineSpecificCommand(String machineSpecificCommand) {
        this.machineSpecificCommand = machineSpecificCommand;
    }

    public static Path findSourceFile(String fileName) {
        for (Path i : DevConsoleManager.getHotReplacementContext().getSourcesDir()) {
            Path resolved = i.resolve(fileName);
            if (!Files.exists(resolved, new LinkOption[0])) continue;
            return resolved;
        }
        return null;
    }

    public String toString() {
        return "Ide{defaultCommand='" + this.defaultCommand + "'}";
    }
}

