/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.datasource.deployment.spi;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public final class DevServicesDatasourceConfigurationHandlerBuildItem
extends MultiBuildItem {
    private final String dbKind;
    private final BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>> configProviderFunction;
    private final Predicate<String> checkConfiguredFunction;

    public DevServicesDatasourceConfigurationHandlerBuildItem(String dbKind, BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>> configProviderFunction, Predicate<String> checkConfiguredFunction) {
        this.dbKind = dbKind;
        this.configProviderFunction = configProviderFunction;
        this.checkConfiguredFunction = checkConfiguredFunction;
    }

    public BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>> getConfigProviderFunction() {
        return this.configProviderFunction;
    }

    public String getDbKind() {
        return this.dbKind;
    }

    public Predicate<String> getCheckConfiguredFunction() {
        return this.checkConfiguredFunction;
    }

    public static DevServicesDatasourceConfigurationHandlerBuildItem jdbc(String dbKind) {
        return new DevServicesDatasourceConfigurationHandlerBuildItem(dbKind, new BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>>(){

            @Override
            public Map<String, String> apply(String dsName, DevServicesDatasourceProvider.RunningDevServicesDatasource runningDevDb) {
                if (dsName == null) {
                    return Collections.singletonMap("quarkus.datasource.jdbc.url", runningDevDb.getUrl());
                }
                return Map.of(DevServicesDatasourceConfigurationHandlerBuildItem.datasourceURLPropName(dsName), runningDevDb.getUrl(), DevServicesDatasourceConfigurationHandlerBuildItem.datasourceURLPropName("\"" + dsName + "\""), runningDevDb.getUrl());
            }
        }, new Predicate<String>(){

            @Override
            public boolean test(String dsName) {
                if (dsName == null) {
                    return ConfigUtils.isPropertyPresent((String)"quarkus.datasource.jdbc.url");
                }
                return ConfigUtils.isPropertyPresent((String)DevServicesDatasourceConfigurationHandlerBuildItem.datasourceURLPropName(dsName)) || ConfigUtils.isPropertyPresent((String)DevServicesDatasourceConfigurationHandlerBuildItem.datasourceURLPropName("\"" + dsName + "\""));
            }
        });
    }

    private static String datasourceURLPropName(String dsName) {
        return String.format("quarkus.datasource.%s.jdbc.url", dsName);
    }

    public static DevServicesDatasourceConfigurationHandlerBuildItem reactive(String dbKind) {
        return new DevServicesDatasourceConfigurationHandlerBuildItem(dbKind, new BiFunction<String, DevServicesDatasourceProvider.RunningDevServicesDatasource, Map<String, String>>(){

            @Override
            public Map<String, String> apply(String dsName, DevServicesDatasourceProvider.RunningDevServicesDatasource runningDevDb) {
                if (dsName == null) {
                    return Collections.singletonMap("quarkus.datasource.reactive.url", runningDevDb.getUrl().replaceFirst("jdbc:", "vertx-reactive:"));
                }
                return Collections.singletonMap("quarkus.datasource.\"" + dsName + "\".reactive.url", runningDevDb.getUrl().replaceFirst("jdbc:", "vertx-reactive:"));
            }
        }, new Predicate<String>(){

            @Override
            public boolean test(String dsName) {
                if (dsName == null) {
                    return ConfigUtils.isPropertyPresent((String)"quarkus.datasource.reactive.url");
                }
                return ConfigUtils.isPropertyPresent((String)("quarkus.datasource.\"" + dsName + "\".reactive.url")) || ConfigUtils.isPropertyPresent((String)("quarkus.datasource." + dsName + ".reactive.url"));
            }
        });
    }
}

